/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.browser.view;

import com.lightcrafts.ui.browser.model.ImageDatum;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

class ImageDatumTransferable
implements Transferable {
    private List<ImageDatum> datums;

    ImageDatumTransferable(Collection<ImageDatum> datums) {
        this.datums = new LinkedList<ImageDatum>(datums);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{DataFlavor.javaFileListFlavor, DataFlavor.stringFlavor};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return DataFlavor.javaFileListFlavor.equals(flavor) || DataFlavor.stringFlavor.equals(flavor);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        LinkedList<File> files = new LinkedList<File>();
        for (ImageDatum datum : this.datums) {
            File file = datum.getFile();
            files.add(file);
        }
        if (DataFlavor.javaFileListFlavor.equals(flavor)) {
            return files;
        }
        if (DataFlavor.stringFlavor.equals(flavor)) {
            StringBuffer buffer = new StringBuffer();
            for (File file : files) {
                String path = file.getAbsolutePath();
                buffer.append(path);
                buffer.append(" ");
            }
            return buffer.toString();
        }
        throw new UnsupportedFlavorException(flavor);
    }

    List<ImageDatum> getImageDatums() {
        return new LinkedList<ImageDatum>(this.datums);
    }
}

