/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.browser.view;

import com.lightcrafts.ui.browser.model.ImageDatum;
import com.lightcrafts.ui.browser.view.AbstractImageBrowser;
import com.lightcrafts.ui.browser.view.Locale;
import com.lightcrafts.ui.browser.view.SelectionAction;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.KeyStroke;

class RatingActions {
    RatingActions() {
    }

    static List<SelectionAction> createAllActions(AbstractImageBrowser browser, boolean dynamic) {
        ArrayList<SelectionAction> actions = new ArrayList<SelectionAction>();
        actions.addAll(RatingActions.createRatingActions(browser, dynamic));
        actions.add(RatingActions.createClearRatingAction(browser, dynamic));
        return actions;
    }

    static SelectionAction createClearRatingAction(final AbstractImageBrowser browser, boolean dynamic) {
        SelectionAction action = new SelectionAction(Locale.LOCALE.get("ClearRatingAction"), browser, KeyStroke.getKeyStroke(48, 0), dynamic, true){

            @Override
            public void actionPerformed(ActionEvent e) {
                RatingActions.clearRating(browser);
            }
        };
        return action;
    }

    static List<SelectionAction> createRatingActions(AbstractImageBrowser browser, boolean dynamic) {
        ArrayList<SelectionAction> actions = new ArrayList<SelectionAction>();
        for (int rating = 1; rating <= 5; ++rating) {
            SelectionAction action = RatingActions.createRatingAction(browser, rating, dynamic);
            actions.add(action);
        }
        return actions;
    }

    private static String createStars(int rating) {
        StringBuffer buffer = new StringBuffer();
        for (int n = 0; n < rating; ++n) {
            buffer.append('\u2605');
        }
        return buffer.toString();
    }

    static SelectionAction createRatingAction(final AbstractImageBrowser browser, final int rating, boolean dynamic) {
        String stars = RatingActions.createStars(rating);
        SelectionAction action = new SelectionAction(stars, browser, KeyStroke.getKeyStroke(48 + rating, 0), dynamic, true){

            @Override
            public void actionPerformed(ActionEvent e) {
                RatingActions.setRating(browser, rating);
            }
        };
        return action;
    }

    static void setRating(AbstractImageBrowser browser, int rating) {
        ArrayList<ImageDatum> datums = browser.getSelectedDatums();
        for (ImageDatum datum : datums) {
            try {
                datum.setRating(rating);
            }
            catch (Throwable t) {
                browser.notifyError(t.getMessage());
                File file = datum.getFile();
                System.err.println("Couldn't set rating on " + file.getAbsolutePath() + ": ");
                t.printStackTrace();
            }
        }
    }

    static boolean setRating(ImageDatum datum, int rating, AbstractImageBrowser browser) {
        try {
            datum.setRating(rating);
            return true;
        }
        catch (Throwable t) {
            browser.notifyError(t.getMessage());
            File file = datum.getFile();
            System.err.println("Couldn't set rating on " + file.getAbsolutePath() + ": ");
            t.printStackTrace();
            return false;
        }
    }

    static boolean clearRating(ImageDatum datum, AbstractImageBrowser browser) {
        try {
            datum.clearRating();
            return true;
        }
        catch (Throwable t) {
            browser.notifyError(t.getMessage());
            File file = datum.getFile();
            System.err.println("Couldn't clear rating on " + file.getAbsolutePath() + ": ");
            t.printStackTrace();
            return false;
        }
    }

    static void clearRating(AbstractImageBrowser browser) {
        ArrayList<ImageDatum> datums = browser.getSelectedDatums();
        for (ImageDatum datum : datums) {
            File file = datum.getFile();
            try {
                datum.clearRating();
            }
            catch (Throwable t) {
                browser.notifyError(t.getMessage());
                System.err.println("Couldn't clear rating on " + file.getAbsolutePath() + ": ");
                t.printStackTrace();
            }
        }
    }
}

