/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.crop;

import com.lightcrafts.model.CropBounds;
import com.lightcrafts.ui.crop.Locale;
import java.awt.geom.Point2D;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class AspectConstraint {
    private static final String NoConstraintName = Locale.LOCALE.get("NoConstraintName");
    private int numerator;
    private int denominator;
    private String name;

    AspectConstraint() {
        this.name = NoConstraintName;
    }

    AspectConstraint(int numerator, int denominator) {
        this.numerator = numerator;
        this.denominator = denominator;
        this.name = "" + denominator + " x " + numerator;
    }

    AspectConstraint getInverse() {
        if (this.name.equals(NoConstraintName)) {
            return new AspectConstraint();
        }
        return new AspectConstraint(this.denominator, this.numerator);
    }

    public String toString() {
        return this.name;
    }

    static AspectConstraint fromString(String s) {
        if (s.equals(NoConstraintName)) {
            return new AspectConstraint();
        }
        Pattern pattern = Pattern.compile("([0-9]+) x ([0-9]+)");
        Matcher matcher = pattern.matcher(s);
        if (!matcher.matches()) {
            return null;
        }
        String numText = matcher.replaceAll("$1");
        String denText = matcher.replaceAll("$2");
        int num = Integer.parseInt(numText);
        int den = Integer.parseInt(denText);
        return new AspectConstraint(num, den);
    }

    double getAspectRatio() {
        return (double)this.numerator / (double)this.denominator;
    }

    int getNumerator() {
        return this.numerator;
    }

    int getDenominator() {
        return this.denominator;
    }

    AspectConstraint transpose() {
        return new AspectConstraint(this.denominator, this.numerator);
    }

    CropBounds adjust(CropBounds bad) {
        if (this.isNoConstraint()) {
            return bad;
        }
        double ratio = this.getAspectRatio();
        double area = bad.getWidth() * bad.getHeight();
        Point2D center = bad.getCenter();
        double width = Math.sqrt(area / ratio);
        double height = Math.sqrt(area * ratio);
        double angle = bad.getAngle();
        CropBounds good = new CropBounds(center, width, height, angle);
        return good;
    }

    CropBounds adjustLeft(CropBounds bad) {
        if (this.isNoConstraint()) {
            return bad;
        }
        double ratio = this.getAspectRatio();
        double badW = bad.getWidth();
        double goodW = bad.getHeight() / ratio;
        double angle = bad.getAngle();
        double dx = -Math.cos(angle) * (goodW - badW) / 2.0;
        double dy = -Math.sin(angle) * (goodW - badW) / 2.0;
        Point2D center = bad.getCenter();
        center.setLocation(center.getX() + dx, center.getY() + dy);
        CropBounds good = new CropBounds(center, goodW, bad.getHeight(), angle);
        return good;
    }

    CropBounds adjustTop(CropBounds bad) {
        if (this.isNoConstraint()) {
            return bad;
        }
        double ratio = this.getAspectRatio();
        double badH = bad.getHeight();
        double goodH = bad.getWidth() * ratio;
        double angle = bad.getAngle();
        double dx = Math.sin(angle) * (goodH - badH) / 2.0;
        double dy = -Math.cos(angle) * (goodH - badH) / 2.0;
        Point2D center = bad.getCenter();
        center.setLocation(center.getX() + dx, center.getY() + dy);
        CropBounds good = new CropBounds(center, bad.getWidth(), goodH, angle);
        return good;
    }

    CropBounds adjustRight(CropBounds bad) {
        if (this.isNoConstraint()) {
            return bad;
        }
        double ratio = this.getAspectRatio();
        double badW = bad.getWidth();
        double goodW = bad.getHeight() / ratio;
        double angle = bad.getAngle();
        double dx = Math.cos(angle) * (goodW - badW) / 2.0;
        double dy = Math.sin(angle) * (goodW - badW) / 2.0;
        Point2D center = bad.getCenter();
        center.setLocation(center.getX() + dx, center.getY() + dy);
        CropBounds good = new CropBounds(center, goodW, bad.getHeight(), angle);
        return good;
    }

    CropBounds adjustBottom(CropBounds bad) {
        if (this.isNoConstraint()) {
            return bad;
        }
        double ratio = this.getAspectRatio();
        double badH = bad.getHeight();
        double goodH = bad.getWidth() * ratio;
        double angle = bad.getAngle();
        double dx = -Math.sin(angle) * (goodH - badH) / 2.0;
        double dy = Math.cos(angle) * (goodH - badH) / 2.0;
        Point2D center = bad.getCenter();
        center.setLocation(center.getX() + dx, center.getY() + dy);
        CropBounds good = new CropBounds(center, bad.getWidth(), goodH, angle);
        return good;
    }

    CropBounds adjustWidth(CropBounds bad) {
        if (this.isNoConstraint()) {
            return bad;
        }
        double ratio = this.getAspectRatio();
        Point2D center = bad.getCenter();
        double height = bad.getHeight();
        double width = height / ratio;
        double angle = bad.getAngle();
        CropBounds good = new CropBounds(center, width, height, angle);
        return good;
    }

    CropBounds adjustHeight(CropBounds bad) {
        if (this.isNoConstraint()) {
            return bad;
        }
        double ratio = this.getAspectRatio();
        Point2D center = bad.getCenter();
        double width = bad.getWidth();
        double height = width * ratio;
        double angle = bad.getAngle();
        CropBounds good = new CropBounds(center, width, height, angle);
        return good;
    }

    boolean isNoConstraint() {
        return this.numerator == 0 && this.denominator == 0;
    }
}

