/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.crop;

import com.lightcrafts.model.CropBounds;
import com.lightcrafts.platform.Platform;
import com.lightcrafts.ui.crop.AspectConstraint;
import com.lightcrafts.ui.crop.ConstraintMenu;
import com.lightcrafts.ui.crop.ConstraintModel;
import com.lightcrafts.ui.crop.CropOverlay;
import com.lightcrafts.ui.crop.LockButton;
import com.lightcrafts.ui.crop.NumberTextField;
import com.lightcrafts.ui.crop.ResetAction;
import com.lightcrafts.ui.crop.ResetButton;
import com.lightcrafts.ui.crop.TransposeButton;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.UIManager;

public final class CropControl
extends Box {
    private ConstraintModel constraints;
    private ResetButton resetButton;
    private LockButton lockButton;
    private ResetAction reset;

    CropControl(ResetAction reset, boolean isRotateOnly) {
        super(0);
        this.reset = reset;
        this.constraints = new ConstraintModel();
        ConstraintMenu aspectMenu = new ConstraintMenu(this.constraints);
        NumberTextField numField = new NumberTextField(this.constraints.getNumeratorListener());
        NumberTextField denField = new NumberTextField(this.constraints.getDenominatorListener());
        TransposeButton transposeButton = new TransposeButton(this.constraints);
        this.constraints.setNumeratorTextField(numField);
        this.constraints.setDenominatorTextField(denField);
        this.constraints.setTransposeButton(transposeButton);
        this.constraints.setConstraintMenu(aspectMenu);
        this.lockButton = new LockButton(this.constraints);
        this.resetButton = new ResetButton(reset, isRotateOnly);
        this.add(denField);
        this.add(Box.createHorizontalStrut(2));
        this.add(transposeButton);
        this.add(Box.createHorizontalStrut(2));
        this.add(numField);
        this.add(Box.createHorizontalStrut(2));
        this.add(this.lockButton);
        this.add(Box.createHorizontalStrut(2));
        this.add(aspectMenu);
        this.add(Box.createHorizontalStrut(2));
        this.add(this.resetButton);
    }

    public JComponent getResetButton() {
        return this.resetButton;
    }

    void setResetValue(CropBounds resetValue) {
        this.reset.setResetValue(resetValue);
    }

    void unlock() {
        if (this.lockButton.isSelected()) {
            this.lockButton.doClick();
        }
    }

    CropBounds getResetValue() {
        return this.reset.getResetValue();
    }

    void setOverlay(CropOverlay overlay) {
        this.constraints.setOverlay(overlay);
        this.reset.setOverlay(overlay);
        AspectConstraint constraint = this.constraints.getAspectConstraint();
        overlay.setAspectConstraint(constraint);
    }

    public static void main(String[] args) throws Exception {
        UIManager.setLookAndFeel(Platform.getPlatform().getLookAndFeel());
        ResetAction reset = new ResetAction();
        CropControl ctrl = new CropControl(reset, false);
        JFrame frame = new JFrame("Crop Test");
        frame.getContentPane().add(ctrl);
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }
}

