/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.crop;

import com.lightcrafts.mediax.jai.Interpolation;
import com.lightcrafts.mediax.jai.RenderedOp;
import com.lightcrafts.mediax.jai.operator.RotateDescriptor;
import com.lightcrafts.model.CropBounds;
import com.lightcrafts.platform.Platform;
import com.lightcrafts.ui.crop.AspectConstraint;
import com.lightcrafts.ui.crop.RotateLimitDimension;
import com.lightcrafts.ui.crop.UnderlayConstraints;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.KeyEventPostProcessor;
import java.awt.KeyboardFocusManager;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Area;
import java.awt.geom.Dimension2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;

class CropOverlay
extends JComponent
implements MouseInputListener,
MouseWheelListener {
    private static final Stroke RectStroke = new BasicStroke(20.0f);
    private static final Color RectColor = new Color(0, 0, 0, 128);
    private static final Color GridColor = new Color(100, 100, 100, 128);
    private static final Color RectBorderColor = Color.white;
    private static final Cursor CropCursor;
    private static final Cursor MoveCursor;
    private static final Cursor MovingCursor;
    private static final Cursor RotateCursor;
    private static final Cursor RotatingCursor;
    private static final ResourceBundle HotPointResources;
    private static final int MinDragDistance = 10;
    private CropBounds crop;
    private Rectangle2D underlayRect;
    private AspectConstraint constraint;
    private Point2D relativePoll;
    private Cursor cursor;
    private Point dragStart;
    private boolean isRotating;
    private double rotateAngleStart;
    private Point rotateMouseStart;
    private double rotateWidthLimit;
    private double rotateHeightLimit;
    private boolean isMoving;
    private Point2D moveCenterStart;
    private Point moveMouseStart;
    private boolean adjustingNorth;
    private boolean adjustingSouth;
    private boolean adjustingEast;
    private boolean adjustingWest;
    private boolean hasHighlight;
    private boolean isRotateOnly;
    private static GridStyle CropGridStyle;
    private static int GridOrientation;
    private Point2D ul;
    private Point2D ur;
    private Point2D ll;
    private Point2D lr;
    private Point2D center;
    private double Width;
    private double Height;
    private double DiagonalDistance;
    private double RotateAngle;
    private double DiagonalAngle;
    private static double RecentCursorAngle;
    private static Cursor RecentCursor;
    private KeyEventPostProcessor rotateKeyProcessor = new KeyEventPostProcessor(){
        int RotateKeyCode = Platform.getType().equals((Object)Platform.Type.MacOSX) ? 157 : 17;
        int RotateModifierMask = Platform.getType().equals((Object)Platform.Type.MacOSX) ? 256 : 128;

        @Override
        public boolean postProcessKeyEvent(KeyEvent e) {
            if (e.getKeyCode() == this.RotateKeyCode) {
                boolean isReleased;
                boolean isPressed = e.getID() == 401;
                boolean bl = isReleased = e.getID() == 402;
                if (isPressed || isReleased) {
                    PointerInfo pointer = MouseInfo.getPointerInfo();
                    Point p = pointer.getLocation();
                    SwingUtilities.convertPointFromScreen(p, CropOverlay.this);
                    MouseEvent syntheticEvent = new MouseEvent(CropOverlay.this, 0, 0L, isPressed ? this.RotateModifierMask : 0, p.x, p.y, 0, false);
                    CropOverlay.this.updateCursor(syntheticEvent);
                }
            }
            return false;
        }
    };

    CropOverlay(boolean isRotateOnly) {
        this.isRotateOnly = isRotateOnly;
        this.cursor = isRotateOnly ? RotateCursor : CropCursor;
        this.setCursor(this.cursor);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.addRotateKeyListener();
    }

    CropBounds getCrop() {
        return this.crop;
    }

    void setCropWithConstraints(CropBounds newCrop) {
        newCrop = this.constraint.adjust(newCrop);
        if (UnderlayConstraints.underlayContains(newCrop = UnderlayConstraints.sizeToUnderlay(newCrop, this.underlayRect, 2.147483647E9, 2.147483647E9), this.underlayRect)) {
            this.setCrop(newCrop);
        }
    }

    void setCrop(CropBounds newCrop) {
        if (newCrop == null || newCrop.isAngleOnly()) {
            double angle = 0.0;
            if (newCrop != null) {
                angle = newCrop.getAngle();
            }
            newCrop = new CropBounds(this.underlayRect, angle);
        }
        this.crop = newCrop;
        this.repaint();
    }

    void setUnderlayRect(Rectangle bounds) {
        this.underlayRect = bounds;
    }

    void setAspectConstraint(AspectConstraint constraint) {
        this.constraint = constraint;
        if (this.crop != null) {
            CropBounds newCrop = constraint.adjust(this.crop);
            newCrop = UnderlayConstraints.translateToUnderlay(newCrop, this.underlayRect);
            this.setCrop(newCrop);
        }
    }

    void modeEntered() {
        this.updateRotateConstraints();
    }

    Dimension2D getRotateLimitDimensions() {
        return new RotateLimitDimension(this.rotateWidthLimit, this.rotateHeightLimit);
    }

    void setRotateLimitDimensions(Dimension2D limit) {
        this.rotateWidthLimit = limit.getWidth();
        this.rotateHeightLimit = limit.getHeight();
    }

    private void updateRotateConstraints() {
        boolean isRotateConstrained = UnderlayConstraints.isRotateDefinedCrop(this.crop, this.underlayRect);
        this.rotateWidthLimit = isRotateConstrained ? this.underlayRect.getWidth() : this.crop.getWidth();
        this.rotateHeightLimit = isRotateConstrained ? this.underlayRect.getHeight() : this.crop.getHeight();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Shape shape = this.getCropAsShape();
        if (shape != null) {
            Graphics2D g = (Graphics2D)graphics;
            Color oldColor = g.getColor();
            Stroke oldStroke = g.getStroke();
            RenderingHints oldHints = g.getRenderingHints();
            g.setColor(RectColor);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Area complement = new Area(this.getBounds());
            complement.subtract(new Area(shape));
            g.fill(complement);
            g.setColor(GridColor);
            g.setStroke(new BasicStroke(3.0f));
            this.paintGrid(g);
            BasicStroke borderStroke = new BasicStroke(this.hasHighlight ? 2.0f : 1.0f);
            g.setColor(RectBorderColor);
            g.setStroke(borderStroke);
            g.draw(shape);
            g.setStroke(oldStroke);
            g.setColor(oldColor);
            g.setRenderingHints(oldHints);
        }
    }

    private void paintGrid(Graphics2D g) {
        this.ul = this.crop.getUpperLeft();
        this.ur = this.crop.getUpperRight();
        this.ll = this.crop.getLowerLeft();
        this.lr = this.crop.getLowerRight();
        this.center = this.crop.getCenter();
        if (this.isRotateOnly) {
            this.paintRotateGrid(g);
        } else {
            this.paintCropGrid(g);
        }
    }

    void changeOrientation() {
        ++GridOrientation;
        GridOrientation %= 4;
        this.repaint();
    }

    private void paintCropGrid(Graphics2D g) {
        this.Width = this.crop.getWidth();
        this.Height = this.crop.getHeight();
        this.DiagonalDistance = Math.sqrt(this.Height * this.Height + this.Width * this.Width);
        this.RotateAngle = this.crop.getAngle();
        this.DiagonalAngle = Math.atan(this.Height / this.Width);
        switch (CropGridStyle) {
            case THIRD: {
                this.paintGridThird(g);
                break;
            }
            case TRIANGLE: {
                this.paintGridTriangle(g);
                break;
            }
            case GOLDEN: {
                this.paintGridGolden(g);
                break;
            }
            case FIBONACCI: {
                this.paintGridFibonacci(g);
                break;
            }
            case DIAGONAL: {
                this.paintGridDiagonal(g);
            }
        }
    }

    private void paintGridThird(Graphics2D g) {
        int gridCount = 3;
        for (int x = 1; x < gridCount; ++x) {
            Point2D.Double p = new Point2D.Double(((double)x * this.ul.getX() + (double)(gridCount - x) * this.lr.getX()) / (double)gridCount, ((double)x * this.ul.getY() + (double)(gridCount - x) * this.lr.getY()) / (double)gridCount);
            Line2D hLine = new Line2D.Double(this.ul, this.ur);
            hLine = CropOverlay.getSegmentThroughPoint(hLine, p);
            g.draw(hLine);
            Line2D vLine = new Line2D.Double(this.ul, this.ll);
            vLine = CropOverlay.getSegmentThroughPoint(vLine, p);
            g.draw(vLine);
        }
    }

    private void paintGridTriangle(Graphics2D g) {
        double ul_x = this.ul.getX();
        double ul_y = this.ul.getY();
        double ur_x = this.ur.getX();
        double ur_y = this.ur.getY();
        double ll_x = this.ll.getX();
        double ll_y = this.ll.getY();
        double lr_x = this.lr.getX();
        double lr_y = this.lr.getY();
        double d = Math.abs((lr_x - ll_x) * (ur_y - ll_y) - (lr_x - ll_y) * (ur_x - ll_x)) / this.DiagonalDistance;
        if (GridOrientation % 2 == 0) {
            g.draw(new Line2D.Double(ur_x, ur_y, ll_x, ll_y));
            g.draw(new Line2D.Double(lr_x - d * Math.sin(this.DiagonalAngle - this.RotateAngle), lr_y - d * Math.cos(this.DiagonalAngle - this.RotateAngle), lr_x, lr_y));
            g.draw(new Line2D.Double(ul_x + d * Math.sin(this.DiagonalAngle - this.RotateAngle), ul_y + d * Math.cos(this.DiagonalAngle - this.RotateAngle), ul_x, ul_y));
        } else {
            g.draw(new Line2D.Double(ul_x, ul_y, lr_x, lr_y));
            g.draw(new Line2D.Double(ur_x - d * Math.sin(this.DiagonalAngle + this.RotateAngle), ur_y + d * Math.cos(this.DiagonalAngle + this.RotateAngle), ur_x, ur_y));
            g.draw(new Line2D.Double(ll_x + d * Math.sin(this.DiagonalAngle + this.RotateAngle), ll_y - d * Math.cos(this.DiagonalAngle + this.RotateAngle), ll_x, ll_y));
        }
    }

    private void paintGridGolden(Graphics2D g) {
        Line2D hLine = new Line2D.Double(this.ul, this.ur);
        Line2D vLine = new Line2D.Double(this.ul, this.ll);
        Point2D.Double p = new Point2D.Double(this.center.getX() - 0.118 * this.DiagonalDistance * Math.cos(this.DiagonalAngle + this.RotateAngle), this.center.getY() - 0.118 * this.DiagonalDistance * Math.sin(this.DiagonalAngle + this.RotateAngle));
        hLine = CropOverlay.getSegmentThroughPoint(hLine, p);
        g.draw(hLine);
        vLine = CropOverlay.getSegmentThroughPoint(vLine, p);
        g.draw(vLine);
        p = new Point2D.Double(this.center.getX() + 0.118 * this.DiagonalDistance * Math.cos(this.DiagonalAngle + this.RotateAngle), this.center.getY() + 0.118 * this.DiagonalDistance * Math.sin(this.DiagonalAngle + this.RotateAngle));
        hLine = CropOverlay.getSegmentThroughPoint(hLine, p);
        g.draw(hLine);
        vLine = CropOverlay.getSegmentThroughPoint(vLine, p);
        g.draw(vLine);
    }

    private void paintGridFibonacci(Graphics2D g) {
        g.rotate(this.RotateAngle, this.center.getX(), this.center.getY());
        double arcWidth = this.Width / 1.618;
        double arcHeight = this.Height;
        switch (GridOrientation) {
            case 0: {
                double angle = 180.0;
                Point2D.Double Center = new Point2D.Double(this.center.getX() + 0.118 * this.Width, this.center.getY() + this.Height / 2.0);
                g.drawArc((int)(((Point2D)Center).getX() - arcWidth), (int)(((Point2D)Center).getY() - arcHeight), (int)arcWidth * 2, (int)arcHeight * 2, (int)angle, -90);
                for (int i = 0; i < 10; ++i) {
                    ((Point2D)Center).setLocation(((Point2D)Center).getX() + Math.sin(Math.toRadians(90.0 - (angle -= 90.0))) * (arcWidth /= 1.618) / 1.618, ((Point2D)Center).getY() - Math.sin(Math.toRadians(180.0 - angle)) * (arcHeight /= 1.618) / 1.618);
                    g.drawArc((int)(((Point2D)Center).getX() - arcWidth), (int)(((Point2D)Center).getY() - arcHeight), (int)arcWidth * 2, (int)arcHeight * 2, (int)angle, -90);
                }
                break;
            }
            case 1: {
                double angle = 180.0;
                Point2D.Double Center = new Point2D.Double(this.center.getX() + 0.118 * this.Width, this.center.getY() - this.Height / 2.0);
                g.drawArc((int)(((Point2D)Center).getX() - arcWidth), (int)(((Point2D)Center).getY() - arcHeight), (int)arcWidth * 2, (int)arcHeight * 2, (int)angle, 90);
                for (int i = 0; i < 10; ++i) {
                    ((Point2D)Center).setLocation(((Point2D)Center).getX() - Math.sin(Math.toRadians(-90.0 + (angle += 90.0))) * (arcWidth /= 1.618) / 1.618, ((Point2D)Center).getY() + Math.sin(Math.toRadians(-180.0 + angle)) * (arcHeight /= 1.618) / 1.618);
                    g.drawArc((int)(((Point2D)Center).getX() - arcWidth), (int)(((Point2D)Center).getY() - arcHeight), (int)arcWidth * 2, (int)arcHeight * 2, (int)angle, 90);
                }
                break;
            }
            case 2: {
                double angle = 0.0;
                Point2D.Double Center = new Point2D.Double(this.center.getX() - 0.118 * this.Width, this.center.getY() + this.Height / 2.0);
                g.drawArc((int)(((Point2D)Center).getX() - arcWidth), (int)(((Point2D)Center).getY() - arcHeight), (int)arcWidth * 2, (int)arcHeight * 2, (int)angle, 90);
                for (int i = 0; i < 10; ++i) {
                    ((Point2D)Center).setLocation(((Point2D)Center).getX() + Math.sin(Math.toRadians(90.0 + (angle += 90.0))) * (arcWidth /= 1.618) / 1.618, ((Point2D)Center).getY() - Math.sin(Math.toRadians(0.0 + angle)) * (arcHeight /= 1.618) / 1.618);
                    g.drawArc((int)(((Point2D)Center).getX() - arcWidth), (int)(((Point2D)Center).getY() - arcHeight), (int)arcWidth * 2, (int)arcHeight * 2, (int)angle, 90);
                }
                break;
            }
            case 3: {
                double angle = 0.0;
                Point2D.Double Center = new Point2D.Double(this.center.getX() - 0.118 * this.Width, this.center.getY() - this.Height / 2.0);
                g.drawArc((int)(((Point2D)Center).getX() - arcWidth), (int)(((Point2D)Center).getY() - arcHeight), (int)arcWidth * 2, (int)arcHeight * 2, (int)angle, -90);
                for (int i = 0; i < 10; ++i) {
                    ((Point2D)Center).setLocation(((Point2D)Center).getX() + Math.sin(Math.toRadians(90.0 - (angle -= 90.0))) * (arcWidth /= 1.618) / 1.618, ((Point2D)Center).getY() + Math.sin(Math.toRadians(0.0 - angle)) * (arcHeight /= 1.618) / 1.618);
                    g.drawArc((int)(((Point2D)Center).getX() - arcWidth), (int)(((Point2D)Center).getY() - arcHeight), (int)arcWidth * 2, (int)arcHeight * 2, (int)angle, -90);
                }
                break;
            }
        }
        g.rotate(-1.0 * this.RotateAngle, this.center.getX(), this.center.getY());
    }

    private void paintGridDiagonal(Graphics2D g) {
        boolean ShorterSide;
        boolean bl = ShorterSide = this.Width > this.Height;
        if (ShorterSide) {
            g.draw(new Line2D.Double(this.ul.getX(), this.ul.getY(), this.ll.getX() + this.Height * Math.cos(-1.0 * this.RotateAngle), this.ll.getY() - this.Height * Math.sin(-1.0 * this.RotateAngle)));
            g.draw(new Line2D.Double(this.ur.getX(), this.ur.getY(), this.lr.getX() - this.Height * Math.cos(-1.0 * this.RotateAngle), this.lr.getY() + this.Height * Math.sin(-1.0 * this.RotateAngle)));
            g.draw(new Line2D.Double(this.ll.getX(), this.ll.getY(), this.ul.getX() + this.Height * Math.cos(-1.0 * this.RotateAngle), this.ul.getY() - this.Height * Math.sin(-1.0 * this.RotateAngle)));
            g.draw(new Line2D.Double(this.lr.getX(), this.lr.getY(), this.ur.getX() - this.Height * Math.cos(-1.0 * this.RotateAngle), this.ur.getY() + this.Height * Math.sin(-1.0 * this.RotateAngle)));
        } else {
            g.draw(new Line2D.Double(this.ul.getX(), this.ul.getY(), this.ur.getX() + this.Width * Math.sin(-1.0 * this.RotateAngle), this.ur.getY() + this.Width * Math.cos(-1.0 * this.RotateAngle)));
            g.draw(new Line2D.Double(this.ur.getX(), this.ur.getY(), this.ul.getX() + this.Width * Math.sin(-1.0 * this.RotateAngle), this.ul.getY() + this.Width * Math.cos(-1.0 * this.RotateAngle)));
            g.draw(new Line2D.Double(this.ll.getX(), this.ll.getY(), this.lr.getX() - this.Width * Math.sin(-1.0 * this.RotateAngle), this.lr.getY() - this.Width * Math.cos(-1.0 * this.RotateAngle)));
            g.draw(new Line2D.Double(this.lr.getX(), this.lr.getY(), this.ll.getX() - this.Width * Math.sin(-1.0 * this.RotateAngle), this.ll.getY() - this.Width * Math.cos(-1.0 * this.RotateAngle)));
        }
    }

    private void paintRotateGrid(Graphics2D g) {
        Point2D midLeft = CropOverlay.getMidPoint(this.ul, this.ll);
        Point2D midTop = CropOverlay.getMidPoint(this.ul, this.ur);
        Point2D midRight = CropOverlay.getMidPoint(this.ur, this.lr);
        Point2D midBottom = CropOverlay.getMidPoint(this.ll, this.lr);
        Line2D.Double hMidLine = new Line2D.Double(midLeft, midRight);
        Line2D.Double vMidLine = new Line2D.Double(midTop, midBottom);
        Point2D poll = this.updatePoll();
        Line2D hPollLine = CropOverlay.getSegmentThroughPoint(hMidLine, poll);
        Line2D vPollLine = CropOverlay.getSegmentThroughPoint(vMidLine, poll);
        Point2D hMidPoint = CropOverlay.getMidPoint(hPollLine.getP1(), hPollLine.getP2());
        Point2D vMidPoint = CropOverlay.getMidPoint(vPollLine.getP1(), vPollLine.getP2());
        int gridSpacing = 30;
        List<Point2D> upPts = CropOverlay.getPointsBetween(hMidPoint, midTop, 30.0);
        List<Point2D> downPts = CropOverlay.getPointsBetween(hMidPoint, midBottom, 30.0);
        List<Point2D> rightPts = CropOverlay.getPointsBetween(vMidPoint, midRight, 30.0);
        List<Point2D> leftPts = CropOverlay.getPointsBetween(vMidPoint, midLeft, 30.0);
        if (this.isInRect(poll)) {
            g.draw(hPollLine);
            g.draw(vPollLine);
            double r = 10.0;
            g.draw(new Ellipse2D.Double(poll.getX() - 10.0, poll.getY() - 10.0, 20.0, 20.0));
        }
        this.paintLines(g, hMidLine, upPts);
        this.paintLines(g, hMidLine, downPts);
        this.paintLines(g, vMidLine, rightPts);
        this.paintLines(g, vMidLine, leftPts);
    }

    private void paintLines(Graphics2D g, Line2D refLine, List<Point2D> Pts) {
        for (Point2D p : Pts) {
            if (!this.isInRect(p)) continue;
            Line2D line = CropOverlay.getSegmentThroughPoint(refLine, p);
            g.draw(line);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Point p = e.getPoint();
        if (this.isInRect(p)) {
            if (this.isRotateOnly) {
                this.setPoll(p);
                return;
            }
            CropGridStyle = CropGridStyle.next();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            return;
        }
        Point p = e.getPoint();
        if (this.isRotateOnly) {
            if (this.crop == null) {
                this.setCrop(new CropBounds(this.underlayRect));
            }
            this.isRotating = true;
            this.rotateAngleStart = this.crop.getAngle();
            this.rotateMouseStart = p;
        } else if (this.isOnRect(p)) {
            if (this.isOnNorth(p)) {
                this.adjustingNorth = true;
            }
            if (this.isOnSouth(p)) {
                this.adjustingSouth = true;
            }
            if (this.isOnEast(p)) {
                this.adjustingEast = true;
            }
            if (this.isOnWest(p)) {
                this.adjustingWest = true;
            }
            this.updateRotateConstraints();
        } else if (this.isInRect(p)) {
            if (CropOverlay.hasRotateModifier(e)) {
                this.isRotating = true;
                this.rotateAngleStart = this.crop.getAngle();
                this.rotateMouseStart = p;
            } else {
                this.isMoving = true;
                this.moveMouseStart = p;
                this.moveCenterStart = this.crop.getCenter();
            }
            this.updateRotateConstraints();
        } else if (this.crop != null && !this.crop.isAngleOnly()) {
            this.isRotating = true;
            this.rotateAngleStart = this.crop.getAngle();
            this.rotateMouseStart = p;
        } else if (CropOverlay.hasRotateModifier(e)) {
            this.setCrop(new CropBounds(this.underlayRect));
            this.isRotating = true;
            this.rotateAngleStart = this.crop.getAngle();
            this.rotateMouseStart = p;
        } else {
            if (!this.underlayRect.contains(p)) {
                Point2D closest = this.getClosestUnderlayPoint(p);
                p = new Point((int)Math.round(closest.getX()), (int)Math.round(closest.getY()));
            }
            this.dragStart = p;
        }
        this.updateCursor(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            return;
        }
        this.isMoving = false;
        this.isRotating = false;
        this.dragStart = null;
        this.rotateMouseStart = null;
        this.moveMouseStart = null;
        this.moveCenterStart = null;
        this.adjustingNorth = false;
        this.adjustingSouth = false;
        this.adjustingEast = false;
        this.adjustingWest = false;
        this.updateCursor(e);
        this.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.updateHighlight(e);
        Point p = e.getPoint();
        CropBounds oldCrop = this.crop;
        if (this.dragStart != null && (Math.abs(this.dragStart.x - p.x) < 10 || Math.abs(this.dragStart.y - p.y) < 10)) {
            return;
        }
        if (this.dragStart != null) {
            if (!this.underlayRect.contains(p)) {
                return;
            }
            double x = Math.min(p.x, this.dragStart.x);
            double y = Math.min(p.y, this.dragStart.y);
            double w = Math.abs(p.x - this.dragStart.x);
            double h = Math.abs(p.y - this.dragStart.y);
            Rectangle2D.Double rect = new Rectangle2D.Double(x, y, w, h);
            CropBounds newCrop = new CropBounds(rect);
            this.setCrop(newCrop);
            if (this.isOnNorth(p)) {
                this.adjustingNorth = true;
            } else {
                this.adjustingSouth = true;
            }
            if (this.isOnWest(p)) {
                this.adjustingWest = true;
            } else {
                this.adjustingEast = true;
            }
            this.dragStart = null;
        } else if (this.isMoving) {
            int dx = p.x - this.moveMouseStart.x;
            int dy = p.y - this.moveMouseStart.y;
            Point2D.Double center = new Point2D.Double(this.moveCenterStart.getX() + (double)dx, this.moveCenterStart.getY() + (double)dy);
            double width = this.crop.getWidth();
            double height = this.crop.getHeight();
            double angle = this.crop.getAngle();
            CropBounds newCrop = new CropBounds((Point2D)center, width, height, angle);
            if ((newCrop = UnderlayConstraints.translateToUnderlay(newCrop, this.underlayRect)) != null) {
                this.setCrop(newCrop);
            }
        } else {
            if (this.isRotating) {
                Point2D poll = this.updatePoll();
                Line2D.Double start = new Line2D.Double(poll, this.rotateMouseStart);
                Line2D.Double end = new Line2D.Double(poll, p);
                double startAngle = Math.atan2(((Line2D)start).getY2() - ((Line2D)start).getY1(), ((Line2D)start).getX2() - ((Line2D)start).getX1());
                double endAngle = Math.atan2(((Line2D)end).getY2() - ((Line2D)end).getY1(), ((Line2D)end).getX2() - ((Line2D)end).getX1());
                double angle = this.rotateAngleStart + endAngle - startAngle;
                CropBounds newCrop = new CropBounds(this.crop, angle);
                this.updateRotateConstraints();
                newCrop = UnderlayConstraints.sizeToUnderlay(newCrop, this.underlayRect, this.rotateWidthLimit, this.rotateHeightLimit);
                if (newCrop != null) {
                    this.setCrop(newCrop);
                }
                return;
            }
            if (this.crop != null && !this.crop.isAngleOnly()) {
                if (this.isEdgeAdjusting()) {
                    if (this.adjustingNorth) {
                        this.setNorth(p);
                        this.crop = this.constraint.adjustWidth(this.crop);
                        this.crop = this.constraint.isNoConstraint() ? UnderlayConstraints.adjustNorthToUnderlay(this.crop, this.underlayRect) : UnderlayConstraints.adjustNorthWithConstraint(this.crop, this.underlayRect);
                    } else if (this.adjustingSouth) {
                        this.setSouth(p);
                        this.crop = this.constraint.adjustWidth(this.crop);
                        this.crop = this.constraint.isNoConstraint() ? UnderlayConstraints.adjustSouthToUnderlay(this.crop, this.underlayRect) : UnderlayConstraints.adjustSouthWithConstraint(this.crop, this.underlayRect);
                    }
                    if (this.adjustingEast) {
                        this.setEast(p);
                        this.crop = this.constraint.adjustHeight(this.crop);
                        this.crop = this.constraint.isNoConstraint() ? UnderlayConstraints.adjustEastToUnderlay(this.crop, this.underlayRect) : UnderlayConstraints.adjustEastWithConstraint(this.crop, this.underlayRect);
                    } else if (this.adjustingWest) {
                        this.setWest(p);
                        this.crop = this.constraint.adjustHeight(this.crop);
                        this.crop = this.constraint.isNoConstraint() ? UnderlayConstraints.adjustWestToUnderlay(this.crop, this.underlayRect) : UnderlayConstraints.adjustWestWithConstraint(this.crop, this.underlayRect);
                    }
                    if (!UnderlayConstraints.underlayContains(this.crop, this.underlayRect)) {
                        this.setCrop(oldCrop);
                    }
                    this.updateRotateConstraints();
                } else if (this.isCornerAdjusting()) {
                    p = this.projectOntoUnderlay(p);
                    Point2D center = this.crop.getCenter();
                    Point2D ul = this.crop.getUpperLeft();
                    Point2D ur = this.crop.getUpperRight();
                    Point2D ll = this.crop.getLowerLeft();
                    Point2D lr = this.crop.getLowerRight();
                    if (this.adjustingSouth) {
                        this.setSouth(p);
                        if (this.adjustingWest) {
                            this.setWest(p);
                            Line2D.Double diag = new Line2D.Double(center, ll);
                            this.crop = diag.relativeCCW(p) > 0 ? this.constraint.adjustBottom(this.crop) : this.constraint.adjustLeft(this.crop);
                            this.crop = UnderlayConstraints.adjustSouthWestToUnderlay(this.crop, this.underlayRect);
                        } else {
                            this.setEast(p);
                            Line2D.Double diag = new Line2D.Double(center, lr);
                            this.crop = diag.relativeCCW(p) > 0 ? this.constraint.adjustBottom(this.crop) : this.constraint.adjustRight(this.crop);
                            this.crop = UnderlayConstraints.adjustSouthEastToUnderlay(this.crop, this.underlayRect);
                        }
                    } else {
                        this.setNorth(p);
                        if (this.adjustingEast) {
                            this.setEast(p);
                            Line2D.Double diag = new Line2D.Double(center, ur);
                            this.crop = diag.relativeCCW(p) > 0 ? this.constraint.adjustTop(this.crop) : this.constraint.adjustRight(this.crop);
                            this.crop = UnderlayConstraints.adjustNorthEastToUnderlay(this.crop, this.underlayRect);
                        } else {
                            this.setWest(p);
                            Line2D.Double diag = new Line2D.Double(center, ul);
                            this.crop = diag.relativeCCW(p) > 0 ? this.constraint.adjustTop(this.crop) : this.constraint.adjustLeft(this.crop);
                            this.crop = UnderlayConstraints.adjustNorthWestToUnderlay(this.crop, this.underlayRect);
                        }
                        this.updateRotateConstraints();
                    }
                }
            }
        }
        if (!UnderlayConstraints.underlayContains(this.crop, this.underlayRect)) {
            this.setCrop(oldCrop);
        }
    }

    private Point projectOntoUnderlay(Point p) {
        Point q = (Point)p.clone();
        Rectangle under = this.underlayRect.getBounds();
        int outcode = this.underlayRect.outcode(p);
        if ((outcode & 2) != 0) {
            q = new Point(q.x, under.y);
        }
        if ((outcode & 1) != 0) {
            q = new Point(under.x, q.y);
        }
        if ((outcode & 8) != 0) {
            q = new Point(q.x, under.y + under.height);
        }
        if ((outcode & 4) != 0) {
            q = new Point(under.x + under.width, q.y);
        }
        return q;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.updateCursor(e);
        this.updateHighlight(e);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        int count = e.getWheelRotation();
        this.rotateAngleStart = this.crop.getAngle();
        double deg = this.rotateAngleStart * 180.0 / Math.PI;
        deg = (double)Math.round(100.0 * deg) * 0.01;
        double STEPS_PER_DEG = 50.0;
        double angle = (double)Math.round(50.0 * deg + (double)count) / 50.0 * Math.PI / 180.0;
        CropBounds newCrop = new CropBounds(this.crop, angle);
        this.updateRotateConstraints();
        newCrop = UnderlayConstraints.sizeToUnderlay(newCrop, this.underlayRect, this.rotateWidthLimit, this.rotateHeightLimit);
        if (newCrop != null) {
            this.setCrop(newCrop);
        }
    }

    private boolean isEdgeAdjusting() {
        return this.adjustingNorth && !this.adjustingEast && !this.adjustingWest || this.adjustingSouth && !this.adjustingEast && !this.adjustingWest || this.adjustingEast && !this.adjustingNorth && !this.adjustingSouth || this.adjustingWest && !this.adjustingNorth && !this.adjustingSouth;
    }

    private boolean isCornerAdjusting() {
        return this.adjustingNorth && (this.adjustingEast || this.adjustingWest) || this.adjustingSouth && (this.adjustingEast || this.adjustingWest);
    }

    private void updateCursor(MouseEvent e) {
        Cursor newCursor = this.getCursor(e);
        if (this.cursor != newCursor) {
            this.cursor = newCursor;
            this.setCursor(this.cursor);
        }
    }

    private void updateHighlight(MouseEvent e) {
        Point p = e.getPoint();
        boolean hadHighlight = this.hasHighlight;
        boolean bl = this.hasHighlight = this.isAdjusting() || this.isInRect(p) || this.isOnRect(p);
        if (hadHighlight != this.hasHighlight) {
            this.repaint();
        }
    }

    private Cursor getCursor(MouseEvent e) {
        if (this.crop == null || this.crop.isAngleOnly()) {
            if (CropOverlay.hasRotateModifier(e) || this.isRotateOnly) {
                return RotateCursor;
            }
            return CropCursor;
        }
        Point p = e.getPoint();
        if (!this.isRotateOnly) {
            double angle = this.crop.getAngle();
            if (this.isOnNorth(p)) {
                if (this.isOnEast(p)) {
                    return CropOverlay.getResizeCursor(-0.7853981633974483 + angle);
                }
                if (this.isOnWest(p)) {
                    return CropOverlay.getResizeCursor(-2.356194490192345 + angle);
                }
                return CropOverlay.getResizeCursor(-1.5707963267948966 + angle);
            }
            if (this.isOnSouth(p)) {
                if (this.isOnEast(p)) {
                    return CropOverlay.getResizeCursor(0.7853981633974483 + angle);
                }
                if (this.isOnWest(p)) {
                    return CropOverlay.getResizeCursor(2.356194490192345 + angle);
                }
                return CropOverlay.getResizeCursor(1.5707963267948966 + angle);
            }
            if (this.isOnEast(p)) {
                return CropOverlay.getResizeCursor(angle);
            }
            if (this.isOnWest(p)) {
                return CropOverlay.getResizeCursor(Math.PI + angle);
            }
            if (this.isInRect(p)) {
                if (this.isRotating) {
                    return RotatingCursor;
                }
                if (this.isMoving) {
                    return MovingCursor;
                }
                if (CropOverlay.hasRotateModifier(e)) {
                    return RotateCursor;
                }
                return MoveCursor;
            }
        }
        if (this.crop != null || this.isRotateOnly) {
            if (this.isRotating) {
                return RotatingCursor;
            }
            return RotateCursor;
        }
        return CropCursor;
    }

    private boolean isAdjusting() {
        return this.adjustingNorth || this.adjustingSouth || this.adjustingEast || this.adjustingWest || this.isRotating || this.isMoving;
    }

    private boolean isInRect(Point2D p) {
        Shape shape = this.getCropAsShape();
        return shape != null && shape.contains(p);
    }

    private boolean isOnRect(Point p) {
        Shape shape = this.getCropAsShape();
        if (shape == null) {
            return false;
        }
        Shape thickRect = CropOverlay.createThickShape(shape);
        return thickRect.contains(p);
    }

    private void setNorth(Point p) {
        Point2D center;
        Line2D north = this.getNorthLine();
        if ((north = CropOverlay.getSegmentThroughPoint(north, p)).relativeCCW(center = this.crop.getCenter()) != -1) {
            return;
        }
        Point2D ul = north.getP1();
        Point2D ur = north.getP2();
        Point2D ll = this.crop.getLowerLeft();
        Point2D lr = this.crop.getLowerRight();
        CropBounds newCrop = new CropBounds(ul, ur, ll, lr);
        this.setCrop(newCrop);
    }

    private void setSouth(Point p) {
        Point2D center;
        Line2D south = this.getSouthLine();
        if ((south = CropOverlay.getSegmentThroughPoint(south, p)).relativeCCW(center = this.crop.getCenter()) != -1) {
            return;
        }
        Point2D ul = this.crop.getUpperLeft();
        Point2D ur = this.crop.getUpperRight();
        Point2D ll = south.getP2();
        Point2D lr = south.getP1();
        CropBounds newCrop = new CropBounds(ul, ur, ll, lr);
        this.setCrop(newCrop);
    }

    private void setEast(Point p) {
        Point2D center;
        Line2D east = this.getEastLine();
        if ((east = CropOverlay.getSegmentThroughPoint(east, p)).relativeCCW(center = this.crop.getCenter()) != -1) {
            return;
        }
        Point2D ul = this.crop.getUpperLeft();
        Point2D ur = east.getP1();
        Point2D ll = this.crop.getLowerLeft();
        Point2D lr = east.getP2();
        CropBounds newCrop = new CropBounds(ul, ur, ll, lr);
        this.setCrop(newCrop);
    }

    private void setWest(Point p) {
        Point2D center;
        Line2D west = this.getWestLine();
        if ((west = CropOverlay.getSegmentThroughPoint(west, p)).relativeCCW(center = this.crop.getCenter()) != -1) {
            return;
        }
        Point2D ul = west.getP2();
        Point2D ur = this.crop.getUpperRight();
        Point2D ll = west.getP1();
        Point2D lr = this.crop.getLowerRight();
        CropBounds newCrop = new CropBounds(ul, ur, ll, lr);
        this.setCrop(newCrop);
    }

    private Line2D getNorthLine() {
        return new Line2D.Double(this.crop.getUpperLeft(), this.crop.getUpperRight());
    }

    private Line2D getEastLine() {
        return new Line2D.Double(this.crop.getUpperRight(), this.crop.getLowerRight());
    }

    private Line2D getSouthLine() {
        return new Line2D.Double(this.crop.getLowerRight(), this.crop.getLowerLeft());
    }

    private Line2D getWestLine() {
        return new Line2D.Double(this.crop.getLowerLeft(), this.crop.getUpperLeft());
    }

    private boolean isOnNorth(Point p) {
        return this.crop != null && CropOverlay.createThickShape(this.getNorthLine()).contains(p);
    }

    private boolean isOnSouth(Point p) {
        return this.crop != null && CropOverlay.createThickShape(this.getSouthLine()).contains(p);
    }

    private boolean isOnEast(Point p) {
        return this.crop != null && CropOverlay.createThickShape(this.getEastLine()).contains(p);
    }

    private boolean isOnWest(Point p) {
        return this.crop != null && CropOverlay.createThickShape(this.getWestLine()).contains(p);
    }

    private Point2D getClosestUnderlayPoint(Point2D p) {
        if (this.underlayRect.contains(p)) {
            return p;
        }
        if (p.getX() < this.underlayRect.getMinX()) {
            p = new Point2D.Double(this.underlayRect.getMinX(), p.getY());
        }
        if (p.getY() < this.underlayRect.getMinY()) {
            p = new Point2D.Double(p.getX(), this.underlayRect.getMinY());
        }
        if (p.getX() > this.underlayRect.getMaxX()) {
            p = new Point2D.Double(this.underlayRect.getMaxX(), p.getY());
        }
        if (p.getY() > this.underlayRect.getMaxY()) {
            p = new Point2D.Double(p.getX(), this.underlayRect.getMaxY());
        }
        return p;
    }

    private static Line2D getSegmentThroughPoint(Line2D seg, Point2D p) {
        Point2D p1 = seg.getP1();
        Point2D p2 = seg.getP2();
        double angle = Math.atan2(p2.getY() - p1.getY(), p2.getX() - p1.getX());
        double distance = seg.ptLineDist(p);
        int ccw = seg.relativeCCW(p);
        double dx = (distance *= (double)(-ccw)) * Math.cos(angle += 1.5707963267948966);
        double dy = distance * Math.sin(angle);
        p1 = new Point2D.Double(p1.getX() + dx, p1.getY() + dy);
        p2 = new Point2D.Double(p2.getX() + dx, p2.getY() + dy);
        return new Line2D.Double(p1, p2);
    }

    private static Point2D getMidPoint(Point2D p, Point2D q) {
        return new Point2D.Double((p.getX() + q.getX()) / 2.0, (p.getY() + q.getY()) / 2.0);
    }

    private static List<Point2D> getPointsBetween(Point2D start, Point2D end, double spacing) {
        double angle = Math.atan2(end.getY() - start.getY(), end.getX() - start.getX());
        double dist = start.distance(end);
        int nPts = (int)Math.floor(dist / spacing);
        LinkedList<Point2D> points = new LinkedList<Point2D>();
        Point2D p = start;
        for (int n = 0; n <= nPts; ++n) {
            points.add(p);
            p = new Point2D.Double(p.getX() + spacing * Math.cos(angle), p.getY() + spacing * Math.sin(angle));
        }
        return points;
    }

    private Shape getCropAsShape() {
        if (this.crop == null || this.crop.isAngleOnly()) {
            return null;
        }
        Point2D ul = this.crop.getUpperLeft();
        Point2D ur = this.crop.getUpperRight();
        Point2D ll = this.crop.getLowerLeft();
        Point2D lr = this.crop.getLowerRight();
        GeneralPath path = new GeneralPath();
        path.moveTo((float)ul.getX(), (float)ul.getY());
        path.lineTo((float)ur.getX(), (float)ur.getY());
        path.lineTo((float)lr.getX(), (float)lr.getY());
        path.lineTo((float)ll.getX(), (float)ll.getY());
        path.closePath();
        return path;
    }

    private static Shape createThickShape(Shape shape) {
        return RectStroke.createStrokedShape(shape);
    }

    private static Cursor getCursor(String name) {
        try {
            String path = "resources/" + name + ".png";
            URL url = CropOverlay.class.getResource(path);
            BufferedImage image = ImageIO.read(url);
            int x = Integer.parseInt(HotPointResources.getString(name + "X"));
            int y = Integer.parseInt(HotPointResources.getString(name + "Y"));
            Point hot = new Point(x, y);
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            return toolkit.createCustomCursor(image, hot, name);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Cursor getResizeCursor(double angle) {
        if (Platform.getType() == Platform.Windows) {
            int cursorType = 0;
            double a = 0.7853981633974483;
            if (Math.abs(angle) < a) {
                cursorType = 11;
            }
            if (Math.abs(angle - 0.7853981633974483) < a) {
                cursorType = 5;
            }
            if (Math.abs(angle - 1.5707963267948966) < a) {
                cursorType = 9;
            }
            if (Math.abs(angle - 2.356194490192345) < a) {
                cursorType = 4;
            }
            if (Math.abs(angle - Math.PI) < a) {
                cursorType = 10;
            }
            if (Math.abs(angle + 2.356194490192345) < a) {
                cursorType = 6;
            }
            if (Math.abs(angle + 1.5707963267948966) < a) {
                cursorType = 8;
            }
            if (Math.abs(angle + 0.7853981633974483) < a) {
                cursorType = 7;
            }
            return Cursor.getPredefinedCursor(cursorType);
        }
        double diff = Math.abs(angle - RecentCursorAngle);
        if (diff < 0.001 && RecentCursor != null) {
            return RecentCursor;
        }
        try {
            String path = "resources/resize.png";
            URL url = CropOverlay.class.getResource(path);
            BufferedImage resourceImage = ImageIO.read(url);
            int cx = resourceImage.getWidth() / 2;
            int cy = resourceImage.getHeight() / 2;
            RenderedOp rotatedImage = RotateDescriptor.create((RenderedImage)resourceImage, (Float)Float.valueOf(cx), (Float)Float.valueOf(cy), (Float)Float.valueOf((float)angle), (Interpolation)Interpolation.getInstance((int)2), null, null);
            Point hot = new Point(cx, cy);
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            BufferedImage buffer = rotatedImage.getAsBufferedImage();
            Cursor cursor = toolkit.createCustomCursor(buffer, hot, "resize");
            RecentCursorAngle = angle;
            RecentCursor = cursor;
            return cursor;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static boolean hasRotateModifier(MouseEvent event) {
        Platform.Type type = Platform.getType();
        switch (type) {
            case MacOSX: {
                return event.isMetaDown();
            }
        }
        return event.isControlDown();
    }

    private void addRotateKeyListener() {
        KeyboardFocusManager focus = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        focus.addKeyEventPostProcessor(this.rotateKeyProcessor);
    }

    public void dispose() {
        KeyboardFocusManager focus = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        focus.removeKeyEventPostProcessor(this.rotateKeyProcessor);
    }

    private Point2D updatePoll() {
        if (this.relativePoll == null) {
            Point2D p = this.crop.getCenter();
            this.setPoll(p);
            return p;
        }
        return new Point2D.Double(this.relativePoll.getX() * this.underlayRect.getWidth() + this.underlayRect.getX(), this.relativePoll.getY() * this.underlayRect.getHeight() + this.underlayRect.getY());
    }

    private void setPoll(Point2D p) {
        if (p == null) {
            p = this.crop.getCenter();
        }
        this.relativePoll = new Point2D.Double((p.getX() - this.underlayRect.getX()) / this.underlayRect.getWidth(), (p.getY() - this.underlayRect.getY()) / this.underlayRect.getHeight());
    }

    static {
        HotPointResources = ResourceBundle.getBundle("com/lightcrafts/ui/crop/resources/HotPoints");
        CropCursor = CropOverlay.getCursor("crop_cursor");
        MoveCursor = CropOverlay.getCursor("move_curve");
        MovingCursor = CropOverlay.getCursor("moving_curve");
        RotateCursor = CropOverlay.getCursor("rotate");
        RotatingCursor = CropOverlay.getCursor("rotating");
        CropGridStyle = GridStyle.THIRD;
        GridOrientation = 0;
    }

    private static enum GridStyle {
        THIRD{

            @Override
            public GridStyle next() {
                return TRIANGLE;
            }
        }
        ,
        TRIANGLE{

            @Override
            public GridStyle next() {
                return GOLDEN;
            }
        }
        ,
        GOLDEN{

            @Override
            public GridStyle next() {
                return FIBONACCI;
            }
        }
        ,
        FIBONACCI{

            @Override
            public GridStyle next() {
                return DIAGONAL;
            }
        }
        ,
        DIAGONAL{

            @Override
            public GridStyle next() {
                return THIRD;
            }
        };


        abstract GridStyle next();
    }
}

