/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.crop;

import com.lightcrafts.model.CropBounds;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;

public class UnderlayConstraints {
    private static final double UnderlayContainsSlop = 0.001;

    static CropBounds translateToUnderlay(CropBounds oldCrop, Rectangle2D underlay) {
        double dy;
        double dx;
        Rectangle2D oldRect = UnderlayConstraints.getCropAsShape(oldCrop).getBounds2D();
        CropBounds newCrop = oldCrop;
        if (oldRect.getX() < underlay.getMinX()) {
            dx = -(oldRect.getX() - underlay.getMinX());
            dy = 0.0;
            newCrop = UnderlayConstraints.translateCrop(newCrop, dx, dy);
        }
        if (oldRect.getY() < underlay.getMinY()) {
            dx = 0.0;
            dy = -(oldRect.getY() - underlay.getMinY());
            newCrop = UnderlayConstraints.translateCrop(newCrop, dx, dy);
        }
        if (oldRect.getX() + oldRect.getWidth() > underlay.getMaxX()) {
            dx = -(oldRect.getX() + oldRect.getWidth() - underlay.getMaxX());
            dy = 0.0;
            newCrop = UnderlayConstraints.translateCrop(newCrop, dx, dy);
        }
        if (oldRect.getY() + oldRect.getHeight() > underlay.getMaxY()) {
            dx = 0.0;
            dy = -(oldRect.getY() + oldRect.getHeight() - underlay.getMaxY());
            newCrop = UnderlayConstraints.translateCrop(newCrop, dx, dy);
        }
        if (newCrop != null && UnderlayConstraints.underlayContains(newCrop, underlay)) {
            return newCrop;
        }
        return null;
    }

    public static CropBounds sizeToUnderlay(CropBounds oldCrop, Rectangle2D underlay, double limitW, double limitH) {
        CropBounds newCrop = new CropBounds(oldCrop.getCenter(), limitW, limitH, oldCrop.getAngle());
        if (UnderlayConstraints.underlayContains(newCrop, underlay)) {
            return newCrop;
        }
        double ult = UnderlayConstraints.ultHeight(oldCrop, underlay);
        double ull = UnderlayConstraints.ullHeight(oldCrop, underlay);
        double ulb = UnderlayConstraints.ulbHeight(oldCrop, underlay);
        double ulr = UnderlayConstraints.ulrHeight(oldCrop, underlay);
        double urt = UnderlayConstraints.urtHeight(oldCrop, underlay);
        double url = UnderlayConstraints.urlHeight(oldCrop, underlay);
        double urb = UnderlayConstraints.urbHeight(oldCrop, underlay);
        double urr = UnderlayConstraints.urrHeight(oldCrop, underlay);
        double llt = UnderlayConstraints.lltHeight(oldCrop, underlay);
        double lll = UnderlayConstraints.lllHeight(oldCrop, underlay);
        double llb = UnderlayConstraints.llbHeight(oldCrop, underlay);
        double llr = UnderlayConstraints.llrHeight(oldCrop, underlay);
        double lrt = UnderlayConstraints.lrtHeight(oldCrop, underlay);
        double lrl = UnderlayConstraints.lrlHeight(oldCrop, underlay);
        double lrb = UnderlayConstraints.lrbHeight(oldCrop, underlay);
        double lrr = UnderlayConstraints.lrrHeight(oldCrop, underlay);
        double aspect = oldCrop.getWidth() / oldCrop.getHeight();
        double h = limitH;
        h = UnderlayConstraints.minIgnoreNegative(h, ult);
        h = UnderlayConstraints.minIgnoreNegative(h, ull);
        h = UnderlayConstraints.minIgnoreNegative(h, ulb);
        h = UnderlayConstraints.minIgnoreNegative(h, ulr);
        h = UnderlayConstraints.minIgnoreNegative(h, urt);
        h = UnderlayConstraints.minIgnoreNegative(h, url);
        h = UnderlayConstraints.minIgnoreNegative(h, urb);
        h = UnderlayConstraints.minIgnoreNegative(h, urr);
        h = UnderlayConstraints.minIgnoreNegative(h, llt);
        h = UnderlayConstraints.minIgnoreNegative(h, lll);
        h = UnderlayConstraints.minIgnoreNegative(h, llb);
        h = UnderlayConstraints.minIgnoreNegative(h, llr);
        h = UnderlayConstraints.minIgnoreNegative(h, lrt);
        h = UnderlayConstraints.minIgnoreNegative(h, lrl);
        h = UnderlayConstraints.minIgnoreNegative(h, lrb);
        h = UnderlayConstraints.minIgnoreNegative(h, lrr);
        double w = h * aspect;
        newCrop = new CropBounds(oldCrop.getCenter(), w, h, oldCrop.getAngle());
        return newCrop;
    }

    public static CropBounds adjustNorthToUnderlay(CropBounds oldCrop, Rectangle2D underlay) {
        if (UnderlayConstraints.underlayContains(oldCrop, underlay)) {
            return oldCrop;
        }
        Line2D top = UnderlayConstraints.getTopUnderlayLine(underlay);
        Line2D left = UnderlayConstraints.getLeftUnderlayLine(underlay);
        Line2D bottom = UnderlayConstraints.getBottomUnderlayLine(underlay);
        Line2D right = UnderlayConstraints.getRightUnderlayLine(underlay);
        Line2D north = UnderlayConstraints.getNorthCropLine(oldCrop);
        Line2D south = UnderlayConstraints.getSouthCropLine(oldCrop);
        Line2D east = UnderlayConstraints.getEastCropLine(oldCrop);
        Line2D west = UnderlayConstraints.getWestCropLine(oldCrop);
        Point2D et = UnderlayConstraints.getIntersection(east, top);
        Point2D el = UnderlayConstraints.getIntersection(east, left);
        Point2D eb = UnderlayConstraints.getIntersection(east, bottom);
        Point2D er = UnderlayConstraints.getIntersection(east, right);
        Point2D wt = UnderlayConstraints.getIntersection(west, top);
        Point2D wl = UnderlayConstraints.getIntersection(west, left);
        Point2D wb = UnderlayConstraints.getIntersection(west, bottom);
        Point2D wr = UnderlayConstraints.getIntersection(west, right);
        double height = oldCrop.getHeight();
        if (et != null) {
            height = UnderlayConstraints.minIgnoreNegative(height, south.ptLineDist(et));
        }
        if (el != null) {
            height = UnderlayConstraints.minIgnoreNegative(height, south.ptLineDist(el));
        }
        if (eb != null) {
            height = UnderlayConstraints.minIgnoreNegative(height, south.ptLineDist(eb));
        }
        if (er != null) {
            height = UnderlayConstraints.minIgnoreNegative(height, south.ptLineDist(er));
        }
        if (wt != null) {
            height = UnderlayConstraints.minIgnoreNegative(height, south.ptLineDist(wt));
        }
        if (wl != null) {
            height = UnderlayConstraints.minIgnoreNegative(height, south.ptLineDist(wl));
        }
        if (wb != null) {
            height = UnderlayConstraints.minIgnoreNegative(height, south.ptLineDist(wb));
        }
        if (wr != null) {
            height = UnderlayConstraints.minIgnoreNegative(height, south.ptLineDist(wr));
        }
        Point2D oldCenter = oldCrop.getCenter();
        double angle = oldCrop.getAngle();
        double width = oldCrop.getWidth();
        double dh = height - oldCrop.getHeight();
        Point2D.Double newCenter = new Point2D.Double(oldCenter.getX() + dh / 2.0 * Math.sin(angle), oldCenter.getY() - dh / 2.0 * Math.cos(angle));
        CropBounds newCrop = new CropBounds((Point2D)newCenter, width, height, angle);
        return newCrop;
    }

    public static CropBounds adjustSouthToUnderlay(CropBounds oldCrop, Rectangle2D underlay) {
        if (UnderlayConstraints.underlayContains(oldCrop, underlay)) {
            return oldCrop;
        }
        Line2D top = UnderlayConstraints.getTopUnderlayLine(underlay);
        Line2D left = UnderlayConstraints.getLeftUnderlayLine(underlay);
        Line2D bottom = UnderlayConstraints.getBottomUnderlayLine(underlay);
        Line2D right = UnderlayConstraints.getRightUnderlayLine(underlay);
        Line2D north = UnderlayConstraints.getNorthCropLine(oldCrop);
        Line2D south = UnderlayConstraints.getSouthCropLine(oldCrop);
        Line2D east = UnderlayConstraints.getEastCropLine(oldCrop);
        Line2D west = UnderlayConstraints.getWestCropLine(oldCrop);
        Point2D et = UnderlayConstraints.getIntersection(east, top);
        Point2D el = UnderlayConstraints.getIntersection(east, left);
        Point2D eb = UnderlayConstraints.getIntersection(east, bottom);
        Point2D er = UnderlayConstraints.getIntersection(east, right);
        Point2D wt = UnderlayConstraints.getIntersection(west, top);
        Point2D wl = UnderlayConstraints.getIntersection(west, left);
        Point2D wb = UnderlayConstraints.getIntersection(west, bottom);
        Point2D wr = UnderlayConstraints.getIntersection(west, right);
        double height = oldCrop.getHeight();
        if (et != null) {
            height = UnderlayConstraints.minIgnoreNegative(height, north.ptLineDist(et));
        }
        if (el != null) {
            height = UnderlayConstraints.minIgnoreNegative(height, north.ptLineDist(el));
        }
        if (eb != null) {
            height = UnderlayConstraints.minIgnoreNegative(height, north.ptLineDist(eb));
        }
        if (er != null) {
            height = UnderlayConstraints.minIgnoreNegative(height, north.ptLineDist(er));
        }
        if (wt != null) {
            height = UnderlayConstraints.minIgnoreNegative(height, north.ptLineDist(wt));
        }
        if (wl != null) {
            height = UnderlayConstraints.minIgnoreNegative(height, north.ptLineDist(wl));
        }
        if (wb != null) {
            height = UnderlayConstraints.minIgnoreNegative(height, north.ptLineDist(wb));
        }
        if (wr != null) {
            height = UnderlayConstraints.minIgnoreNegative(height, north.ptLineDist(wr));
        }
        Point2D oldCenter = oldCrop.getCenter();
        double angle = oldCrop.getAngle();
        double width = oldCrop.getWidth();
        double dh = height - oldCrop.getHeight();
        Point2D.Double newCenter = new Point2D.Double(oldCenter.getX() - dh / 2.0 * Math.sin(angle), oldCenter.getY() + dh / 2.0 * Math.cos(angle));
        CropBounds newCrop = new CropBounds((Point2D)newCenter, width, height, angle);
        return newCrop;
    }

    public static CropBounds adjustEastToUnderlay(CropBounds oldCrop, Rectangle2D underlay) {
        if (UnderlayConstraints.underlayContains(oldCrop, underlay)) {
            return oldCrop;
        }
        Line2D top = UnderlayConstraints.getTopUnderlayLine(underlay);
        Line2D left = UnderlayConstraints.getLeftUnderlayLine(underlay);
        Line2D bottom = UnderlayConstraints.getBottomUnderlayLine(underlay);
        Line2D right = UnderlayConstraints.getRightUnderlayLine(underlay);
        Line2D north = UnderlayConstraints.getNorthCropLine(oldCrop);
        Line2D south = UnderlayConstraints.getSouthCropLine(oldCrop);
        Line2D east = UnderlayConstraints.getEastCropLine(oldCrop);
        Line2D west = UnderlayConstraints.getWestCropLine(oldCrop);
        Point2D nt = UnderlayConstraints.getIntersection(north, top);
        Point2D nl = UnderlayConstraints.getIntersection(north, left);
        Point2D nb = UnderlayConstraints.getIntersection(north, bottom);
        Point2D nr = UnderlayConstraints.getIntersection(north, right);
        Point2D st = UnderlayConstraints.getIntersection(south, top);
        Point2D sl = UnderlayConstraints.getIntersection(south, left);
        Point2D sb = UnderlayConstraints.getIntersection(south, bottom);
        Point2D sr = UnderlayConstraints.getIntersection(south, right);
        double width = oldCrop.getWidth();
        if (nt != null) {
            width = UnderlayConstraints.minIgnoreNegative(width, west.ptLineDist(nt));
        }
        if (nl != null) {
            width = UnderlayConstraints.minIgnoreNegative(width, west.ptLineDist(nl));
        }
        if (nb != null) {
            width = UnderlayConstraints.minIgnoreNegative(width, west.ptLineDist(nb));
        }
        if (nr != null) {
            width = UnderlayConstraints.minIgnoreNegative(width, west.ptLineDist(nr));
        }
        if (st != null) {
            width = UnderlayConstraints.minIgnoreNegative(width, west.ptLineDist(st));
        }
        if (sl != null) {
            width = UnderlayConstraints.minIgnoreNegative(width, west.ptLineDist(sl));
        }
        if (sb != null) {
            width = UnderlayConstraints.minIgnoreNegative(width, west.ptLineDist(sb));
        }
        if (sr != null) {
            width = UnderlayConstraints.minIgnoreNegative(width, west.ptLineDist(sr));
        }
        Point2D oldCenter = oldCrop.getCenter();
        double angle = oldCrop.getAngle();
        double height = oldCrop.getHeight();
        double dw = width - oldCrop.getWidth();
        Point2D.Double newCenter = new Point2D.Double(oldCenter.getX() + dw / 2.0 * Math.cos(angle), oldCenter.getY() + dw / 2.0 * Math.sin(angle));
        CropBounds newCrop = new CropBounds((Point2D)newCenter, width, height, angle);
        return newCrop;
    }

    public static CropBounds adjustWestToUnderlay(CropBounds oldCrop, Rectangle2D underlay) {
        if (UnderlayConstraints.underlayContains(oldCrop, underlay)) {
            return oldCrop;
        }
        Line2D top = UnderlayConstraints.getTopUnderlayLine(underlay);
        Line2D left = UnderlayConstraints.getLeftUnderlayLine(underlay);
        Line2D bottom = UnderlayConstraints.getBottomUnderlayLine(underlay);
        Line2D right = UnderlayConstraints.getRightUnderlayLine(underlay);
        Line2D north = UnderlayConstraints.getNorthCropLine(oldCrop);
        Line2D south = UnderlayConstraints.getSouthCropLine(oldCrop);
        Line2D east = UnderlayConstraints.getEastCropLine(oldCrop);
        Line2D west = UnderlayConstraints.getWestCropLine(oldCrop);
        Point2D nt = UnderlayConstraints.getIntersection(north, top);
        Point2D nl = UnderlayConstraints.getIntersection(north, left);
        Point2D nb = UnderlayConstraints.getIntersection(north, bottom);
        Point2D nr = UnderlayConstraints.getIntersection(north, right);
        Point2D st = UnderlayConstraints.getIntersection(south, top);
        Point2D sl = UnderlayConstraints.getIntersection(south, left);
        Point2D sb = UnderlayConstraints.getIntersection(south, bottom);
        Point2D sr = UnderlayConstraints.getIntersection(south, right);
        double width = oldCrop.getWidth();
        if (nt != null) {
            width = UnderlayConstraints.minIgnoreNegative(width, east.ptLineDist(nt));
        }
        if (nl != null) {
            width = UnderlayConstraints.minIgnoreNegative(width, east.ptLineDist(nl));
        }
        if (nb != null) {
            width = UnderlayConstraints.minIgnoreNegative(width, east.ptLineDist(nb));
        }
        if (nr != null) {
            width = UnderlayConstraints.minIgnoreNegative(width, east.ptLineDist(nr));
        }
        if (st != null) {
            width = UnderlayConstraints.minIgnoreNegative(width, east.ptLineDist(st));
        }
        if (sl != null) {
            width = UnderlayConstraints.minIgnoreNegative(width, east.ptLineDist(sl));
        }
        if (sb != null) {
            width = UnderlayConstraints.minIgnoreNegative(width, east.ptLineDist(sb));
        }
        if (sr != null) {
            width = UnderlayConstraints.minIgnoreNegative(width, east.ptLineDist(sr));
        }
        Point2D oldCenter = oldCrop.getCenter();
        double angle = oldCrop.getAngle();
        double height = oldCrop.getHeight();
        double dw = width - oldCrop.getWidth();
        Point2D.Double newCenter = new Point2D.Double(oldCenter.getX() - dw / 2.0 * Math.cos(angle), oldCenter.getY() - dw / 2.0 * Math.sin(angle));
        CropBounds newCrop = new CropBounds((Point2D)newCenter, width, height, angle);
        return newCrop;
    }

    public static CropBounds adjustNorthWithConstraint(CropBounds oldCrop, Rectangle2D underlay) {
        if (UnderlayConstraints.underlayContains(oldCrop, underlay)) {
            return oldCrop;
        }
        Line2D south = UnderlayConstraints.getSouthCropLine(oldCrop);
        Point2D.Double midSouth = new Point2D.Double((south.getP1().getX() + south.getP2().getX()) / 2.0, (south.getP1().getY() + south.getP2().getY()) / 2.0);
        Line2D.Double neLine = new Line2D.Double(midSouth, oldCrop.getUpperRight());
        Line2D.Double nwLine = new Line2D.Double(midSouth, oldCrop.getUpperLeft());
        Line2D.Double seLine = new Line2D.Double(midSouth, oldCrop.getLowerRight());
        Line2D.Double swLine = new Line2D.Double(midSouth, oldCrop.getLowerLeft());
        LinkedList<Line2D> lines = new LinkedList<Line2D>();
        lines.add(neLine);
        lines.add(nwLine);
        double oldDiagonalScale = midSouth.distance(oldCrop.getUpperLeft());
        double newDiagonalScale = UnderlayConstraints.getMinimumDistance(midSouth, lines, underlay);
        if (newDiagonalScale < 0.0) {
            newDiagonalScale = Double.MAX_VALUE;
        }
        lines.clear();
        lines.add(seLine);
        lines.add(swLine);
        double oldSouthScale = midSouth.distance(oldCrop.getLowerLeft());
        double newSouthScale = UnderlayConstraints.getMinimumDistance(midSouth, lines, underlay);
        if (newSouthScale < 0.0) {
            newSouthScale = Double.MAX_VALUE;
        }
        double scale = Math.min(newDiagonalScale / oldDiagonalScale, newSouthScale / oldSouthScale);
        Point2D oldCenter = oldCrop.getCenter();
        double angle = oldCrop.getAngle();
        double width = scale * oldCrop.getWidth();
        double height = scale * oldCrop.getHeight();
        double dh = height - oldCrop.getHeight();
        Point2D.Double newCenter = new Point2D.Double(oldCenter.getX() + dh / 2.0 * Math.sin(angle), oldCenter.getY() - dh / 2.0 * Math.cos(angle));
        CropBounds newCrop = new CropBounds((Point2D)newCenter, width, height, angle);
        return newCrop;
    }

    public static CropBounds adjustSouthWithConstraint(CropBounds oldCrop, Rectangle2D underlay) {
        if (UnderlayConstraints.underlayContains(oldCrop, underlay)) {
            return oldCrop;
        }
        Line2D north = UnderlayConstraints.getNorthCropLine(oldCrop);
        Point2D.Double midNorth = new Point2D.Double((north.getP1().getX() + north.getP2().getX()) / 2.0, (north.getP1().getY() + north.getP2().getY()) / 2.0);
        Line2D.Double neLine = new Line2D.Double(midNorth, oldCrop.getUpperRight());
        Line2D.Double nwLine = new Line2D.Double(midNorth, oldCrop.getUpperLeft());
        Line2D.Double seLine = new Line2D.Double(midNorth, oldCrop.getLowerRight());
        Line2D.Double swLine = new Line2D.Double(midNorth, oldCrop.getLowerLeft());
        LinkedList<Line2D> lines = new LinkedList<Line2D>();
        lines.add(seLine);
        lines.add(swLine);
        double oldDiagonalScale = midNorth.distance(oldCrop.getLowerLeft());
        double newDiagonalScale = UnderlayConstraints.getMinimumDistance(midNorth, lines, underlay);
        if (newDiagonalScale < 0.0) {
            newDiagonalScale = Double.MAX_VALUE;
        }
        lines.clear();
        lines.add(neLine);
        lines.add(nwLine);
        double oldNorthScale = midNorth.distance(oldCrop.getUpperLeft());
        double newNorthScale = UnderlayConstraints.getMinimumDistance(midNorth, lines, underlay);
        if (newNorthScale < 0.0) {
            newNorthScale = Double.MAX_VALUE;
        }
        double scale = Math.min(newDiagonalScale / oldDiagonalScale, newNorthScale / oldNorthScale);
        Point2D oldCenter = oldCrop.getCenter();
        double angle = oldCrop.getAngle();
        double width = scale * oldCrop.getWidth();
        double height = scale * oldCrop.getHeight();
        double dh = height - oldCrop.getHeight();
        Point2D.Double newCenter = new Point2D.Double(oldCenter.getX() - dh / 2.0 * Math.sin(angle), oldCenter.getY() + dh / 2.0 * Math.cos(angle));
        CropBounds newCrop = new CropBounds((Point2D)newCenter, width, height, angle);
        return newCrop;
    }

    public static CropBounds adjustEastWithConstraint(CropBounds oldCrop, Rectangle2D underlay) {
        if (UnderlayConstraints.underlayContains(oldCrop, underlay)) {
            return oldCrop;
        }
        Line2D west = UnderlayConstraints.getWestCropLine(oldCrop);
        Point2D.Double midWest = new Point2D.Double((west.getP1().getX() + west.getP2().getX()) / 2.0, (west.getP1().getY() + west.getP2().getY()) / 2.0);
        Line2D.Double neLine = new Line2D.Double(midWest, oldCrop.getUpperRight());
        Line2D.Double nwLine = new Line2D.Double(midWest, oldCrop.getUpperLeft());
        Line2D.Double seLine = new Line2D.Double(midWest, oldCrop.getLowerRight());
        Line2D.Double swLine = new Line2D.Double(midWest, oldCrop.getLowerLeft());
        LinkedList<Line2D> lines = new LinkedList<Line2D>();
        lines.add(neLine);
        lines.add(seLine);
        double oldDiagonalScale = midWest.distance(oldCrop.getUpperRight());
        double newDiagonalScale = UnderlayConstraints.getMinimumDistance(midWest, lines, underlay);
        if (newDiagonalScale < 0.0) {
            newDiagonalScale = Double.MAX_VALUE;
        }
        lines.clear();
        lines.add(nwLine);
        lines.add(swLine);
        double oldWestScale = midWest.distance(oldCrop.getUpperLeft());
        double newWestScale = UnderlayConstraints.getMinimumDistance(midWest, lines, underlay);
        if (newWestScale < 0.0) {
            newWestScale = Double.MAX_VALUE;
        }
        double scale = Math.min(newDiagonalScale / oldDiagonalScale, newWestScale / oldWestScale);
        Point2D oldCenter = oldCrop.getCenter();
        double angle = oldCrop.getAngle();
        double width = scale * oldCrop.getWidth();
        double height = scale * oldCrop.getHeight();
        double dw = width - oldCrop.getWidth();
        Point2D.Double newCenter = new Point2D.Double(oldCenter.getX() + dw / 2.0 * Math.cos(angle), oldCenter.getY() + dw / 2.0 * Math.sin(angle));
        CropBounds newCrop = new CropBounds((Point2D)newCenter, width, height, angle);
        return newCrop;
    }

    public static CropBounds adjustWestWithConstraint(CropBounds oldCrop, Rectangle2D underlay) {
        if (UnderlayConstraints.underlayContains(oldCrop, underlay)) {
            return oldCrop;
        }
        Line2D east = UnderlayConstraints.getEastCropLine(oldCrop);
        Point2D.Double midEast = new Point2D.Double((east.getP1().getX() + east.getP2().getX()) / 2.0, (east.getP1().getY() + east.getP2().getY()) / 2.0);
        Line2D.Double neLine = new Line2D.Double(midEast, oldCrop.getUpperRight());
        Line2D.Double nwLine = new Line2D.Double(midEast, oldCrop.getUpperLeft());
        Line2D.Double seLine = new Line2D.Double(midEast, oldCrop.getLowerRight());
        Line2D.Double swLine = new Line2D.Double(midEast, oldCrop.getLowerLeft());
        LinkedList<Line2D> lines = new LinkedList<Line2D>();
        lines.add(nwLine);
        lines.add(swLine);
        double oldDiagonalScale = midEast.distance(oldCrop.getUpperLeft());
        double newDiagonalScale = UnderlayConstraints.getMinimumDistance(midEast, lines, underlay);
        if (newDiagonalScale < 0.0) {
            newDiagonalScale = Double.MAX_VALUE;
        }
        lines.clear();
        lines.add(neLine);
        lines.add(seLine);
        double oldEastScale = midEast.distance(oldCrop.getUpperRight());
        double newEastScale = UnderlayConstraints.getMinimumDistance(midEast, lines, underlay);
        if (newEastScale < 0.0) {
            newEastScale = Double.MAX_VALUE;
        }
        double scale = Math.min(newDiagonalScale / oldDiagonalScale, newEastScale / oldEastScale);
        Point2D oldCenter = oldCrop.getCenter();
        double angle = oldCrop.getAngle();
        double width = scale * oldCrop.getWidth();
        double height = scale * oldCrop.getHeight();
        double dw = width - oldCrop.getWidth();
        Point2D.Double newCenter = new Point2D.Double(oldCenter.getX() - dw / 2.0 * Math.cos(angle), oldCenter.getY() - dw / 2.0 * Math.sin(angle));
        CropBounds newCrop = new CropBounds((Point2D)newCenter, width, height, angle);
        return newCrop;
    }

    public static CropBounds adjustNorthEastToUnderlay(CropBounds oldCrop, Rectangle2D underlay) {
        if (UnderlayConstraints.underlayContains(oldCrop, underlay)) {
            return oldCrop;
        }
        Point2D sw = oldCrop.getLowerLeft();
        Point2D ne = oldCrop.getUpperRight();
        Line2D.Double diagonal = new Line2D.Double(sw, ne);
        double oldDiag = sw.distance(ne);
        double newDiag = UnderlayConstraints.getMinimumDistance(sw, Collections.singleton(diagonal), underlay);
        double diagScale = newDiag / oldDiag;
        Point2D se = oldCrop.getLowerRight();
        Line2D south = UnderlayConstraints.getSouthCropLine(oldCrop);
        double oldSouth = sw.distance(se);
        double newSouth = UnderlayConstraints.getMinimumDistance(sw, Collections.singleton(south), underlay);
        double southScale = newSouth / oldSouth;
        Point2D nw = oldCrop.getUpperLeft();
        Line2D west = UnderlayConstraints.getWestCropLine(oldCrop);
        double oldWest = sw.distance(nw);
        double newWest = UnderlayConstraints.getMinimumDistance(sw, Collections.singleton(west), underlay);
        double westScale = newWest / oldWest;
        double scale = UnderlayConstraints.minIgnoreNegative(1.0, diagScale);
        scale = UnderlayConstraints.minIgnoreNegative(scale, southScale);
        scale = UnderlayConstraints.minIgnoreNegative(scale, westScale);
        Point2D oldCenter = oldCrop.getCenter();
        double angle = oldCrop.getAngle();
        double width = scale * oldCrop.getWidth();
        double height = scale * oldCrop.getHeight();
        double dw = width - oldCrop.getWidth();
        double dh = height - oldCrop.getHeight();
        Point2D.Double newCenter = new Point2D.Double(oldCenter.getX() + dw / 2.0 * Math.cos(angle) + dh / 2.0 * Math.sin(angle), oldCenter.getY() - dh / 2.0 * Math.cos(angle) + dw / 2.0 * Math.sin(angle));
        CropBounds newCrop = new CropBounds((Point2D)newCenter, width, height, angle);
        return newCrop;
    }

    public static CropBounds adjustNorthWestToUnderlay(CropBounds oldCrop, Rectangle2D underlay) {
        if (UnderlayConstraints.underlayContains(oldCrop, underlay)) {
            return oldCrop;
        }
        Point2D se = oldCrop.getLowerRight();
        Point2D nw = oldCrop.getUpperLeft();
        Line2D.Double diagonal = new Line2D.Double(se, nw);
        double oldDiag = se.distance(nw);
        double newDiag = UnderlayConstraints.getMinimumDistance(se, Collections.singleton(diagonal), underlay);
        double diagScale = newDiag / oldDiag;
        Point2D sw = oldCrop.getLowerLeft();
        Line2D south = UnderlayConstraints.getSouthCropLine(oldCrop);
        double oldSouth = sw.distance(se);
        double newSouth = UnderlayConstraints.getMinimumDistance(se, Collections.singleton(south), underlay);
        double southScale = newSouth / oldSouth;
        Point2D ne = oldCrop.getUpperRight();
        Line2D east = UnderlayConstraints.getEastCropLine(oldCrop);
        double oldEast = se.distance(ne);
        double newEast = UnderlayConstraints.getMinimumDistance(se, Collections.singleton(east), underlay);
        double eastScale = newEast / oldEast;
        double scale = UnderlayConstraints.minIgnoreNegative(1.0, diagScale);
        scale = UnderlayConstraints.minIgnoreNegative(scale, southScale);
        scale = UnderlayConstraints.minIgnoreNegative(scale, eastScale);
        Point2D oldCenter = oldCrop.getCenter();
        double angle = oldCrop.getAngle();
        double width = scale * oldCrop.getWidth();
        double height = scale * oldCrop.getHeight();
        double dw = width - oldCrop.getWidth();
        double dh = height - oldCrop.getHeight();
        Point2D.Double newCenter = new Point2D.Double(oldCenter.getX() - dw / 2.0 * Math.cos(angle) + dh / 2.0 * Math.sin(angle), oldCenter.getY() - dh / 2.0 * Math.cos(angle) - dw / 2.0 * Math.sin(angle));
        CropBounds newCrop = new CropBounds((Point2D)newCenter, width, height, angle);
        return newCrop;
    }

    public static CropBounds adjustSouthEastToUnderlay(CropBounds oldCrop, Rectangle2D underlay) {
        if (UnderlayConstraints.underlayContains(oldCrop, underlay)) {
            return oldCrop;
        }
        Point2D se = oldCrop.getLowerRight();
        Point2D nw = oldCrop.getUpperLeft();
        Line2D.Double diagonal = new Line2D.Double(se, nw);
        double oldDiag = se.distance(nw);
        double newDiag = UnderlayConstraints.getMinimumDistance(nw, Collections.singleton(diagonal), underlay);
        double diagScale = newDiag / oldDiag;
        Point2D ne = oldCrop.getUpperRight();
        Line2D north = UnderlayConstraints.getNorthCropLine(oldCrop);
        double oldNorth = nw.distance(ne);
        double newNorth = UnderlayConstraints.getMinimumDistance(nw, Collections.singleton(north), underlay);
        double northScale = newNorth / oldNorth;
        Point2D sw = oldCrop.getLowerLeft();
        Line2D west = UnderlayConstraints.getWestCropLine(oldCrop);
        double oldWest = sw.distance(nw);
        double newWest = UnderlayConstraints.getMinimumDistance(nw, Collections.singleton(west), underlay);
        double westScale = newWest / oldWest;
        double scale = UnderlayConstraints.minIgnoreNegative(1.0, diagScale);
        scale = UnderlayConstraints.minIgnoreNegative(scale, northScale);
        scale = UnderlayConstraints.minIgnoreNegative(scale, westScale);
        Point2D oldCenter = oldCrop.getCenter();
        double angle = oldCrop.getAngle();
        double width = scale * oldCrop.getWidth();
        double height = scale * oldCrop.getHeight();
        double dw = width - oldCrop.getWidth();
        double dh = height - oldCrop.getHeight();
        Point2D.Double newCenter = new Point2D.Double(oldCenter.getX() + dw / 2.0 * Math.cos(angle) - dh / 2.0 * Math.sin(angle), oldCenter.getY() + dh / 2.0 * Math.cos(angle) + dw / 2.0 * Math.sin(angle));
        CropBounds newCrop = new CropBounds((Point2D)newCenter, width, height, angle);
        return newCrop;
    }

    public static CropBounds adjustSouthWestToUnderlay(CropBounds oldCrop, Rectangle2D underlay) {
        if (UnderlayConstraints.underlayContains(oldCrop, underlay)) {
            return oldCrop;
        }
        Point2D sw = oldCrop.getLowerLeft();
        Point2D ne = oldCrop.getUpperRight();
        Line2D.Double diagonal = new Line2D.Double(sw, ne);
        double oldDiag = sw.distance(ne);
        double newDiag = UnderlayConstraints.getMinimumDistance(ne, Collections.singleton(diagonal), underlay);
        double diagScale = newDiag / oldDiag;
        Point2D nw = oldCrop.getUpperLeft();
        Line2D north = UnderlayConstraints.getNorthCropLine(oldCrop);
        double oldNorth = nw.distance(ne);
        double newNorth = UnderlayConstraints.getMinimumDistance(ne, Collections.singleton(north), underlay);
        double northScale = newNorth / oldNorth;
        Point2D se = oldCrop.getLowerRight();
        Line2D east = UnderlayConstraints.getEastCropLine(oldCrop);
        double oldEast = ne.distance(se);
        double newEast = UnderlayConstraints.getMinimumDistance(ne, Collections.singleton(east), underlay);
        double eastScale = newEast / oldEast;
        double scale = UnderlayConstraints.minIgnoreNegative(1.0, diagScale);
        scale = UnderlayConstraints.minIgnoreNegative(scale, northScale);
        scale = UnderlayConstraints.minIgnoreNegative(scale, eastScale);
        Point2D oldCenter = oldCrop.getCenter();
        double angle = oldCrop.getAngle();
        double width = scale * oldCrop.getWidth();
        double height = scale * oldCrop.getHeight();
        double dw = width - oldCrop.getWidth();
        double dh = height - oldCrop.getHeight();
        Point2D.Double newCenter = new Point2D.Double(oldCenter.getX() - dw / 2.0 * Math.cos(angle) - dh / 2.0 * Math.sin(angle), oldCenter.getY() + dh / 2.0 * Math.cos(angle) - dw / 2.0 * Math.sin(angle));
        CropBounds newCrop = new CropBounds((Point2D)newCenter, width, height, angle);
        return newCrop;
    }

    private static double getMinimumDistance(Point2D p, Collection<Line2D> lines, Rectangle2D underlay) {
        Line2D top = UnderlayConstraints.getTopUnderlayLine(underlay);
        Line2D left = UnderlayConstraints.getLeftUnderlayLine(underlay);
        Line2D bottom = UnderlayConstraints.getBottomUnderlayLine(underlay);
        Line2D right = UnderlayConstraints.getRightUnderlayLine(underlay);
        LinkedList<Point2D> intersections = new LinkedList<Point2D>();
        for (Line2D line : lines) {
            Point2D t = UnderlayConstraints.getIntersection(top, line);
            Point2D l = UnderlayConstraints.getIntersection(left, line);
            Point2D b = UnderlayConstraints.getIntersection(bottom, line);
            Point2D r = UnderlayConstraints.getIntersection(right, line);
            if (t != null) {
                intersections.add(t);
            }
            if (l != null) {
                intersections.add(l);
            }
            if (b != null) {
                intersections.add(b);
            }
            if (r == null) continue;
            intersections.add(r);
        }
        if (intersections.isEmpty()) {
            return -1.0;
        }
        double distance = Double.MAX_VALUE;
        for (Point2D q : intersections) {
            distance = Math.min(distance, p.distance(q));
        }
        return distance;
    }

    private static Line2D getNorthCropLine(CropBounds crop) {
        return new Line2D.Double(crop.getUpperLeft(), crop.getUpperRight());
    }

    private static Line2D getSouthCropLine(CropBounds crop) {
        return new Line2D.Double(crop.getLowerRight(), crop.getLowerLeft());
    }

    private static Line2D getEastCropLine(CropBounds crop) {
        return new Line2D.Double(crop.getUpperRight(), crop.getLowerRight());
    }

    private static Line2D getWestCropLine(CropBounds crop) {
        return new Line2D.Double(crop.getLowerLeft(), crop.getUpperLeft());
    }

    private static Line2D getTopUnderlayLine(Rectangle2D underlay) {
        return new Line2D.Double(underlay.getMinX(), underlay.getMinY(), underlay.getMaxX(), underlay.getMinY());
    }

    private static Line2D getLeftUnderlayLine(Rectangle2D underlay) {
        return new Line2D.Double(underlay.getMinX(), underlay.getMinY(), underlay.getMinX(), underlay.getMaxY());
    }

    private static Line2D getBottomUnderlayLine(Rectangle2D underlay) {
        return new Line2D.Double(underlay.getMinX(), underlay.getMaxY(), underlay.getMaxX(), underlay.getMaxY());
    }

    private static Line2D getRightUnderlayLine(Rectangle2D underlay) {
        return new Line2D.Double(underlay.getMaxX(), underlay.getMinY(), underlay.getMaxX(), underlay.getMaxY());
    }

    private static Point2D getIntersection(Line2D line1, Line2D line2) {
        if (line1.intersectsLine(line2)) {
            Point2D p1 = line1.getP1();
            Point2D p2 = line1.getP2();
            Point2D q1 = line2.getP1();
            Point2D q2 = line2.getP2();
            double p1x = p1.getX();
            double p1y = p1.getY();
            double p2x = p2.getX();
            double p2y = p2.getY();
            double q1x = q1.getX();
            double q1y = q1.getY();
            double q2x = q2.getX();
            double q2y = q2.getY();
            double c = ((q2x - q1x) * (p1y - q1y) - (q2y - q1y) * (p1x - q1x)) / ((p2x - p1x) * (q2y - q1y) - (p2y - p1y) * (q2x - q1x));
            Point2D.Double i = new Point2D.Double(p1x + c * (p2x - p1x), p1y + c * (p2y - p1y));
            return i;
        }
        return null;
    }

    private static Line2D getSegmentThroughPoint(Line2D seg, Point2D p) {
        Point2D p1 = seg.getP1();
        Point2D p2 = seg.getP2();
        double angle = Math.atan2(p2.getY() - p1.getY(), p2.getX() - p1.getX());
        double distance = seg.ptLineDist(p);
        int ccw = seg.relativeCCW(p);
        double dx = (distance *= (double)(-ccw)) * Math.cos(angle += 1.5707963267948966);
        double dy = distance * Math.sin(angle);
        p1 = new Point2D.Double(p1.getX() + dx, p1.getY() + dy);
        p2 = new Point2D.Double(p2.getX() + dx, p2.getY() + dy);
        return new Line2D.Double(p1, p2);
    }

    private static double minIgnoreNegative(double current, double next) {
        return next > 0.001 ? Math.min(current, next) : current;
    }

    private static double lrrHeight(CropBounds crop, Rectangle2D underlay) {
        Point2D c = crop.getCenter();
        double cx = c.getX();
        double cy = c.getY();
        double cw = crop.getWidth();
        double ch = crop.getHeight();
        double uMx = underlay.getMaxX();
        double umx = underlay.getMinX();
        double uMy = underlay.getMaxY();
        double umy = underlay.getMinY();
        double angle = crop.getAngle();
        double aspect = crop.getWidth() / crop.getHeight();
        double constraint = 2.0 / Math.sqrt(1.0 + aspect * aspect) * (uMx - cx) / Math.cos(angle + Math.atan2(-ch, cw));
        return !Double.isNaN(constraint) ? constraint : -1.0;
    }

    private static double lrlHeight(CropBounds crop, Rectangle2D underlay) {
        Point2D c = crop.getCenter();
        double cx = c.getX();
        double cy = c.getY();
        double cw = crop.getWidth();
        double ch = crop.getHeight();
        double uMx = underlay.getMaxX();
        double umx = underlay.getMinX();
        double uMy = underlay.getMaxY();
        double umy = underlay.getMinY();
        double angle = crop.getAngle();
        double aspect = crop.getWidth() / crop.getHeight();
        double constraint = 2.0 / Math.sqrt(1.0 + aspect * aspect) * (umx - cx) / Math.cos(angle + Math.atan2(-ch, cw));
        return !Double.isNaN(constraint) ? constraint : -1.0;
    }

    private static double lrtHeight(CropBounds crop, Rectangle2D underlay) {
        Point2D c = crop.getCenter();
        double cx = c.getX();
        double cy = c.getY();
        double cw = crop.getWidth();
        double ch = crop.getHeight();
        double uMx = underlay.getMaxX();
        double umx = underlay.getMinX();
        double uMy = underlay.getMaxY();
        double umy = underlay.getMinY();
        double angle = crop.getAngle();
        double aspect = crop.getWidth() / crop.getHeight();
        double constraint = 2.0 / Math.sqrt(1.0 + aspect * aspect) * (uMy - cy) / Math.sin(angle + Math.atan2(-ch, cw));
        return !Double.isNaN(constraint) ? constraint : -1.0;
    }

    private static double lrbHeight(CropBounds crop, Rectangle2D underlay) {
        Point2D c = crop.getCenter();
        double cx = c.getX();
        double cy = c.getY();
        double cw = crop.getWidth();
        double ch = crop.getHeight();
        double uMx = underlay.getMaxX();
        double umx = underlay.getMinX();
        double uMy = underlay.getMaxY();
        double umy = underlay.getMinY();
        double angle = crop.getAngle();
        double aspect = crop.getWidth() / crop.getHeight();
        double constraint = 2.0 / Math.sqrt(1.0 + aspect * aspect) * (umy - cy) / Math.sin(angle + Math.atan2(-ch, cw));
        return !Double.isNaN(constraint) ? constraint : -1.0;
    }

    private static double urrHeight(CropBounds crop, Rectangle2D underlay) {
        Point2D c = crop.getCenter();
        double cx = c.getX();
        double cy = c.getY();
        double cw = crop.getWidth();
        double ch = crop.getHeight();
        double uMx = underlay.getMaxX();
        double umx = underlay.getMinX();
        double uMy = underlay.getMaxY();
        double umy = underlay.getMinY();
        double angle = crop.getAngle();
        double aspect = crop.getWidth() / crop.getHeight();
        double constraint = 2.0 / Math.sqrt(1.0 + aspect * aspect) * (uMx - cx) / Math.cos(angle + Math.atan2(ch, cw));
        return !Double.isNaN(constraint) ? constraint : -1.0;
    }

    private static double urlHeight(CropBounds crop, Rectangle2D underlay) {
        Point2D c = crop.getCenter();
        double cx = c.getX();
        double cy = c.getY();
        double cw = crop.getWidth();
        double ch = crop.getHeight();
        double uMx = underlay.getMaxX();
        double umx = underlay.getMinX();
        double uMy = underlay.getMaxY();
        double umy = underlay.getMinY();
        double angle = crop.getAngle();
        double aspect = crop.getWidth() / crop.getHeight();
        double constraint = 2.0 / Math.sqrt(1.0 + aspect * aspect) * (umx - cx) / Math.cos(angle + Math.atan2(ch, cw));
        return !Double.isNaN(constraint) ? constraint : -1.0;
    }

    private static double urtHeight(CropBounds crop, Rectangle2D underlay) {
        Point2D c = crop.getCenter();
        double cx = c.getX();
        double cy = c.getY();
        double cw = crop.getWidth();
        double ch = crop.getHeight();
        double uMx = underlay.getMaxX();
        double umx = underlay.getMinX();
        double uMy = underlay.getMaxY();
        double umy = underlay.getMinY();
        double angle = crop.getAngle();
        double aspect = crop.getWidth() / crop.getHeight();
        double constraint = 2.0 / Math.sqrt(1.0 + aspect * aspect) * (uMy - cy) / Math.sin(angle + Math.atan2(ch, cw));
        return !Double.isNaN(constraint) ? constraint : -1.0;
    }

    private static double urbHeight(CropBounds crop, Rectangle2D underlay) {
        Point2D c = crop.getCenter();
        double cx = c.getX();
        double cy = c.getY();
        double cw = crop.getWidth();
        double ch = crop.getHeight();
        double uMx = underlay.getMaxX();
        double umx = underlay.getMinX();
        double uMy = underlay.getMaxY();
        double umy = underlay.getMinY();
        double angle = crop.getAngle();
        double aspect = crop.getWidth() / crop.getHeight();
        double constraint = 2.0 / Math.sqrt(1.0 + aspect * aspect) * (umy - cy) / Math.sin(angle + Math.atan2(ch, cw));
        return !Double.isNaN(constraint) ? constraint : -1.0;
    }

    private static double ulrHeight(CropBounds crop, Rectangle2D underlay) {
        Point2D c = crop.getCenter();
        double cx = c.getX();
        double cy = c.getY();
        double cw = crop.getWidth();
        double ch = crop.getHeight();
        double uMx = underlay.getMaxX();
        double umx = underlay.getMinX();
        double uMy = underlay.getMaxY();
        double umy = underlay.getMinY();
        double angle = crop.getAngle();
        double aspect = crop.getWidth() / crop.getHeight();
        double constraint = 2.0 / Math.sqrt(1.0 + aspect * aspect) * (uMx - cx) / Math.cos(angle + Math.atan2(ch, -cw));
        return !Double.isNaN(constraint) ? constraint : -1.0;
    }

    private static double ullHeight(CropBounds crop, Rectangle2D underlay) {
        Point2D c = crop.getCenter();
        double cx = c.getX();
        double cy = c.getY();
        double cw = crop.getWidth();
        double ch = crop.getHeight();
        double uMx = underlay.getMaxX();
        double umx = underlay.getMinX();
        double uMy = underlay.getMaxY();
        double umy = underlay.getMinY();
        double angle = crop.getAngle();
        double aspect = crop.getWidth() / crop.getHeight();
        double constraint = 2.0 / Math.sqrt(1.0 + aspect * aspect) * (umx - cx) / Math.cos(angle + Math.atan2(ch, -cw));
        return !Double.isNaN(constraint) ? constraint : -1.0;
    }

    private static double ultHeight(CropBounds crop, Rectangle2D underlay) {
        Point2D c = crop.getCenter();
        double cx = c.getX();
        double cy = c.getY();
        double cw = crop.getWidth();
        double ch = crop.getHeight();
        double uMx = underlay.getMaxX();
        double umx = underlay.getMinX();
        double uMy = underlay.getMaxY();
        double umy = underlay.getMinY();
        double angle = crop.getAngle();
        double aspect = crop.getWidth() / crop.getHeight();
        double constraint = 2.0 / Math.sqrt(1.0 + aspect * aspect) * (uMy - cy) / Math.sin(angle + Math.atan2(ch, -cw));
        return !Double.isNaN(constraint) ? constraint : -1.0;
    }

    private static double ulbHeight(CropBounds crop, Rectangle2D underlay) {
        Point2D c = crop.getCenter();
        double cx = c.getX();
        double cy = c.getY();
        double cw = crop.getWidth();
        double ch = crop.getHeight();
        double uMx = underlay.getMaxX();
        double umx = underlay.getMinX();
        double uMy = underlay.getMaxY();
        double umy = underlay.getMinY();
        double angle = crop.getAngle();
        double aspect = crop.getWidth() / crop.getHeight();
        double constraint = 2.0 / Math.sqrt(1.0 + aspect * aspect) * (umy - cy) / Math.sin(angle + Math.atan2(ch, -cw));
        return !Double.isNaN(constraint) ? constraint : -1.0;
    }

    private static double llrHeight(CropBounds crop, Rectangle2D underlay) {
        Point2D c = crop.getCenter();
        double cx = c.getX();
        double cy = c.getY();
        double cw = crop.getWidth();
        double ch = crop.getHeight();
        double uMx = underlay.getMaxX();
        double umx = underlay.getMinX();
        double uMy = underlay.getMaxY();
        double umy = underlay.getMinY();
        double angle = crop.getAngle();
        double aspect = crop.getWidth() / crop.getHeight();
        double constraint = 2.0 / Math.sqrt(1.0 + aspect * aspect) * (uMx - cx) / Math.cos(angle + Math.atan2(-ch, -cw));
        return !Double.isNaN(constraint) ? constraint : -1.0;
    }

    private static double lllHeight(CropBounds crop, Rectangle2D underlay) {
        Point2D c = crop.getCenter();
        double cx = c.getX();
        double cy = c.getY();
        double cw = crop.getWidth();
        double ch = crop.getHeight();
        double uMx = underlay.getMaxX();
        double umx = underlay.getMinX();
        double uMy = underlay.getMaxY();
        double umy = underlay.getMinY();
        double angle = crop.getAngle();
        double aspect = crop.getWidth() / crop.getHeight();
        double constraint = 2.0 / Math.sqrt(1.0 + aspect * aspect) * (umx - cx) / Math.cos(angle + Math.atan2(-ch, -cw));
        return !Double.isNaN(constraint) ? constraint : -1.0;
    }

    private static double lltHeight(CropBounds crop, Rectangle2D underlay) {
        Point2D c = crop.getCenter();
        double cx = c.getX();
        double cy = c.getY();
        double cw = crop.getWidth();
        double ch = crop.getHeight();
        double uMx = underlay.getMaxX();
        double umx = underlay.getMinX();
        double uMy = underlay.getMaxY();
        double umy = underlay.getMinY();
        double angle = crop.getAngle();
        double aspect = crop.getWidth() / crop.getHeight();
        double constraint = 2.0 / Math.sqrt(1.0 + aspect * aspect) * (uMy - cy) / Math.sin(angle + Math.atan2(-ch, -cw));
        return !Double.isNaN(constraint) ? constraint : -1.0;
    }

    private static double llbHeight(CropBounds crop, Rectangle2D underlay) {
        Point2D c = crop.getCenter();
        double cx = c.getX();
        double cy = c.getY();
        double cw = crop.getWidth();
        double ch = crop.getHeight();
        double uMx = underlay.getMaxX();
        double umx = underlay.getMinX();
        double uMy = underlay.getMaxY();
        double umy = underlay.getMinY();
        double angle = crop.getAngle();
        double aspect = crop.getWidth() / crop.getHeight();
        double constraint = 2.0 / Math.sqrt(1.0 + aspect * aspect) * (umy - cy) / Math.sin(angle + Math.atan2(-ch, -cw));
        return !Double.isNaN(constraint) ? constraint : -1.0;
    }

    private static CropBounds translateCrop(CropBounds oldCrop, double dx, double dy) {
        Point2D center = oldCrop.getCenter();
        double width = oldCrop.getWidth();
        double height = oldCrop.getHeight();
        double angle = oldCrop.getAngle();
        center.setLocation(center.getX() + dx, center.getY() + dy);
        CropBounds newCrop = new CropBounds(center, width, height, angle);
        return newCrop;
    }

    static boolean underlayContains(CropBounds newCrop, Rectangle2D underlay) {
        if (underlay == null) {
            return true;
        }
        Rectangle2D.Double outsetRect = new Rectangle2D.Double(underlay.getX() - 0.001, underlay.getY() - 0.001, underlay.getWidth() + 0.002, underlay.getHeight() + 0.002);
        if (!outsetRect.contains(newCrop.getUpperLeft())) {
            return false;
        }
        if (!outsetRect.contains(newCrop.getUpperRight())) {
            return false;
        }
        if (!outsetRect.contains(newCrop.getLowerLeft())) {
            return false;
        }
        return outsetRect.contains(newCrop.getLowerRight());
    }

    private static Shape getCropAsShape(CropBounds crop) {
        if (crop == null || crop.isAngleOnly()) {
            return null;
        }
        Point2D ul = crop.getUpperLeft();
        Point2D ur = crop.getUpperRight();
        Point2D ll = crop.getLowerLeft();
        Point2D lr = crop.getLowerRight();
        GeneralPath path = new GeneralPath();
        path.moveTo((float)ul.getX(), (float)ul.getY());
        path.lineTo((float)ur.getX(), (float)ur.getY());
        path.lineTo((float)lr.getX(), (float)lr.getY());
        path.lineTo((float)ll.getX(), (float)ll.getY());
        path.closePath();
        return path;
    }

    static boolean isRotateDefinedCrop(CropBounds crop, Rectangle2D underlay) {
        Point2D nw = crop.getUpperLeft();
        Point2D ne = crop.getUpperRight();
        Point2D sw = crop.getLowerLeft();
        Point2D se = crop.getLowerRight();
        double nwDist = UnderlayConstraints.getMinimumDistance(nw, underlay);
        double neDist = UnderlayConstraints.getMinimumDistance(ne, underlay);
        double swDist = UnderlayConstraints.getMinimumDistance(sw, underlay);
        double seDist = UnderlayConstraints.getMinimumDistance(se, underlay);
        if (nwDist < 0.001 && seDist < 0.001) {
            return true;
        }
        return swDist < 0.001 && neDist < 0.001;
    }

    private static double getMinimumDistance(Point2D p, Rectangle2D underlay) {
        Line2D top = UnderlayConstraints.getTopUnderlayLine(underlay);
        Line2D bottom = UnderlayConstraints.getBottomUnderlayLine(underlay);
        Line2D left = UnderlayConstraints.getLeftUnderlayLine(underlay);
        Line2D right = UnderlayConstraints.getRightUnderlayLine(underlay);
        double dist = top.ptLineDist(p);
        dist = Math.min(dist, bottom.ptLineDist(p));
        dist = Math.min(dist, left.ptLineDist(p));
        dist = Math.min(dist, right.ptLineDist(p));
        return dist;
    }
}

