/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.datatips.xswing;

import com.lightcrafts.ui.datatips.xswing.DataTipCell;
import com.lightcrafts.ui.datatips.xswing.DataTipPopup;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

abstract class DataTipListener
extends MouseInputAdapter
implements ComponentListener {
    private DataTipPopup dataTipPopup;
    private static final Class[] NO_PARAMETERS = new Class[0];
    private static final Object[] NO_ARGUMENTS = new Object[0];
    private static Class mouseInfoClass;
    private static Method getPointerInfoMethod;
    private static Class pointerInfoClass;
    private static Method getLocationMethod;

    DataTipListener() {
    }

    abstract DataTipCell getCell(JComponent var1, Point var2);

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
        this.checkShowOrHide(event);
    }

    @Override
    public void mouseExited(MouseEvent event) {
        this.checkShowOrHide(event);
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        this.checkShowOrHide(event);
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        this.checkShowOrHide(event);
    }

    private void checkShowOrHide(MouseEvent event) {
        JComponent component = (JComponent)event.getSource();
        Point mousePosition = event.getPoint();
        this.checkShowOrHide(component, mousePosition);
    }

    private void checkShowOrHide(JComponent component, Point mousePosition) {
        DataTipCell currentPopupCell;
        Window windowAncestor = SwingUtilities.getWindowAncestor(component);
        if (windowAncestor == null || !windowAncestor.isActive()) {
            this.hideTip();
            return;
        }
        DataTipCell dataTipCell = this.getCell(component, mousePosition);
        Rectangle visRect = component.getVisibleRect();
        if (!visRect.contains(mousePosition)) {
            dataTipCell = DataTipCell.NONE;
        }
        if (dataTipCell.equals(currentPopupCell = this.getCurrentPopupCell())) {
            return;
        }
        this.hideTip();
        if (!dataTipCell.isSet()) {
            return;
        }
        this.dataTipPopup = this.createPopup(component, mousePosition, dataTipCell);
    }

    private DataTipCell getCurrentPopupCell() {
        if (!this.isTipShown()) {
            return DataTipCell.NONE;
        }
        return this.dataTipPopup.getCell();
    }

    private DataTipPopup createPopup(JComponent component, Point mousePosition, DataTipCell dataTipCell) {
        Rectangle visRect;
        Rectangle cellBounds = dataTipCell.getCellBounds();
        Rectangle visibleCellRectangle = cellBounds.intersection(visRect = component.getVisibleRect());
        if (!visibleCellRectangle.contains(mousePosition)) {
            return null;
        }
        Component rendererComponent = dataTipCell.getRendererComponent();
        Dimension rendCompDim = rendererComponent.getMinimumSize();
        Rectangle rendCompBounds = new Rectangle(cellBounds.getLocation(), rendCompDim);
        if (cellBounds.contains(rendCompBounds) && visRect.contains(rendCompBounds)) {
            return null;
        }
        Dimension preferredSize = rendererComponent.getPreferredSize();
        Point tipPosition = cellBounds.getLocation();
        int width = Math.max(cellBounds.width, preferredSize.width);
        int height = Math.max(cellBounds.height, preferredSize.height);
        Dimension tipDimension = new Dimension(width, height);
        DataTipPopup dataTipPopup = new DataTipPopup(component, dataTipCell, tipPosition, tipDimension);
        return dataTipPopup;
    }

    private boolean isTipShown() {
        return this.dataTipPopup != null && this.dataTipPopup.isTipShown();
    }

    private void hideTip() {
        if (this.dataTipPopup != null) {
            this.dataTipPopup.hideTip();
            this.dataTipPopup = null;
        }
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.checkShowOrHide(e);
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        this.checkShowOrHide(e);
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.checkShowOrHide(e);
    }

    @Override
    public void componentHidden(ComponentEvent e) {
        this.hideTip();
    }

    private void checkShowOrHide(ComponentEvent e) {
        JComponent component = (JComponent)e.getSource();
        Point mousePosition = DataTipListener.getCurrentMousePosition();
        if (mousePosition == null) {
            this.hideTip();
        } else {
            SwingUtilities.convertPointFromScreen(mousePosition, component);
            this.checkShowOrHide(component, mousePosition);
        }
    }

    private static Point getCurrentMousePosition() {
        if (mouseInfoClass == null) {
            return null;
        }
        try {
            Object pointerInfo = getPointerInfoMethod.invoke(null, NO_ARGUMENTS);
            Point mousePosition = (Point)getLocationMethod.invoke(pointerInfo, NO_ARGUMENTS);
            return mousePosition;
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return null;
    }

    static {
        try {
            mouseInfoClass = Class.forName("java.awt.MouseInfo");
            getPointerInfoMethod = mouseInfoClass.getMethod("getPointerInfo", NO_PARAMETERS);
            pointerInfoClass = Class.forName("java.awt.PointerInfo");
            getLocationMethod = pointerInfoClass.getMethod("getLocation", NO_PARAMETERS);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

