/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.editor;

import com.lightcrafts.ui.LightZoneSkin;
import com.lightcrafts.ui.editor.DisabledEditor;
import com.lightcrafts.ui.editor.DisabledImageComponent;
import com.lightcrafts.ui.editor.DisabledLabel;
import com.lightcrafts.ui.editor.EllipticLabel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.RenderedImage;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.Scrollable;
import javax.swing.Timer;

class DisabledImages
extends JPanel
implements Scrollable {
    private static final int Gap = 8;
    private static final int MaxImages = 5;
    private LinkedHashMap<Object, DisabledImageComponent> componentMap;
    private DisabledLabel label;
    private EllipticLabel ellipsis;
    private MouseListener mouseListener;
    private boolean firstTime = true;
    final Timer paintTimer = new Timer(300, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            DisabledImages.this.firstTime = false;
            DisabledImages.this.paintTimer.stop();
            DisabledImages.this.repaint();
        }
    });

    DisabledImages(final DisabledEditor.Listener listener) {
        this.setLayout(new GridLayout());
        this.setOpaque(true);
        this.setBackground(LightZoneSkin.Colors.EditorBackground);
        this.componentMap = new LinkedHashMap();
        this.mouseListener = new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent event) {
                Component comp = event.getComponent();
                if (!comp.contains(event.getPoint())) {
                    return;
                }
                Object key = DisabledImages.this.getKeyForComponent(comp);
                if (key != null) {
                    listener.imageClicked(key);
                }
            }
        };
        this.ellipsis = new EllipticLabel();
    }

    @Override
    protected void paintChildren(Graphics graphics) {
        if (this.firstTime) {
            if (!this.paintTimer.isRunning()) {
                this.paintTimer.start();
            }
            return;
        }
        super.paintChildren(graphics);
    }

    private Object getKeyForComponent(Component comp) {
        Set<Map.Entry<Object, DisabledImageComponent>> set = this.componentMap.entrySet();
        for (Map.Entry<Object, DisabledImageComponent> entry : set) {
            if (entry.getValue() != comp) continue;
            return entry.getKey();
        }
        return null;
    }

    void addImage(Object key, RenderedImage image) {
        DisabledImageComponent comp = new DisabledImageComponent(image);
        comp.addMouseListener(this.mouseListener);
        this.componentMap.put(key, comp);
        this.add(comp);
        while (this.componentMap.size() > 5) {
            Iterator<Map.Entry<Object, DisabledImageComponent>> i = this.componentMap.entrySet().iterator();
            Map.Entry<Object, DisabledImageComponent> entry = i.next();
            DisabledImageComponent oldComp = entry.getValue();
            oldComp.removeMouseListener(this.mouseListener);
            this.remove(oldComp);
            i.remove();
            this.ellipsis.increment();
        }
        if (this.ellipsis.getCount() > 0) {
            this.remove(this.ellipsis);
            this.add(this.ellipsis);
        }
        int count = this.getComponentCount();
        int cols = this.getColumnCount();
        int rows = (int)Math.ceil((double)count / (double)cols);
        if (this.label != null) {
            this.remove(this.label);
        }
        this.setLayout(new GridLayout(rows, cols, 8, 8));
    }

    void updateImage(Object key, RenderedImage image) {
        DisabledImageComponent comp = this.componentMap.get(key);
        if (comp != null) {
            comp.setImage(image);
        }
    }

    void removeAllImages() {
        this.removeAll();
        for (DisabledImageComponent comp : this.componentMap.values()) {
            comp.removeMouseListener(this.mouseListener);
        }
        this.componentMap.clear();
        this.setLayout(new GridLayout());
        if (this.label != null) {
            this.setLayout(new BorderLayout());
            this.add(this.label);
        }
        this.ellipsis.reset();
    }

    boolean hasKey(Object key) {
        return this.componentMap.containsKey(key);
    }

    void setDisabledText(String text) {
        if (this.label != null) {
            this.remove(this.label);
            this.label = null;
        }
        if (text != null) {
            this.label = new DisabledLabel(text);
            if (this.getComponentCount() == 0) {
                this.setLayout(new BorderLayout());
                this.add(this.label);
                this.revalidate();
            }
        }
    }

    private int getColumnCount() {
        int count = this.getComponentCount();
        if ((long)count == Math.round(Math.sqrt(count))) {
            return (int)Math.round(Math.sqrt(count));
        }
        return (int)Math.ceil(Math.sqrt(count));
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 0;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 0;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return true;
    }
}

