/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.editor;

import com.lightcrafts.ui.operation.OpStack;
import com.lightcrafts.ui.toolkit.CoolButton;
import com.lightcrafts.ui.toolkit.IconFactory;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.Border;

class OpsToolbar
extends JPanel {
    private static Border ToolBorder = BorderFactory.createEmptyBorder(0, 0, 3, 0);
    private List actions;

    OpsToolbar(OpStack stack) {
        this(stack.getAddActions(), true);
    }

    OpsToolbar() {
        this(OpStack.getStaticAddActions(), false);
    }

    private OpsToolbar(List actions, boolean enabled) {
        this.actions = actions;
        this.setLayout(new BoxLayout(this, 0));
        this.setEnabled(enabled);
        this.initButtons();
        this.setBorder(ToolBorder);
    }

    private void initButtons() {
        boolean enabled = this.isEnabled();
        this.add(Box.createHorizontalGlue());
        CoolButton.ButtonStyle style = CoolButton.ButtonStyle.LEFT;
        Iterator i = this.actions.iterator();
        while (i.hasNext()) {
            Action action = (Action)i.next();
            if (!i.hasNext()) {
                style = CoolButton.ButtonStyle.RIGHT;
            }
            JButton button = OpsToolbar.createButton(action, style);
            button.setEnabled(enabled);
            this.add(button);
            style = CoolButton.ButtonStyle.CENTER;
        }
        this.add(Box.createHorizontalGlue());
    }

    private static JButton createButton(Action action, CoolButton.ButtonStyle style) {
        BufferedImage image = (BufferedImage)action.getValue("IconImageKey");
        image = IconFactory.getScaledImage(image, IconFactory.StandardSize + 1);
        ImageIcon icon = new ImageIcon(image);
        CoolButton button = new CoolButton(style);
        action.putValue("SmallIcon", icon);
        button.setAction(action);
        button.setIcon(icon);
        return button;
    }
}

