/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.editor;

import com.lightcrafts.model.Preview;
import com.lightcrafts.ui.LightZoneSkin;
import com.lightcrafts.ui.editor.Locale;
import java.awt.Component;
import java.util.MissingResourceException;
import java.util.prefs.Preferences;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

final class PreviewTabs
extends JTabbedPane {
    private static final Preferences Prefs = Preferences.userNodeForPackage(PreviewTabs.class);
    private static final String PreviewKey = "Preview";
    private Preview selectedPreview = null;

    PreviewTabs(Preview[] previews) {
        this.setTabLayoutPolicy(1);
        int index = 0;
        for (Preview preview : previews) {
            preview.setBackground(LightZoneSkin.Colors.ToolPanesBackground.brighter());
            this.addTab(preview.getName(), preview);
            String tip = PreviewTabs.getToolTip(preview);
            this.setToolTipTextAt(index++, tip);
        }
        String initPreview = Prefs.get(PreviewKey, "ZoneFinder");
        for (Preview preview : previews) {
            String name = preview.getName();
            if (!name.equals(initPreview)) continue;
            this.setSelectedComponent(preview);
        }
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (PreviewTabs.this.selectedPreview != null) {
                    PreviewTabs.this.selectedPreview.setSelected(false);
                }
                PreviewTabs.this.selectedPreview = (Preview)PreviewTabs.this.getSelectedComponent();
                String name = PreviewTabs.this.selectedPreview.getName();
                Prefs.put(PreviewTabs.PreviewKey, name);
            }
        });
    }

    PreviewTabs() {
        this.addTab("Zones", new JPanel());
        this.addTab("Color Mask", new JPanel());
        this.addTab("Histogram", new JPanel());
        this.addTab("Sampler", new JPanel());
        this.setEnabled(false);
    }

    @Override
    public void addTab(String title, Component component) {
        if (component instanceof Preview) {
            this.selectedPreview = (Preview)component;
        }
        super.addTab(title, component);
    }

    @Override
    public void setSelectedComponent(Component c) {
        if (c instanceof Preview) {
            this.selectedPreview = (Preview)c;
        }
        super.setSelectedComponent(c);
    }

    void setPreview(Preview preview) {
        this.selectedPreview = preview;
        this.setSelectedComponent(preview);
    }

    Preview getPreview() {
        return (Preview)this.getSelectedComponent();
    }

    private static String getToolTip(Preview preview) {
        String name = preview.getName();
        name = name.replaceAll("\\s", "");
        try {
            return Locale.LOCALE.get("PreviewToolTip" + name);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }
}

