/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.editor;

import com.lightcrafts.model.CloneOperation;
import com.lightcrafts.model.Operation;
import com.lightcrafts.model.RedEyeOperation;
import com.lightcrafts.model.Region;
import com.lightcrafts.model.SpotOperation;
import com.lightcrafts.ui.action.ToggleAction;
import com.lightcrafts.ui.editor.CurveTypeButtons;
import com.lightcrafts.ui.editor.EeRegion;
import com.lightcrafts.ui.operation.OpControl;
import com.lightcrafts.ui.operation.OpStackListener;
import com.lightcrafts.ui.operation.SelectableControl;
import com.lightcrafts.ui.region.CurveIterator;
import com.lightcrafts.ui.region.CurveSelection;
import com.lightcrafts.ui.region.RegionListener;
import com.lightcrafts.ui.region.RegionOverlay;
import com.lightcrafts.ui.region.SharedShape;
import com.lightcrafts.utils.xml.XMLException;
import com.lightcrafts.utils.xml.XmlNode;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import javax.swing.event.UndoableEditListener;

public class RegionManager
implements OpStackListener,
RegionListener {
    private RegionOverlay overlay = new RegionOverlay();
    private OpControl control;
    private AffineTransform xform;
    private CurveTypeButtons buttons;
    private ToggleAction showHideAction;

    RegionManager() {
        this.overlay.addRegionListener(this);
        this.buttons = new CurveTypeButtons(this);
        this.showHideAction = this.overlay.getShowHideAction();
        this.eeRegister();
        this.overlay.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                boolean regionsVisible = RegionManager.this.showHideAction.getState();
                if (!regionsVisible) {
                    RegionManager.this.showHideAction.actionPerformed(new ActionEvent(RegionManager.this.overlay, 0, "Show Regions"));
                }
            }
        });
    }

    RegionOverlay getMode() {
        return this.overlay;
    }

    CurveTypeButtons getCurveTypeButtons() {
        return this.buttons;
    }

    public void addRegionListener(RegionListener listener) {
        this.overlay.addRegionListener(listener);
    }

    public void removeRegionListener(RegionListener listener) {
        this.overlay.removeRegionListener(listener);
    }

    public AbstractAction getShowHideAction() {
        return this.showHideAction;
    }

    @Override
    public void opAdded(OpControl control) {
        if (this.overlay.hasCookie(control)) {
            Region region = this.overlay.getRegion(control);
            control.getOperation().setRegion(region);
            control.setRegionIndicator(region != null);
        }
    }

    @Override
    public void opChanged(OpControl control) {
        if (control != null) {
            Operation op = control.getOperation();
            boolean isClone = op instanceof CloneOperation;
            boolean isSpot = op instanceof SpotOperation;
            boolean isRedEye = op instanceof RedEyeOperation;
            this.overlay.setCookie(control, isClone || isSpot, isSpot || isRedEye);
        } else {
            this.overlay.setCookie(null);
        }
        this.control = control;
    }

    @Override
    public void opChanged(SelectableControl control) {
        this.overlay.setCookie(null);
        this.control = null;
    }

    @Override
    public void opLockChanged(OpControl control) {
        if (this.control == control) {
            this.opChanged(control);
        }
    }

    @Override
    public void opRemoved(OpControl control) {
    }

    @Override
    public void regionBatchStart(Object cookie) {
        OpControl control = (OpControl)cookie;
        control.getOperation().changeBatchStarted();
    }

    @Override
    public void regionChanged(Object cookie, SharedShape shape) {
        OpControl control = (OpControl)cookie;
        Region region = this.overlay.getRegion(control);
        control.getOperation().setRegion(region);
        control.setRegionIndicator(region != null);
    }

    @Override
    public void regionBatchEnd(Object cookie) {
        OpControl control = (OpControl)cookie;
        control.getOperation().changeBatchEnded();
    }

    public void addSelectionListener(CurveSelection.Listener listener) {
        this.overlay.addSelectionListener(listener);
    }

    public void removeSelectionListener(CurveSelection.Listener listener) {
        this.overlay.removeSelectionListener(listener);
    }

    public void shareShape(SharedShape shape, boolean clone) {
        if (this.control != null) {
            this.overlay.shareShape(this.control, shape, clone);
        }
    }

    public void shareShapes(CurveIterator shapes, boolean clone) {
        if (this.control != null) {
            shapes.reset();
            while (shapes.hasNext()) {
                this.overlay.shareShape(this.control, shapes.nextCurve(), clone);
            }
        }
    }

    public void unShareShape(SharedShape shape) {
        if (this.control != null) {
            this.overlay.unShareShape(this.control, shape);
        }
    }

    public void unShareShapes(CurveIterator shapes) {
        if (this.control != null) {
            shapes.reset();
            while (shapes.hasNext()) {
                this.overlay.unShareShape(this.control, shapes.nextCurve());
            }
        }
    }

    void save(List cookies, XmlNode node) {
        this.overlay.save(cookies, node);
    }

    void restore(List cookies, XmlNode node) throws XMLException {
        this.overlay.restore(cookies, node);
    }

    void addSaved(List cookies, XmlNode node) throws XMLException {
        this.overlay.addSaved(cookies, node);
    }

    void setXForm(AffineTransform xform) {
        this.xform = xform;
    }

    private Dimension getInferredImageSize() {
        Dimension size = this.overlay.getUnderlayBounds().getSize();
        if (this.xform == null) {
            return size;
        }
        Point2D ul = new Point(0, 0);
        Point2D ll = new Point(0, size.height);
        Point2D ur = new Point(size.width, 0);
        try {
            ul = this.xform.inverseTransform(ul, null);
            ll = this.xform.inverseTransform(ll, null);
            ur = this.xform.inverseTransform(ur, null);
        }
        catch (NoninvertibleTransformException e) {
            return size;
        }
        double width = Math.sqrt((ur.getX() - ul.getX()) * (ur.getX() - ul.getX()) + (ur.getY() - ul.getY()) * (ur.getY() - ul.getY()));
        double height = Math.sqrt((ll.getX() - ul.getX()) * (ll.getX() - ul.getX()) + (ll.getY() - ul.getY()) * (ll.getY() - ul.getY()));
        return new Dimension((int)Math.round(width), (int)Math.round(height));
    }

    private void eeRegister() {
        ActionListener action = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (RegionManager.this.control != null) {
                    Dimension size = RegionManager.this.getInferredImageSize();
                    Graphics2D g = (Graphics2D)RegionManager.this.overlay.getGraphics();
                    Region ee = EeRegion.create(g, size);
                    RegionManager.this.control.getOperation().setRegion(ee);
                    RegionManager.this.control.setRegionIndicator(ee != null);
                }
            }
        };
        int mask = 3;
        KeyStroke key = KeyStroke.getKeyStroke(10, mask);
        this.overlay.registerKeyboardAction(action, key, 2);
    }

    public void addUndoableEditListener(UndoableEditListener listener) {
        this.overlay.addUndoableEditListener(listener);
    }

    public void removeUndoableEditListener(UndoableEditListener listener) {
        this.overlay.removeUndoableEditListener(listener);
    }

    public void setCurveType(int type) {
        this.overlay.setCurveType(type);
        this.buttons.updateFromFactory();
    }

    public int getCurveType() {
        return this.overlay.getCurveType();
    }
}

