/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.export;

import com.lightcrafts.image.export.ImageExportOptions;
import com.lightcrafts.image.types.ImageType;
import com.lightcrafts.image.types.JPEGImageType;
import com.lightcrafts.image.types.TIFFImageType;
import com.lightcrafts.platform.Platform;
import com.lightcrafts.ui.export.ExportControls;
import com.lightcrafts.ui.export.ExportCtrlToggle;
import com.lightcrafts.ui.export.ExportLogic;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class ExportMultiControls
extends JPanel
implements ItemListener {
    private ExportCtrlToggle toggle;
    private JComboBox combo;
    private ExportComboItem oldFilter;
    private boolean textResize;
    private Window window;

    public ExportMultiControls(ImageExportOptions options, Window window, boolean textResize) {
        ImageType filterType;
        ImageExportOptions filterOptions;
        this.window = window;
        this.textResize = textResize;
        ExportComboItem defaultItem = null;
        List<ExportComboItem> filters = ExportMultiControls.getAllFilters();
        ImageType defaultType = options.getImageType();
        this.combo = new JComboBox();
        this.combo.addItemListener(this);
        this.setLayout(new BorderLayout());
        for (ExportComboItem filter : filters) {
            filterOptions = filter.getExportOptions();
            filterType = filterOptions.getImageType();
            if (!defaultType.equals(filterType)) continue;
            defaultItem = filter = new ExportComboItem(options);
        }
        if (defaultItem != null) {
            this.combo.addItem(defaultItem);
        }
        for (ExportComboItem filter : filters) {
            filterOptions = filter.getExportOptions();
            filterType = filterOptions.getImageType();
            if (defaultType.equals(filterType)) continue;
            this.combo.addItem(filter);
        }
        if (defaultItem != null) {
            this.combo.setSelectedItem(defaultItem);
        }
        this.combo.setMaximumSize(this.combo.getPreferredSize());
    }

    public ImageExportOptions getSelectedExportOptions() {
        ExportComboItem filter = (ExportComboItem)this.combo.getSelectedItem();
        ImageExportOptions options = filter.getExportOptions();
        return options;
    }

    private static List<ExportComboItem> getAllFilters() {
        ArrayList<ExportComboItem> filters = new ArrayList<ExportComboItem>();
        ExportComboItem filter = new ExportComboItem(TIFFImageType.INSTANCE.newExportOptions());
        filters.add(filter);
        filter = new ExportComboItem(JPEGImageType.INSTANCE.newExportOptions());
        filters.add(filter);
        return filters;
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            ExportComboItem newFilter = (ExportComboItem)this.combo.getSelectedItem();
            ImageExportOptions newOptions = newFilter.getExportOptions();
            if (this.oldFilter != null) {
                ImageExportOptions oldOptions = this.oldFilter.getExportOptions();
                ExportLogic.mergeExportOptions(oldOptions, newOptions);
            }
            ExportControls ctrls = new ExportControls(newOptions, this.textResize);
            this.toggle = new ExportCtrlToggle(ctrls, this.window);
            this.removeAll();
            Box comboBox = Box.createHorizontalBox();
            comboBox.add(this.combo);
            comboBox.add(Box.createHorizontalGlue());
            this.add((Component)comboBox, "North");
            this.add(this.toggle);
            if (this.window != null) {
                this.window.pack();
            }
            this.repaint();
            this.oldFilter = newFilter;
        }
    }

    public static void main(String[] args) throws Exception {
        UIManager.setLookAndFeel(Platform.getPlatform().getLookAndFeel());
        TIFFImageType.ExportOptions options = TIFFImageType.INSTANCE.newExportOptions();
        File dir = new File(System.getProperty("user.home"));
        File file = new File(dir, "test.tif");
        options.setExportFile(file);
        JFrame frame = new JFrame();
        ExportMultiControls multi = new ExportMultiControls(options, frame, false);
        frame.setContentPane(multi);
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }

    static class ExportComboItem {
        private ImageExportOptions exportOptions;

        private ExportComboItem(ImageExportOptions exportOptions) {
            this.exportOptions = exportOptions;
        }

        public String toString() {
            return this.exportOptions.getImageType().getName();
        }

        private ImageExportOptions getExportOptions() {
            return this.exportOptions;
        }
    }
}

