/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.export;

import com.lightcrafts.image.types.ImageType;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExportNameUtility {
    private static final Pattern FileNamePattern = Pattern.compile("(?:_lzn-([0-9]*))?(?:\\.([^.]*))?$");
    private static final Pattern FileExtensionPattern = Pattern.compile("(?:\\.[^.]*)?$");

    public static File ensureNotExists(File file) {
        String path;
        if (!file.exists()) {
            return file;
        }
        String base = ExportNameUtility.getBaseName(file);
        int num = ExportNameUtility.getNumber(file);
        String ext = ExportNameUtility.getFileExtension(file);
        if (num < 0) {
            num = 1;
        }
        while ((file = new File(path = ExportNameUtility.constructPath(base, num++, ext))).exists()) {
        }
        return file;
    }

    public static String getBaseName(File file) {
        String path = file.getPath();
        Matcher matcher = FileNamePattern.matcher(path);
        if (matcher.find()) {
            return matcher.replaceFirst("");
        }
        return null;
    }

    public static String getFileExtension(File file) {
        String path = file.getPath();
        Matcher matcher = FileNamePattern.matcher(path);
        if (matcher.find()) {
            return matcher.group(2);
        }
        return null;
    }

    public static File setFileExtension(File file, String ext) {
        String path = file.getPath();
        String oldExt = ExportNameUtility.getFileExtension(file);
        if (oldExt != null) {
            if (ext.equals(oldExt)) {
                return file;
            }
            Matcher matcher = FileExtensionPattern.matcher(path);
            path = matcher.replaceFirst("." + ext);
        } else {
            path = path + "." + ext;
        }
        return new File(path);
    }

    public static File trimFileExtension(File file) {
        String path = file.getPath();
        String oldExt = ExportNameUtility.getFileExtension(file);
        if (oldExt != null) {
            Matcher matcher = FileExtensionPattern.matcher(path);
            path = matcher.replaceFirst("");
        }
        return new File(path);
    }

    public static String trimFileExtension(String name) {
        File file = new File(name);
        String oldExt = ExportNameUtility.getFileExtension(file);
        if (oldExt != null) {
            Matcher matcher = FileExtensionPattern.matcher(name);
            name = matcher.replaceFirst("");
        }
        return name;
    }

    public static File ensureCompatibleExtension(File file, ImageType type) {
        String ext = ExportNameUtility.getFileExtension(file);
        String[] typeExts = type.getExtensions();
        if (ext != null) {
            for (int n = 0; n < typeExts.length; ++n) {
                if (!ext.equalsIgnoreCase(typeExts[n])) continue;
                return file;
            }
        }
        return ExportNameUtility.setFileExtension(file, typeExts[0]);
    }

    private static String constructPath(String base, int num, String ext) {
        StringBuffer buffer = new StringBuffer();
        if (base != null) {
            buffer.append(base);
        }
        buffer.append("-");
        buffer.append(num);
        if (ext != null) {
            buffer.append(".");
            buffer.append(ext);
        }
        return buffer.toString();
    }

    private static int getNumber(File file) {
        String num;
        String path = file.getPath();
        Matcher matcher = FileNamePattern.matcher(path);
        if (matcher.find() && (num = matcher.group(1)) != null) {
            try {
                return Integer.parseInt(num);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }
}

