/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.layout;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.JSplitPane;

public class SmartSplitPane
extends JSplitPane {
    private static final Preferences Prefs = Preferences.userNodeForPackage(SmartSplitPane.class);
    private static final String LocationKey = "Location";
    private static final String HideLeftKey = "HideLeft";
    private static final String HideRightKey = "HideRight";
    private static final String HiddenLocKey = "HiddenLocation";
    private String prefsKey;
    private boolean hideLeft;
    private boolean hideRight;
    private int hiddenDividerLoc;
    private Component hidden;
    private String respectedSide;

    public SmartSplitPane(String prefsKey, String respectedSide) {
        this.prefsKey = prefsKey;
        this.respectedSide = respectedSide;
        this.setContinuousLayout(true);
        this.setBorder(null);
        this.setDividerSize(4);
        if (respectedSide != null) {
            this.addComponentListener();
        }
    }

    @Override
    public void setDividerLocation(int i) {
        super.setDividerLocation(i);
        Prefs.putInt(this.prefsKey + LocationKey, i);
    }

    public void setLeftFrozenDivider(JComponent comp) {
        int loc = this.getDividerLocation();
        this.setLeftComponent(comp);
        super.setDividerLocation(loc);
    }

    public void setRightFrozenDivider(JComponent comp) {
        int loc = this.getDividerLocation();
        this.setRightComponent(comp);
        super.setDividerLocation(loc);
    }

    public void restoreFromPrefs(int defaultDivider, int defaultOrientation) {
        int dividerLoc = Prefs.getInt(this.prefsKey + LocationKey, defaultDivider);
        if (dividerLoc >= 0) {
            super.setDividerLocation(dividerLoc);
        }
        super.setOrientation(defaultOrientation);
        this.hideLeft = Prefs.getBoolean(this.prefsKey + HideLeftKey, false);
        this.hideRight = Prefs.getBoolean(this.prefsKey + HideRightKey, false);
        this.hiddenDividerLoc = Prefs.getInt(this.prefsKey + HiddenLocKey, defaultDivider);
        if (this.hideLeft) {
            this.hidden = this.getLeftComponent();
            this.remove(this.hidden);
        }
        if (this.hideRight) {
            this.hidden = this.getRightComponent();
            this.remove(this.hidden);
        }
        if (this.hideLeft || this.hideRight) {
            this.setDividerSize(0);
        }
    }

    public void checkConstraints() {
        Component respected = this.getRespectedChild();
        if (respected == null) {
            return;
        }
        if (this.respectedSide == null) {
            return;
        }
        if (respected == null) {
            return;
        }
        Dimension size = respected.getSize();
        Dimension min = respected.getMinimumSize();
        Dimension max = respected.getMaximumSize();
        switch (this.getOrientation()) {
            case 0: {
                int minH = min.height;
                int maxH = max.height;
                if (size.height >= minH && size.height <= maxH) break;
                if (respected == this.getTopComponent()) {
                    this.setDividerLocation(minH + this.getDividerSize());
                } else {
                    this.setDividerLocation(this.getSize().height - minH - this.getDividerSize());
                }
                this.updateOppositeMinSize();
                break;
            }
            case 1: {
                int minW = min.width;
                int maxW = max.width;
                if (size.width >= minW && size.width <= maxW) break;
                if (respected == this.getLeftComponent()) {
                    this.setDividerLocation(minW + this.getDividerSize());
                } else {
                    this.setDividerLocation(this.getSize().width - minW - this.getDividerSize());
                }
                this.updateOppositeMinSize();
            }
        }
    }

    public boolean isHiddenLeft() {
        return this.hideLeft;
    }

    public boolean isHiddenRight() {
        return this.hideRight;
    }

    public void hideLeft() {
        if (this.hideLeft) {
            return;
        }
        if (this.hideRight) {
            this.unhide();
        }
        this.hiddenDividerLoc = this.getDividerLocation();
        this.hidden = this.getLeftComponent();
        this.remove(this.hidden);
        this.setDividerLocation(0.0);
        this.setDividerSize(0);
        this.hideLeft = true;
        this.hideRight = false;
        Prefs.putBoolean(this.prefsKey + HideLeftKey, this.hideLeft);
        Prefs.putBoolean(this.prefsKey + HideRightKey, this.hideRight);
        Prefs.putInt(this.prefsKey + HiddenLocKey, this.hiddenDividerLoc);
    }

    public void hideRight() {
        if (this.hideRight) {
            return;
        }
        if (this.hideLeft) {
            this.unhide();
        }
        this.hiddenDividerLoc = this.getDividerLocation();
        this.hidden = this.getRightComponent();
        this.remove(this.hidden);
        this.setDividerLocation(1.0);
        this.setDividerSize(0);
        this.hideLeft = false;
        this.hideRight = true;
        Prefs.putBoolean(this.prefsKey + HideLeftKey, this.hideLeft);
        Prefs.putBoolean(this.prefsKey + HideRightKey, this.hideRight);
        Prefs.putInt(this.prefsKey + HiddenLocKey, this.hiddenDividerLoc);
    }

    public void unhide() {
        if (this.hideLeft || this.hideRight) {
            if (this.hideRight) {
                this.setRightComponent(this.hidden);
            }
            if (this.hideLeft) {
                this.setLeftComponent(this.hidden);
            }
            this.setDividerLocation(this.hiddenDividerLoc);
            this.setDividerSize(4);
            this.hideLeft = false;
            this.hideRight = false;
            this.validate();
        }
        Prefs.putBoolean(this.prefsKey + HideLeftKey, this.hideLeft);
        Prefs.putBoolean(this.prefsKey + HideRightKey, this.hideRight);
        Prefs.putInt(this.prefsKey + HiddenLocKey, this.hiddenDividerLoc);
    }

    public void toggleOrientation() {
        int orientation = this.getOrientation();
        switch (orientation) {
            case 1: {
                this.setOrientation(0);
                break;
            }
            case 0: {
                this.setOrientation(1);
            }
        }
    }

    private void addComponentListener() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent event) {
                SmartSplitPane.this.updateOppositeMinSize();
            }
        });
    }

    public void updateOppositeMinSize() {
        if (this.isHiddenLeft() || this.isHiddenRight()) {
            return;
        }
        Component respected = this.getRespectedChild();
        Component opposite = this.getOppositeChild();
        Dimension size = this.getSize();
        Dimension min = opposite.getMinimumSize();
        Dimension max = respected.getMaximumSize();
        switch (this.getOrientation()) {
            case 1: {
                min.width = size.width - max.width;
                opposite.setMinimumSize(min);
                break;
            }
            case 0: {
                min.height = size.height - max.height;
                opposite.setMinimumSize(min);
            }
        }
    }

    private Component getRespectedChild() {
        if (this.respectedSide == null) {
            return null;
        }
        if (this.respectedSide.equals("top")) {
            return this.getTopComponent();
        }
        if (this.respectedSide.equals("bottom")) {
            return this.getBottomComponent();
        }
        if (this.respectedSide.equals("left")) {
            return this.getLeftComponent();
        }
        if (this.respectedSide.equals("right")) {
            return this.getRightComponent();
        }
        assert (false) : "Illegal SmartSplitPane respectedSide: " + this.respectedSide;
        return null;
    }

    private Component getOppositeChild() {
        if (this.respectedSide == null) {
            return null;
        }
        if (this.respectedSide.equals("top")) {
            return this.getBottomComponent();
        }
        if (this.respectedSide.equals("bottom")) {
            return this.getTopComponent();
        }
        if (this.respectedSide.equals("left")) {
            return this.getRightComponent();
        }
        if (this.respectedSide.equals("right")) {
            return this.getLeftComponent();
        }
        assert (false) : "Illegal SmartSplitPane respectedSide: " + this.respectedSide;
        return null;
    }
}

