/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.metadata;

import com.lightcrafts.image.metadata.ImageMetadataDirectory;
import com.lightcrafts.ui.metadata.DirectoryStack;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

class DirectoryLabel
extends Box {
    private static Icon CollapsedIcon;
    private static Icon ExpandedIcon;
    private static Icon CollapsedHighlightIcon;
    private static Icon ExpandedHighlightIcon;
    private DirectoryStack stack;
    private ImageMetadataDirectory dir;
    private JLabel label;
    private boolean isExpanded;

    DirectoryLabel(ImageMetadataDirectory dir, String name, DirectoryStack stack) {
        super(0);
        this.dir = dir;
        this.stack = stack;
        this.label = new JLabel(name);
        this.add(this.label);
        this.add(Box.createHorizontalGlue());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                if (DirectoryLabel.this.isExpanded) {
                    DirectoryLabel.this.doCollapse();
                } else {
                    DirectoryLabel.this.doExpand();
                }
            }

            @Override
            public void mouseEntered(MouseEvent event) {
                if (DirectoryLabel.this.isExpanded) {
                    DirectoryLabel.this.label.setIcon(ExpandedHighlightIcon);
                } else {
                    DirectoryLabel.this.label.setIcon(CollapsedHighlightIcon);
                }
            }

            @Override
            public void mouseExited(MouseEvent event) {
                if (DirectoryLabel.this.isExpanded) {
                    DirectoryLabel.this.label.setIcon(ExpandedIcon);
                } else {
                    DirectoryLabel.this.label.setIcon(CollapsedIcon);
                }
            }
        });
        this.setAlignmentX(1.0f);
        if (stack.isDirectoryExpanded(dir)) {
            this.doExpand();
        } else {
            this.doCollapse();
        }
    }

    void doExpand() {
        this.stack.showDirectory(this.dir);
        this.label.setIcon(ExpandedIcon);
        this.isExpanded = true;
        this.stack.expandDirectory(this.dir);
    }

    void doCollapse() {
        this.stack.hideDirectory(this.dir);
        this.label.setIcon(CollapsedIcon);
        this.isExpanded = false;
        this.stack.collapseDirectory(this.dir);
    }

    static {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        URL url = DirectoryLabel.class.getResource("resources/RightArrow.png");
        Image image = toolkit.createImage(url);
        CollapsedIcon = new ImageIcon(image);
        url = DirectoryLabel.class.getResource("resources/DownArrow.png");
        image = toolkit.createImage(url);
        ExpandedIcon = new ImageIcon(image);
        url = DirectoryLabel.class.getResource("resources/RightArrowHighlight.png");
        image = toolkit.createImage(url);
        CollapsedHighlightIcon = new ImageIcon(image);
        url = DirectoryLabel.class.getResource("resources/DownArrowHighlight.png");
        image = toolkit.createImage(url);
        ExpandedHighlightIcon = new ImageIcon(image);
    }
}

