/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.metadata;

import com.lightcrafts.image.metadata.ImageMetadataDirectory;
import com.lightcrafts.image.metadata.values.ImageMetaValue;
import com.lightcrafts.ui.metadata.KeyValuePair;
import com.lightcrafts.ui.metadata.MetaTagFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class MetadataDirectoryModel {
    private String name;
    private ArrayList<KeyValuePair> pairs;
    static Comparator<KeyValuePair> KeyValuePairComp = new Comparator<KeyValuePair>(){

        @Override
        public int compare(KeyValuePair pair1, KeyValuePair pair2) {
            String s1 = pair1.getKey();
            String s2 = pair2.getKey();
            return s1.compareTo(s2);
        }
    };

    MetadataDirectoryModel(ImageMetadataDirectory directory, boolean filter, boolean sort) {
        this.name = directory.getName();
        this.pairs = new ArrayList();
        Iterator<Map.Entry<Integer, ImageMetaValue>> i = directory.iterator();
        while (i.hasNext()) {
            Map.Entry<Integer, ImageMetaValue> entry = i.next();
            Integer id = entry.getKey();
            ImageMetaValue value = directory.getValue(id);
            if (!value.isDisplayable()) continue;
            String key = directory.getTagLabelFor(id);
            KeyValuePair pair = new KeyValuePair(id, key, value);
            this.pairs.add(pair);
        }
        if (filter) {
            this.pairs = MetaTagFilter.filter(directory, this.pairs);
        }
        if (sort) {
            Collections.sort(this.pairs, KeyValuePairComp);
        }
    }

    List<KeyValuePair> getPairs() {
        return new ArrayList<KeyValuePair>(this.pairs);
    }

    String getName() {
        return this.name;
    }
}

