/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.metadata;

import com.lightcrafts.image.metadata.ImageMetadataDirectory;
import com.lightcrafts.ui.metadata.KeyValuePair;
import com.lightcrafts.ui.metadata.MetadataDirectoryModel;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;

class MetadataTableModel
extends AbstractTableModel {
    private static final String[] ColumnNames = new String[]{"Key", "Value", "ID"};
    private static final int KeyColumn = 0;
    private static final int ValueColumn = 1;
    private static final int IdColumn = 2;
    private ArrayList<KeyValuePair> pairs;
    private boolean showIDs;

    MetadataTableModel(ImageMetadataDirectory dir, boolean filter, boolean sort, boolean showIDs) {
        this.showIDs = showIDs;
        this.pairs = new ArrayList();
        MetadataDirectoryModel dirModel = new MetadataDirectoryModel(dir, filter, sort);
        this.pairs.addAll(dirModel.getPairs());
    }

    @Override
    public String getColumnName(int col) {
        return ColumnNames[col];
    }

    @Override
    public int getRowCount() {
        return this.pairs.size();
    }

    @Override
    public int getColumnCount() {
        return this.showIDs ? ColumnNames.length : ColumnNames.length - 1;
    }

    @Override
    public Object getValueAt(int row, int col) {
        KeyValuePair pair = this.pairs.get(row);
        if (col == 0) {
            return pair.getKey();
        }
        if (col == 1) {
            return pair.getValue();
        }
        if (col == 2 && this.showIDs) {
            int id = pair.getTagID();
            return MetadataTableModel.hexStringOf(id);
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    private static String hexStringOf(int tagID) {
        String hex = Integer.toHexString(tagID).toUpperCase();
        int length = hex.length();
        if (length < 4) {
            hex = "000".substring(length - 1) + hex;
        }
        return hex;
    }
}

