/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.metadata2;

import com.lightcrafts.image.ImageInfo;
import com.lightcrafts.image.metadata.ImageMetadata;
import com.lightcrafts.image.metadata.ImageOrientation;
import com.lightcrafts.ui.editor.DocumentReader;
import com.lightcrafts.ui.metadata2.Locale;
import com.lightcrafts.ui.metadata2.MetadataEntry;
import java.io.File;

class EditSizeMetadataEntry
extends MetadataEntry {
    EditSizeMetadataEntry() {
    }

    @Override
    public String getLabel(ImageMetadata meta) {
        return Locale.LOCALE.get("EditSizeLabel");
    }

    @Override
    public String getValue(ImageMetadata meta) {
        ImageMetadata origMeta = EditSizeMetadataEntry.getOriginalImageMetadata(meta);
        if (origMeta != null) {
            return EditSizeMetadataEntry.getDimensionText(origMeta);
        }
        return EditSizeMetadataEntry.getDimensionText(meta);
    }

    @Override
    public boolean isEditable(ImageInfo info) {
        return false;
    }

    @Override
    public boolean isValidValue(ImageMetadata meta, String value) {
        return true;
    }

    @Override
    public void setValue(ImageMetadata meta, String value) {
    }

    private static String getDimensionText(ImageMetadata meta) {
        int width = meta.getImageWidth();
        int height = meta.getImageHeight();
        String value = "";
        if (width > 0 && height > 0) {
            ImageOrientation orient = meta.getOrientation();
            switch (orient) {
                case ORIENTATION_90CCW: 
                case ORIENTATION_90CCW_VFLIP: 
                case ORIENTATION_90CW: 
                case ORIENTATION_90CW_HFLIP: {
                    value = Locale.LOCALE.get("EditSizeValue", height, width);
                    break;
                }
                default: {
                    value = Locale.LOCALE.get("EditSizeValue", width, height);
                }
            }
        }
        return value;
    }

    private static ImageMetadata getOriginalImageMetadata(ImageMetadata meta) {
        try {
            File file = meta.getFile();
            DocumentReader.Interpretation interp = DocumentReader.read(file);
            if (interp != null && interp.imageFile != null) {
                file = interp.imageFile;
                ImageInfo info = ImageInfo.getInstanceFor(file);
                meta = info.getMetadata();
                return meta;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }
}

