/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.metadata2;

import com.lightcrafts.image.ImageInfo;
import com.lightcrafts.image.metadata.ImageMetadata;
import com.lightcrafts.image.types.ImageType;
import com.lightcrafts.ui.metadata2.MetadataEntry;
import com.lightcrafts.ui.metadata2.MetadataSection;
import javax.swing.table.AbstractTableModel;

class MetadataTableModel
extends AbstractTableModel {
    private static final String[] ColumnNames = new String[]{"Key", "Value"};
    private ImageInfo info;
    private ImageMetadata meta;
    private MetadataSection section;

    MetadataTableModel(ImageInfo info, ImageMetadata meta, MetadataSection section) {
        this.info = info;
        this.meta = meta;
        this.section = section;
    }

    @Override
    public String getColumnName(int col) {
        return ColumnNames[col];
    }

    @Override
    public int getRowCount() {
        return this.section.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Object getValueAt(int row, int col) {
        MetadataEntry entry = (MetadataEntry)this.section.get(row);
        if (col == 0) {
            return entry.getLabel(this.meta) + ':';
        }
        return entry.getValue(this.meta);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        MetadataEntry entry = (MetadataEntry)this.section.get(row);
        return col == 1 && entry.isEditable(this.info);
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col == 0) {
            return;
        }
        MetadataEntry entry = (MetadataEntry)this.section.get(row);
        entry.setValue(this.meta, (String)value);
        this.commit();
    }

    MetadataEntry getEntryAt(int row) {
        return (MetadataEntry)this.section.get(row);
    }

    void commit() {
        ImageType type = this.meta.getImageType();
        try {
            type.writeMetadata(this.info);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

