/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.metadata2;

import com.lightcrafts.image.ImageInfo;
import com.lightcrafts.image.metadata.ImageMetadata;
import com.lightcrafts.image.metadata.ImageMetadataDirectory;
import com.lightcrafts.image.metadata.values.ImageMetaValue;
import com.lightcrafts.ui.metadata2.MetadataEntry;

class SimpleMetadataEntry
extends MetadataEntry {
    Class<? extends ImageMetadataDirectory> clazz;
    int tagID;

    SimpleMetadataEntry(Class<? extends ImageMetadataDirectory> clazz, int tagID) {
        this.clazz = clazz;
        this.tagID = tagID;
    }

    Class<? extends ImageMetadataDirectory> getMetadataClass() {
        return this.clazz;
    }

    ImageMetadataDirectory getDirectory(ImageMetadata meta) {
        return meta.getDirectoryFor(this.clazz);
    }

    int getTagID() {
        return this.tagID;
    }

    @Override
    public String getLabel(ImageMetadata meta) {
        ImageMetadataDirectory dir = meta.getDirectoryFor(this.clazz);
        if (dir != null) {
            String label = dir.getTagLabelFor(this.tagID);
            return label;
        }
        try {
            return this.clazz.newInstance().getTagLabelFor(this.tagID);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return "(undefined)";
        }
    }

    @Override
    public Object getValue(ImageMetadata meta) {
        ImageMetaValue value;
        ImageMetadataDirectory dir = meta.getDirectoryFor(this.clazz);
        if (dir != null && (value = dir.getValue(this.tagID)) != null) {
            String text = value.toString();
            return text;
        }
        return "";
    }

    @Override
    public boolean isEditable(ImageInfo info) {
        return false;
    }

    @Override
    public boolean isValidValue(ImageMetadata meta, String value) {
        return true;
    }

    @Override
    public void setValue(ImageMetadata meta, String value) {
    }
}

