/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.mode;

import com.lightcrafts.ui.mode.AbstractMode;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;

public class RectangleMode
extends AbstractMode {
    private static Cursor Crosshair = new Cursor(1);
    private static Stroke BlackStroke;
    private static Stroke WhiteStroke;
    private Rectangle rectangle;
    private JComponent overlay = new RectangleOverlay();

    public RectangleMode() {
        this.overlay.setCursor(Crosshair);
        RectangleListener listener = new RectangleListener();
        this.overlay.addMouseListener(listener);
        this.overlay.addMouseMotionListener(listener);
    }

    public Rectangle getRectangle() {
        return this.rectangle;
    }

    @Override
    public JComponent getOverlay() {
        return this.overlay;
    }

    @Override
    public void addMouseInputListener(MouseInputListener listener) {
        this.overlay.addMouseListener(listener);
        this.overlay.addMouseMotionListener(listener);
    }

    @Override
    public void removeMouseInputListener(MouseInputListener listener) {
        this.overlay.removeMouseListener(listener);
        this.overlay.removeMouseMotionListener(listener);
    }

    @Override
    public boolean wantsAutocroll() {
        return true;
    }

    static {
        float[] dash = new float[]{5.0f, 5.0f};
        float width = 1.0f;
        BlackStroke = new BasicStroke(width, 2, 0, 1.0f, dash, 0.0f);
        WhiteStroke = new BasicStroke(width, 2, 0, 1.0f, dash, 5.0f);
    }

    private class RectangleListener
    extends MouseInputAdapter {
        private Point start;

        private RectangleListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.start = e.getPoint();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.start = null;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            Point end = e.getPoint();
            int x = this.start.x;
            int y = this.start.y;
            int w = end.x - this.start.x;
            int h = end.y - this.start.y;
            if (w < 0) {
                x += w;
                w = -w;
            }
            if (h < 0) {
                y += h;
                h = -h;
            }
            RectangleMode.this.rectangle = new Rectangle(x, y, w, h);
            RectangleMode.this.overlay.repaint();
        }
    }

    private class RectangleOverlay
    extends JComponent {
        private RectangleOverlay() {
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            if (RectangleMode.this.rectangle != null) {
                Graphics2D g = (Graphics2D)graphics;
                g.setStroke(WhiteStroke);
                g.setColor(Color.white);
                g.draw(RectangleMode.this.rectangle);
                g.setStroke(BlackStroke);
                g.setColor(Color.black);
                g.draw(RectangleMode.this.rectangle);
            }
        }
    }
}

