/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.operation.colorbalance;

import com.lightcrafts.model.ColorPickerDropperOperation;
import com.lightcrafts.model.Operation;
import com.lightcrafts.ui.editor.EditorMode;
import com.lightcrafts.ui.mode.DropperMode;
import com.lightcrafts.ui.operation.OpStack;
import com.lightcrafts.ui.operation.colorbalance.ColorPickerControl;
import com.lightcrafts.ui.operation.colorbalance.Locale;
import com.lightcrafts.ui.toolkit.DropperButton;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Point2D;
import java.util.Map;

public class ColorPickerDropperControl
extends ColorPickerControl {
    private DropperButton dropperButton;
    private DropperMode dropperMode;
    private boolean isDropperModeCancelling;

    public ColorPickerDropperControl(ColorPickerDropperOperation op, OpStack stack) {
        super(op, stack);
    }

    @Override
    protected void operationChanged(Operation operation) {
        super.operationChanged(operation);
        this.dropperButton = new DropperButton();
        this.dropperButton.setAlignmentX(1.0f);
        this.dropperButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                ColorPickerDropperControl.this.getComboFrame().getEditor().setMode(EditorMode.ARROW);
                if (event.getStateChange() == 1) {
                    ColorPickerDropperControl.this.notifyListenersEnterMode(ColorPickerDropperControl.this.dropperMode);
                } else if (!ColorPickerDropperControl.this.isDropperModeCancelling) {
                    ColorPickerDropperControl.this.notifyListenersExitMode(ColorPickerDropperControl.this.dropperMode);
                }
            }
        });
        this.dropperMode = new DropperMode(this);
        this.dropperMode.addListener(new DropperMode.Listener(){

            @Override
            public void pointSelected(Point2D p) {
                ColorPickerDropperControl.this.setColor(p);
            }

            @Override
            public void modeCancelled() {
                ColorPickerDropperControl.this.isDropperModeCancelling = true;
                ColorPickerDropperControl.this.dropperButton.setSelected(false);
                ColorPickerDropperControl.this.isDropperModeCancelling = false;
            }
        });
        this.colorContent.add(this.dropperButton);
    }

    private void setColor(Point2D p) {
        ColorPickerDropperOperation op = (ColorPickerDropperOperation)this.getOperation();
        Map<String, Double> map = op.setColor(p);
        this.updateColor(map);
        if (!this.undoSupport.isRestoring()) {
            this.undoSupport.postEdit(Locale.LOCALE.get("DropperEditName"));
        }
    }

    @Override
    protected String getHelpTopic() {
        return "Tool-Color_Balance";
    }
}

