/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.operation.colorbalance;

import com.lightcrafts.ui.layout.Box;
import com.lightcrafts.ui.operation.colorbalance.Locale;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

class ColorText
extends Box {
    private Box labels = Box.createVerticalBox();
    private Box values;
    public static final Font ControlFont = new Font("SansSerif", 0, 13);

    ColorText(Color color) {
        super(0);
        this.labels.add(ColorText.createLabel(Locale.LOCALE.get("RedLabel") + ':'));
        this.labels.add(ColorText.createLabel(Locale.LOCALE.get("GreenLabel") + ':'));
        this.labels.add(ColorText.createLabel(Locale.LOCALE.get("BlueLabel") + ':'));
        this.add(this.labels);
        this.add(Box.createHorizontalStrut(6));
        this.values = Box.createVerticalBox();
        this.add(this.values);
        this.setColor(Color.white);
        Dimension size = this.values.getPreferredSize();
        this.values.setMinimumSize(size);
        this.values.setPreferredSize(size);
        this.values.setMaximumSize(size);
        this.setColor(color);
    }

    void setColor(Color color) {
        this.values.removeAll();
        this.values.add(ColorText.createLabel(color.getRed()));
        this.values.add(ColorText.createLabel(color.getGreen()));
        this.values.add(ColorText.createLabel(color.getBlue()));
        this.validate();
        this.repaint();
    }

    private static JLabel createLabel(int number) {
        return ColorText.createLabel(Integer.toString(number));
    }

    private static JLabel createLabel(String text) {
        JLabel label = new JLabel(text);
        label.setFont(ControlFont);
        label.setAlignmentX(1.0f);
        return label;
    }

    public static void main(String[] args) {
        JPanel panel = new JPanel(new FlowLayout());
        panel.add(new ColorText(new Color(1, 2, 3)));
        JFrame frame = new JFrame();
        frame.setContentPane(panel);
        frame.pack();
        frame.setLocation(100, 100);
        frame.setVisible(true);
    }
}

