/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.operation.colorbalance;

import com.lightcrafts.ui.layout.Box;
import com.lightcrafts.ui.operation.colorbalance.ColorText;
import com.lightcrafts.ui.operation.colorbalance.ColorWheelMouseListener;
import com.lightcrafts.ui.swing.ColorSwatch;
import com.lightcrafts.ui.toolkit.DropperButton;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;

class ColorWheel
extends JComponent {
    private Color picked;
    private BufferedImage wheelImage = null;

    ColorWheel() {
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(100, 100);
    }

    Color getPickedColor() {
        return this.picked;
    }

    void pickColor(Color color) {
        this.picked = color;
        this.repaint();
    }

    private int getWheelSize() {
        Dimension size = this.getSize();
        return Math.min(size.width, size.height);
    }

    private Point2D getWheelCenter() {
        Dimension size = this.getSize();
        return new Point2D.Double(size.width / 2, size.height / 2);
    }

    private double getRadius(Point p) {
        Point2D center = this.getWheelCenter();
        int size = this.getWheelSize();
        double x = 2.0 * ((double)p.x + 0.5 - center.getX()) / (double)size;
        double y = 2.0 * ((double)p.y + 0.5 - center.getY()) / (double)size;
        return Math.sqrt(x * x + y * y);
    }

    private double getAngle(Point p) {
        Point2D center = this.getWheelCenter();
        double x = (double)p.x + 0.5 - center.getX();
        double y = (double)p.y + 0.5 - center.getY();
        return Math.atan2(y, -x);
    }

    Color pointToColor(Point p) {
        return this.pointToColor(p, true);
    }

    Color pointToColor(Point p, boolean linear) {
        double r = this.getRadius(p);
        double theta = this.getAngle(p);
        r = Math.min(r, 1.0);
        float hue = (1.0f + (float)(theta / Math.PI)) / 2.0f;
        float saturation = linear ? (float)r : (float)Math.min(1.1 * (r * r), 1.0);
        float brightness = 1.0f;
        Color color = new Color(Color.HSBtoRGB(hue, saturation, brightness));
        if (r <= 0.97 || !linear) {
            return color;
        }
        float alpha = (float)Math.max(0.0, 33.3 * (1.0 - r));
        float[] comps = color.getRGBComponents(null);
        return new Color(comps[0], comps[1], comps[2], alpha);
    }

    Point colorToPoint(Color c) {
        return this.colorToPoint(c, true);
    }

    Point colorToPoint(Color c, boolean linear) {
        float[] hsb = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
        float hue = hsb[0];
        float saturation = hsb[1];
        double r = linear ? (double)saturation : Math.sqrt(saturation);
        double theta = Math.PI * (double)(2.0f * hue - 1.0f);
        Point2D center = this.getWheelCenter();
        double radius = (double)this.getWheelSize() / (linear ? 2.0 : 2.1);
        int x = (int)Math.round(center.getX() - radius * r * Math.cos(theta));
        int y = (int)Math.round(center.getY() + radius * r * Math.sin(theta));
        return new Point(x, y);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics;
        Point2D center = this.getWheelCenter();
        double radius = this.getWheelSize() / 2;
        int minX = (int)Math.round(center.getX() - radius);
        int maxX = (int)Math.round(center.getX() + radius);
        int minY = (int)Math.round(center.getY() - radius);
        int maxY = (int)Math.round(center.getY() + radius);
        if (this.wheelImage == null) {
            this.wheelImage = new BufferedImage((int)(2.0 * radius), (int)(2.0 * radius), 2);
            Graphics2D gg = this.wheelImage.createGraphics();
            for (int x = minX; x <= maxX; ++x) {
                for (int y = minY; y <= maxY; ++y) {
                    Point p = new Point(x, y);
                    Color color = this.pointToColor(p);
                    gg.setColor(color);
                    gg.fillRect((int)((double)x - center.getX() + radius), (int)((double)y - center.getY() + radius), 1, 1);
                }
            }
            gg.dispose();
        }
        g.drawImage(this.wheelImage, null, (int)(center.getX() - radius), (int)(center.getY() - radius));
        if (this.picked != null) {
            Point p = this.colorToPoint(this.picked, false);
            g.setColor(Color.black);
            g.drawRect(p.x - 2, p.y - 2, 3, 3);
        }
    }

    public static void main(String[] args) {
        ColorWheel wheel = new ColorWheel();
        ColorWheelMouseListener listener = new ColorWheelMouseListener(wheel){

            @Override
            void colorPicked(Color color, boolean isChanging) {
                System.out.println(color);
            }
        };
        wheel.addMouseListener(listener);
        wheel.addMouseMotionListener(listener);
        Box colorContent = Box.createHorizontalBox();
        colorContent.add(wheel);
        colorContent.add(Box.createHorizontalStrut(8));
        colorContent.add(new ColorSwatch(Color.gray));
        colorContent.add(Box.createHorizontalStrut(8));
        colorContent.add(new ColorText(Color.gray));
        colorContent.add(Box.createHorizontalStrut(8));
        colorContent.add(new DropperButton());
        colorContent.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        JFrame frame = new JFrame("Test");
        frame.setContentPane(colorContent);
        frame.setDefaultCloseOperation(3);
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }
}

