/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.operation.drag;

import com.lightcrafts.ui.operation.drag.DragLayer;
import com.lightcrafts.ui.operation.drag.DraggableStackListener;
import com.lightcrafts.ui.operation.drag.StackDragListener;
import com.lightcrafts.ui.operation.drag.StackLayer;
import com.lightcrafts.ui.operation.drag.StackableComponent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.LinkedList;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;

public class DraggableStack
extends JLayeredPane {
    private static final Integer StackLayer = new Integer(0);
    private static final Integer DragLayer = new Integer(1);
    private StackLayer stack;
    private DragLayer drag;
    private StackDragListener dragListener;
    private LinkedList listeners;

    public DraggableStack() {
        this.setLayout(null);
        this.stack = new StackLayer(this);
        this.drag = new DragLayer();
        this.add((Component)this.stack, StackLayer);
        this.dragListener = new StackDragListener(this);
        this.listeners = new LinkedList();
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        assert (comp == this.stack || comp == this.drag);
        super.addImpl(comp, constraints, index);
    }

    public void push(JComponent comp) {
        int count = this.stack.getComponentCount();
        this.push(comp, count);
    }

    public void push(JComponent comp, int index) {
        if (comp instanceof StackableComponent) {
            this.addListeners((StackableComponent)((Object)comp));
        }
        this.stack.add((Component)comp, index);
    }

    public JComponent pop() {
        int count = this.stack.getComponentCount();
        return this.pop(count - 1);
    }

    public JComponent pop(JComponent comp) {
        int count = this.stack.getComponentCount();
        for (int i = 0; i < count; ++i) {
            Component c = this.stack.getComponent(i);
            if (comp != c) continue;
            return this.pop(i);
        }
        return null;
    }

    public JComponent pop(int index) {
        JComponent comp = (JComponent)this.stack.getComponent(index);
        if (comp instanceof StackableComponent) {
            this.removeListeners((StackableComponent)((Object)comp));
        }
        this.stack.remove(index);
        return comp;
    }

    public void addDraggableStackListener(DraggableStackListener listener) {
        this.listeners.add(listener);
    }

    public void removeDraggableStackListener(DraggableStackListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void doLayout() {
        Dimension size = this.getSize();
        this.drag.setLocation(0, 0);
        this.drag.setSize(size);
        this.stack.setLocation(0, 0);
        this.stack.setSize(size);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension stackSize = this.stack.getPreferredSize();
        Dimension dragSize = this.drag.getPreferredSize();
        int width = Math.max(stackSize.width, dragSize.width);
        int height = Math.max(stackSize.height, dragSize.height);
        return new Dimension(width, height);
    }

    void dragStart(JComponent comp, boolean isSwappable) {
        this.stack.setDragComponent(comp, isSwappable);
        this.add((Component)this.drag, DragLayer);
        this.drag.setDragComponent(comp);
        this.notifyStart();
    }

    void dragTo(Component comp, int y) {
        if (y >= 0) {
            this.drag.dragTo(y);
            this.stack.dragTo(y);
            this.revalidate();
        }
    }

    void swapOccurred(int index) {
        this.notifySwap(index);
    }

    void dragEnd(JComponent comp) {
        this.stack.setDragComponent(null, false);
        this.drag.setDragComponent(null);
        this.remove(this.drag);
        this.notifyEnd();
        this.revalidate();
    }

    private void addListeners(StackableComponent stackable) {
        JComponent comp = stackable.getDraggableComponent();
        this.addListenerRecurse(comp);
    }

    private void removeListeners(StackableComponent stackable) {
        JComponent comp = stackable.getDraggableComponent();
        this.removeListenerRecurse(comp);
    }

    private void addListenerRecurse(Component comp) {
        comp.addMouseListener(this.dragListener);
        comp.addMouseMotionListener(this.dragListener);
        if (comp instanceof Container) {
            Component[] children = ((Container)comp).getComponents();
            for (int n = 0; n < children.length; ++n) {
                if (children[n].isEnabled()) continue;
                this.addListenerRecurse(children[n]);
            }
        }
    }

    private void removeListenerRecurse(Component comp) {
        comp.removeMouseListener(this.dragListener);
        comp.removeMouseMotionListener(this.dragListener);
        if (comp instanceof Container) {
            Component[] children = ((Container)comp).getComponents();
            for (int n = 0; n < children.length; ++n) {
                this.removeListenerRecurse(children[n]);
            }
        }
    }

    private void notifyStart() {
        for (DraggableStackListener listener : this.listeners) {
            listener.dragStarted();
        }
    }

    private void notifySwap(int index) {
        for (DraggableStackListener listener : this.listeners) {
            listener.swapped(index);
        }
    }

    private void notifyEnd() {
        for (DraggableStackListener listener : this.listeners) {
            listener.dragStopped();
        }
    }
}

