/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.operation.drag;

import com.lightcrafts.ui.operation.drag.DraggableStack;
import com.lightcrafts.ui.operation.drag.StackableComponent;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

class StackDragListener
extends MouseInputAdapter {
    private static final int DragThreshold = 5;
    private DraggableStack stack;
    private Point startCursor;
    private Point startComponent;
    private boolean dragging;

    StackDragListener(DraggableStack stack) {
        this.stack = stack;
    }

    @Override
    public void mousePressed(MouseEvent event) {
        JComponent comp = this.getAncestorJComponent(event);
        this.startCursor = event.getPoint();
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        Point p;
        JComponent comp = this.getAncestorJComponent(event);
        if (this.startCursor != null && !this.dragging && this.startCursor.distance(p = event.getPoint()) > 5.0) {
            this.startComponent = comp.getLocation();
            boolean isSwappable = ((StackableComponent)((Object)comp)).isSwappable();
            this.stack.dragStart(comp, isSwappable);
            this.dragging = true;
        }
        if (this.dragging) {
            Point p1 = this.startCursor;
            Point p2 = event.getPoint();
            Point interval = new Point(p2.x - p1.x, p2.y - p1.y);
            this.stack.dragTo(comp, this.startComponent.y + interval.y);
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        if (this.dragging) {
            this.tearDown(event);
            this.dragging = false;
        }
        this.startCursor = null;
    }

    private JComponent getAncestorJComponent(MouseEvent event) {
        JComponent comp = (JComponent)event.getComponent();
        comp = (JComponent)SwingUtilities.getAncestorOfClass(StackableComponent.class, comp);
        event.translatePoint(comp.getX(), comp.getY());
        return comp;
    }

    private void tearDown(MouseEvent event) {
        JComponent comp = this.getAncestorJComponent(event);
        this.stack.dragEnd(comp);
    }
}

