/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.operation.generic;

import com.lightcrafts.model.SliderConfig;
import javax.swing.DefaultBoundedRangeModel;

class ConfiguredBoundedRangeModel
extends DefaultBoundedRangeModel {
    private SliderConfig config;
    private double preciseValue;
    private double A;
    private double B;
    private double m;
    private double b;
    private boolean isUpdating;

    ConfiguredBoundedRangeModel(SliderConfig config) {
        this.config = config;
        this.precompute();
        double confValue = config.getDefaultValue();
        this.setConfiguredValue(confValue);
    }

    @Override
    public void setMaximum(int max) {
        super.setMaximum(max);
        this.precompute();
    }

    @Override
    public void setMinimum(int min) {
        super.setMinimum(min);
        this.precompute();
    }

    @Override
    public void setValue(int value) {
        if (!this.isUpdating) {
            this.preciseValue = this.config.isLogScale() ? this.A * Math.exp(this.B * (double)value) : this.m * (double)value + this.b;
        }
        super.setValue(value);
    }

    public double getConfiguredValue() {
        return this.preciseValue;
    }

    public void setConfiguredValue(double confValue) {
        double oldPreciseValue = this.preciseValue;
        this.preciseValue = confValue;
        int sliderValue = this.config.isLogScale() ? (int)Math.round(Math.log(confValue / this.A) / this.B) : (int)Math.round((confValue - this.b) / this.m);
        this.isUpdating = true;
        int oldValue = this.getValue();
        if (sliderValue != oldValue) {
            this.setValue(sliderValue);
        } else if (this.preciseValue != oldPreciseValue) {
            this.fireStateChanged();
        }
        this.isUpdating = false;
    }

    public double getConfiguredMinimum() {
        return this.config.getMinValue();
    }

    public double getConfiguredMaximum() {
        return this.config.getMaxValue();
    }

    public double getConfiguredIncrement() {
        return this.config.getIncrement();
    }

    private void precompute() {
        int sliderMax = this.getMaximum();
        int sliderMin = this.getMinimum();
        double confMax = this.config.getMaxValue();
        double confMin = this.config.getMinValue();
        if (this.config.isLogScale()) {
            this.B = Math.log(confMax / confMin) / (double)(sliderMax - sliderMin);
            this.A = confMax / Math.exp(this.B * (double)sliderMax);
        } else {
            this.m = (confMax - confMin) / (double)(sliderMax - sliderMin);
            this.b = confMax - this.m * (double)sliderMax;
        }
    }
}

