/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.operation.zone;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;

class ComponentScaler {
    ComponentScaler() {
    }

    static double componentToScale(Component comp) {
        int top = comp.getLocation().y;
        int bottom = top + comp.getSize().height;
        Container parent = comp.getParent();
        int height = parent.getSize().height;
        return (double)(height - (bottom + top) / 2) / (double)height;
    }

    static void scaleToComponent(Component comp, double scale) {
        Container parent = comp.getParent();
        int height = parent.getSize().height;
        Point p = comp.getLocation();
        Dimension size = comp.getSize();
        int y = (int)Math.round((1.0 - scale) * (double)height - (double)(size.height / 2));
        comp.setLocation(p.x, y);
    }

    static double componentToScale(Component comp, int inset) {
        int top = comp.getLocation().y;
        int bottom = top + comp.getSize().height;
        Container parent = comp.getParent();
        int height = parent.getSize().height;
        return (double)(height - (bottom + top) / 2 - inset) / (double)(height - 2 * inset);
    }

    static void scaleToComponent(Component comp, int inset, double scale) {
        Container parent = comp.getParent();
        int height = parent.getSize().height;
        Point p = comp.getLocation();
        Dimension size = comp.getSize();
        int y = (int)Math.round((1.0 - scale) * (double)(height - 2 * inset) + (double)inset - (double)(size.height / 2));
        comp.setLocation(p.x, y);
    }
}

