/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.operation.zone;

import com.lightcrafts.ui.operation.zone.Spacer;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.Timer;

class KnobPainter
implements ActionListener {
    private static final boolean KnobPainterOn = true;
    private static BufferedImage KnobImage;
    private static final int Delay = 25;
    private Spacer spacer;
    private boolean isOn;
    private float alpha;
    private Timer timer;

    KnobPainter(Spacer spacer) {
        URL url = Spacer.class.getResource("resources/spacerknob.png");
        try {
            KnobImage = ImageIO.read(url);
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't initialize Spacer.Knob");
        }
        this.spacer = spacer;
        this.timer = new Timer(25, this);
    }

    void knobOn(boolean immediate) {
        this.isOn = true;
        if (!this.timer.isRunning() && !immediate) {
            this.timer.restart();
        } else if (immediate) {
            this.alpha = 1.0f;
            this.spacer.repaint();
        }
    }

    void knobOff(boolean immediate) {
        this.isOn = false;
        if (!this.timer.isRunning() && !immediate) {
            this.timer.restart();
        } else if (immediate) {
            this.alpha = 0.0f;
            this.spacer.repaint();
        }
    }

    void paint(Graphics2D g) {
        if (this.alpha == 0.0f) {
            return;
        }
        Dimension size = this.spacer.getSize();
        int centerX = (size.width - this.spacer.getOutcrop()) / 2;
        int centerY = size.height / 2;
        int knobW = KnobImage.getWidth();
        int knobH = KnobImage.getHeight();
        AffineTransform xform = AffineTransform.getTranslateInstance(centerX - knobW / 2, centerY - knobH / 2);
        Composite oldComposite = g.getComposite();
        AlphaComposite blend = AlphaComposite.getInstance(10, this.alpha);
        g.setComposite(blend);
        g.drawRenderedImage(KnobImage, xform);
        g.setComposite(oldComposite);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (this.isOn) {
            this.alpha = (float)((double)this.alpha + 0.1);
            if (this.alpha >= 1.0f) {
                this.alpha = 1.0f;
                this.timer.stop();
            }
        } else {
            this.alpha = (float)((double)this.alpha - 0.1);
            if (this.alpha <= 0.0f) {
                this.alpha = 0.0f;
                this.timer.stop();
            }
        }
        this.spacer.repaint();
    }
}

