/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.operation.zone;

import com.lightcrafts.ui.operation.zone.ComponentScaler;
import com.lightcrafts.ui.operation.zone.KnobPainter;
import com.lightcrafts.ui.operation.zone.ZoneModel;
import com.lightcrafts.ui.operation.zone.ZoneModelEvent;
import com.lightcrafts.ui.operation.zone.ZoneModelListener;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

class Spacer
extends JPanel
implements ZoneModelListener,
FocusListener,
MouseListener {
    static final int SpacerHeight = 18;
    static final int SpacerOutcrop = 22;
    private static final Cursor SliderCursor = Cursor.getPredefinedCursor(8);
    private static final Cursor ClickCursor = Cursor.getPredefinedCursor(0);
    private ZoneModel model;
    private int index;
    private JButton unstickButton;
    private SpacerHandle knobHandle;
    private KnobPainter knobPainter;
    private static Map<String, Icon> IconCache = new WeakHashMap<String, Icon>();

    Spacer(ZoneModel model, int index, SpacerHandle knobHandle) {
        this.model = model;
        this.index = index;
        this.knobHandle = knobHandle;
        this.knobPainter = new KnobPainter(this);
        this.setOpaque(false);
        this.setCursor(SliderCursor);
        this.initKeyMaps();
        Icon icon = Spacer.getIcon("unstick");
        Icon pressedIcon = Spacer.getIcon("unstickPressed");
        Icon highlightIcon = Spacer.getIcon("unstickHighlight");
        this.unstickButton = new JButton(icon);
        this.unstickButton.setSize(icon.getIconWidth(), icon.getIconHeight());
        this.unstickButton.setPressedIcon(pressedIcon);
        this.unstickButton.setRolloverEnabled(true);
        this.unstickButton.setRolloverIcon(highlightIcon);
        this.unstickButton.setBorder(null);
        this.unstickButton.putClientProperty("substancelaf.buttonpaintnever", Boolean.TRUE);
        this.unstickButton.setBorderPainted(false);
        this.unstickButton.setRolloverEnabled(true);
        this.unstickButton.setOpaque(false);
        this.unstickButton.setCursor(ClickCursor);
        this.unstickButton.setFocusable(false);
        this.unstickButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Spacer.this.model.removePoint(Spacer.this.index);
            }
        });
        if (model.containsPoint(index)) {
            this.add(this.unstickButton);
        }
        model.addZoneModelListener(this);
        this.setFocusable(true);
        this.addFocusListener(this);
        this.addMouseListener(this);
    }

    int getIndex() {
        return this.index;
    }

    int getOutcrop() {
        if (this.isStuck()) {
            return 22;
        }
        return 0;
    }

    @Override
    public void doLayout() {
        if (this.isStuck()) {
            Dimension size = this.getSize();
            Dimension unStickSize = this.unstickButton.getPreferredSize();
            int x = size.width - unStickSize.width;
            int y = size.height / 2 - unStickSize.height / 2;
            this.unstickButton.setSize(unStickSize);
            this.unstickButton.setLocation(x, y);
        }
    }

    @Override
    public void zoneModelBatchStart(ZoneModelEvent event) {
    }

    @Override
    public void zoneModelChanged(ZoneModelEvent event) {
        if (!this.isStuck() && this.model.containsPoint(this.index)) {
            this.add(this.unstickButton);
            this.revalidate();
            this.repaint();
        } else if (this.isStuck() && !this.model.containsPoint(this.index)) {
            this.remove(this.unstickButton);
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    public void zoneModelBatchEnd(ZoneModelEvent event) {
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.setFocusedKnob();
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.requestFocusInWindow();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.knobHandle.spacer != null) {
            this.knobHandle.spacer.knobPainter.knobOff(false);
        }
        this.knobHandle.spacer = this;
        this.knobPainter.knobOn(false);
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D g = (Graphics2D)graphics;
        if (!this.isEnabled()) {
            return;
        }
        Color oldColor = g.getColor();
        RenderingHints oldHints = g.getRenderingHints();
        g.setColor(Color.black);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.isStuck()) {
            this.paintHorizontalLine(g);
        }
        g.setRenderingHints(oldHints);
        g.setColor(oldColor);
        this.knobPainter.paint(g);
    }

    void moveTo(int newY) {
        Point p = this.getLocation();
        this.setLocation(p.x, newY);
        try {
            this.updateModel();
        }
        catch (IllegalArgumentException e) {
            this.setLocation(p);
        }
    }

    void updateModel() {
        double value = ComponentScaler.componentToScale(this, 9);
        this.model.setPoint(this.index, value);
    }

    void setFocusedKnob() {
        if (this.knobHandle.spacer != null) {
            this.knobHandle.spacer.knobPainter.knobOff(true);
        }
        this.knobHandle.spacer = this;
        this.knobPainter.knobOn(true);
    }

    private boolean isStuck() {
        return this.unstickButton.getParent() != null;
    }

    private void paintHorizontalLine(Graphics g) {
        Dimension size = this.getSize();
        int y = size.height / 2;
        g.drawLine(0, y, size.width, y);
    }

    private void initKeyMaps() {
        this.registerKeyboardAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Point p = Spacer.this.getLocation();
                Spacer.this.moveTo(p.y + 1);
            }
        }, KeyStroke.getKeyStroke(40, 0), 0);
        this.registerKeyboardAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Point p = Spacer.this.getLocation();
                Spacer.this.moveTo(p.y - 1);
            }
        }, KeyStroke.getKeyStroke(38, 0), 0);
        this.registerKeyboardAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Point p = Spacer.this.getLocation();
                Spacer.this.moveTo(p.y);
            }
        }, KeyStroke.getKeyStroke(88, 0), 0);
        this.registerKeyboardAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Spacer.this.model.removePoint(Spacer.this.index);
            }
        }, KeyStroke.getKeyStroke(127, 0), 0);
        this.registerKeyboardAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Spacer.this.model.removePoint(Spacer.this.index);
            }
        }, KeyStroke.getKeyStroke(8, 0), 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Icon getIcon(String name) {
        String path = "resources/" + name + ".png";
        Map<String, Icon> map = IconCache;
        synchronized (map) {
            URL url;
            Icon theIcon = IconCache.get(path);
            if (theIcon == null && (url = Spacer.class.getResource(path)) != null) {
                theIcon = new ImageIcon(url);
                IconCache.put(path, theIcon);
            }
            return theIcon;
        }
    }

    static class SpacerHandle {
        Spacer spacer;

        SpacerHandle() {
        }
    }
}

