/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.operation.zone;

import com.lightcrafts.model.ZoneOperation;
import com.lightcrafts.ui.operation.zone.Spacer;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

class SpacerMouseListener
extends MouseAdapter {
    private ZoneOperation op;
    private Spacer[] spacers;
    private Spacer focused;
    private boolean inSpacer;
    private boolean mousePressed;

    SpacerMouseListener(ZoneOperation op, Spacer[] spacers) {
        this.op = op;
        this.spacers = spacers;
        for (Spacer spacer : spacers) {
            spacer.addMouseListener(this);
        }
    }

    @Override
    public void mouseEntered(MouseEvent event) {
        this.inSpacer = true;
        Spacer spacer = (Spacer)event.getComponent();
        if (spacer != this.focused && !this.mousePressed) {
            this.focused = spacer;
            int index = this.getIndexOf(this.focused);
            this.op.setFocusPoint(index);
        }
    }

    @Override
    public void mouseExited(MouseEvent event) {
        this.inSpacer = false;
        this.setNoFocus();
    }

    @Override
    public void mousePressed(MouseEvent event) {
        this.mousePressed = true;
        this.setNoFocus();
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        this.mousePressed = false;
        if (this.inSpacer) {
            Spacer spacer = (Spacer)event.getComponent();
            this.setFocus(spacer);
        }
    }

    private void setFocus(Spacer spacer) {
        if (this.focused != spacer) {
            this.focused = spacer;
            int index = this.getIndexOf(this.focused);
            this.op.setFocusPoint(index);
        }
    }

    private void setNoFocus() {
        if (this.focused != null) {
            this.focused = null;
            this.op.setFocusPoint(-1);
        }
    }

    private int getIndexOf(Spacer spacer) {
        for (int n = 0; n < this.spacers.length; ++n) {
            if (this.spacers[n] != spacer) continue;
            return n;
        }
        return -1;
    }
}

