/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.operation.zone;

import com.lightcrafts.jai.JAIContext;
import com.lightcrafts.jai.utils.Functions;
import java.awt.Color;
import java.util.ResourceBundle;

class Zone {
    private static final ResourceBundle Resources = ResourceBundle.getBundle("com/lightcrafts/ui/operation/zone/resources/Zone");
    static final int MinimumZone = Integer.parseInt(Resources.getString("minimumZone"));
    static final int MaximumZone = Integer.parseInt(Resources.getString("maximumZone"));
    static final int ZoneCount = Integer.parseInt(Resources.getString("zoneCount"));
    static final Zone[] zones = new Zone[MaximumZone - MinimumZone + 1];
    private Color color;

    private Zone(int level) {
        float intensity = (float)(Math.pow(2.0, 8.0 * (double)(level - MinimumZone) / (double)(MaximumZone - MinimumZone)) - 1.0) / 255.0f;
        float[] srgbColor = Functions.fromLinearToCS(JAIContext.systemColorSpace, new float[]{intensity, intensity, intensity});
        this.color = new Color(srgbColor[0], srgbColor[1], srgbColor[2]);
    }

    Color getColor() {
        return this.color;
    }

    static Zone[] getZones() {
        return zones;
    }

    static {
        assert (ZoneCount >= 2);
        assert (0 <= MinimumZone);
        assert (MinimumZone < MaximumZone);
        assert (MaximumZone < ZoneCount);
        for (int n = MinimumZone; n <= MaximumZone; ++n) {
            Zone.zones[n - Zone.MinimumZone] = new Zone(n);
        }
    }
}

