/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.operation.zone;

import com.lightcrafts.model.ZoneOperation;
import com.lightcrafts.ui.operation.OpControl;
import com.lightcrafts.ui.operation.zone.ComponentScaler;
import com.lightcrafts.ui.operation.zone.DragListener;
import com.lightcrafts.ui.operation.zone.GradientFill;
import com.lightcrafts.ui.operation.zone.Locale;
import com.lightcrafts.ui.operation.zone.Spacer;
import com.lightcrafts.ui.operation.zone.SpacerMouseListener;
import com.lightcrafts.ui.operation.zone.SpacerTraversalPolicy;
import com.lightcrafts.ui.operation.zone.Zone;
import com.lightcrafts.ui.operation.zone.ZoneModel;
import com.lightcrafts.ui.operation.zone.ZoneModelEvent;
import com.lightcrafts.ui.operation.zone.ZoneModelListener;
import com.lightcrafts.utils.xml.XMLException;
import com.lightcrafts.utils.xml.XmlNode;
import java.awt.Component;
import javax.swing.JPanel;

class ZoneWidget
extends JPanel
implements ZoneModelListener {
    private ZoneModel model;
    private DragListener dragListener;
    private GradientFill[] fills;
    private Spacer[] spacers;
    private OpControl.OpControlUndoSupport undoSupport;
    private boolean batchEdit;

    ZoneWidget(ZoneOperation op, OpControl.OpControlUndoSupport undoSupport) {
        this.undoSupport = undoSupport;
        Zone[] zones = Zone.getZones();
        this.model = new ZoneModel(op, zones.length);
        this.model.addZoneModelListener(this);
        this.dragListener = new DragListener();
        this.dragListener.setModel(this.model);
        this.setLayout(null);
        this.fills = new GradientFill[zones.length];
        this.spacers = new Spacer[zones.length + 1];
        Spacer.SpacerHandle knobHandle = new Spacer.SpacerHandle();
        for (int n = 0; n < zones.length; ++n) {
            Spacer spacer;
            GradientFill fill;
            Zone zone = zones[n];
            this.fills[n] = fill = new GradientFill(zone);
            if (n == 0) {
                this.spacers[0] = spacer = new Spacer(this.model, 0, knobHandle);
                this.add((Component)spacer, 0);
                this.dragListener.addSelfTo(spacer);
            }
            this.add((Component)fill, -1);
            this.spacers[n + 1] = spacer = new Spacer(this.model, n + 1, knobHandle);
            this.add((Component)spacer, n + 1);
            this.dragListener.addSelfTo(spacer);
        }
        this.spacers[zones.length / 2].setFocusedKnob();
        this.setFocusCycleRoot(true);
        SpacerTraversalPolicy focus = new SpacerTraversalPolicy();
        this.setFocusTraversalPolicy(focus);
        new SpacerMouseListener(op, this.spacers);
    }

    void operationChanged(ZoneOperation op) {
        this.batchEdit = true;
        this.model.operationChanged(op);
        this.batchEdit = false;
    }

    void makeReference() {
        this.setEnabled(false);
        int count = (this.getComponentCount() + 1) / 2;
        for (int n = 0; n < count; ++n) {
            Spacer spacer = this.getSpacer(n);
            spacer.setEnabled(false);
            this.dragListener.removeSelfFrom(spacer);
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    public void zoneModelBatchStart(ZoneModelEvent event) {
        this.batchEdit = true;
    }

    @Override
    public void zoneModelChanged(ZoneModelEvent event) {
        this.doLayout();
        this.repaint();
        if (!this.batchEdit) {
            this.undoSupport.postEdit(Locale.LOCALE.get("ZoneEditName"));
        }
    }

    @Override
    public void zoneModelBatchEnd(ZoneModelEvent event) {
        this.undoSupport.postEdit(Locale.LOCALE.get("ZoneEditName"));
        this.batchEdit = false;
    }

    @Override
    public void doLayout() {
        this.updateSpacerLayout();
        this.updateGradientFillLayout();
    }

    void save(XmlNode node) {
        this.model.save(node);
    }

    void restore(XmlNode node) throws XMLException {
        this.batchEdit = true;
        this.model.restore(node);
        this.batchEdit = false;
    }

    private void updateSpacerLayout() {
        int width = this.getSize().width - 22;
        for (int n = 0; n < this.spacers.length; ++n) {
            Spacer spacer = this.getSpacer(n);
            int outcrop = spacer.getOutcrop();
            spacer.setSize(width + outcrop, 18);
            int index = spacer.getIndex();
            double y = this.isEnabled() ? this.model.getValueAt(index) : (double)index / ((double)this.spacers.length - 1.0);
            ComponentScaler.scaleToComponent(spacer, 9, y);
        }
    }

    private void updateGradientFillLayout() {
        int width = this.getSize().width;
        for (int n = 0; n < this.fills.length; ++n) {
            GradientFill c = this.getGradientFill(n);
            int yMin = this.getGradientFillTop(n);
            int yMax = this.getGradientFillBottom(n);
            c.setLocation(0, yMin);
            if (this.isEnabled()) {
                c.setSize(width - 22, yMax - yMin);
                continue;
            }
            c.setSize(width, yMax - yMin);
        }
    }

    private Spacer getSpacer(int index) {
        return this.spacers[index];
    }

    private int getSpacerMiddle(int index) {
        Spacer spacer = this.getSpacer(index);
        return spacer.getLocation().y + spacer.getSize().height / 2;
    }

    private GradientFill getGradientFill(int index) {
        return this.fills[index];
    }

    private int getGradientFillBottom(int index) {
        return this.getSpacerMiddle(index) + 1;
    }

    private int getGradientFillTop(int index) {
        return this.getSpacerMiddle(index + 1);
    }
}

