/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.print;

import com.lightcrafts.mediax.jai.BorderExtender;
import com.lightcrafts.mediax.jai.Interpolation;
import com.lightcrafts.mediax.jai.JAI;
import com.lightcrafts.mediax.jai.RenderedOp;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.print.PageFormat;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.border.Border;

class PreviewComponent
extends JComponent {
    private static final Dimension PreferredSize = new Dimension(400, 200);
    private BufferedImage image;
    private PageFormat format;
    private Rectangle2D rect;

    PreviewComponent(BufferedImage image, PageFormat format) {
        this.image = image;
        this.format = format;
        this.setOpaque(false);
        Border empty = BorderFactory.createEmptyBorder(3, 3, 3, 3);
        this.setBorder(empty);
        this.setPreferredSize(PreferredSize);
    }

    void setPageFormat(PageFormat format) {
        this.format = format;
        this.repaint();
    }

    void setImageRect(Rectangle2D rect) {
        this.rect = (Rectangle2D)rect.clone();
        this.repaint();
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int w, int h) {
        boolean result = super.imageUpdate(img, infoflags, x, y, w, h);
        if (img.equals(this.image) && (infoflags & 3) != 0) {
            this.revalidate();
            this.repaint();
        }
        return result;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics;
        double paperW = this.format.getWidth();
        double paperH = this.format.getHeight();
        double imageX = this.rect.getX();
        double imageY = this.rect.getY();
        double imageW = this.rect.getWidth();
        double imageH = this.rect.getHeight();
        Point paperUL = this.paperToScreen(0.0, 0.0);
        Point paperLR = this.paperToScreen(paperW, paperH);
        Rectangle paperBounds = new Rectangle(paperUL.x, paperUL.y, paperLR.x - paperUL.x, paperLR.y - paperUL.y);
        Color oldColor = g.getColor();
        g.setColor(Color.white);
        g.fill(paperBounds);
        Point imageableUL = this.paperToScreen(this.format.getImageableX(), this.format.getImageableY());
        Point imageableLR = this.paperToScreen(this.format.getImageableX() + this.format.getImageableWidth(), this.format.getImageableY() + this.format.getImageableHeight());
        Rectangle imageableArea = new Rectangle(imageableUL.x, imageableUL.y, imageableLR.x - imageableUL.x, imageableLR.y - imageableUL.y);
        g.setColor(Color.lightGray);
        g.draw(imageableArea);
        g.setColor(oldColor);
        Shape oldClip = g.getClip();
        g.setClip(imageableArea);
        Point imageUL = this.paperToScreen(imageX, imageY);
        Point imageLR = this.paperToScreen(imageX + imageW, imageY + imageH);
        Rectangle imageArea = new Rectangle(imageUL.x, imageUL.y, imageLR.x - imageUL.x, imageLR.y - imageUL.y);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        Rectangle imageBounds = this.getImageBounds(imageArea);
        double scale = Math.min((double)imageBounds.width / (double)this.image.getWidth(), (double)imageBounds.height / (double)this.image.getHeight());
        if (scale > 0.0) {
            AffineTransform transform = AffineTransform.getScaleInstance(scale, scale);
            transform.preConcatenate(AffineTransform.getTranslateInstance(imageBounds.x, imageBounds.y));
            RenderingHints formatHints = new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)1));
            Interpolation interp = Interpolation.getInstance((int)1);
            ParameterBlock params = new ParameterBlock();
            params.addSource(this.image);
            params.add(transform);
            params.add(interp);
            RenderedOp scaled = JAI.create((String)"Affine", (ParameterBlock)params, (RenderingHints)formatHints);
            g.drawRenderedImage((RenderedImage)scaled, new AffineTransform());
            scaled.dispose();
        }
        g.setClip(oldClip);
    }

    private Point paperToScreen(double paperX, double paperY) {
        double pixelsPerPt;
        Dimension size = this.getSize();
        Insets insets = this.getInsets();
        double renderW = size.width - insets.left - insets.right;
        double renderH = size.height - insets.top - insets.bottom;
        double paperW = this.format.getWidth();
        double paperH = this.format.getHeight();
        double paperAspect = paperW / paperH;
        double renderAspect = renderW / renderH;
        double renderX = 0.0;
        double renderY = 0.0;
        if (paperAspect > renderAspect) {
            pixelsPerPt = renderW / paperW;
            renderY = renderH / 2.0 - pixelsPerPt * paperH / 2.0;
        } else {
            pixelsPerPt = renderH / paperH;
            renderX = renderW / 2.0 - pixelsPerPt * paperW / 2.0;
        }
        double screenX = renderX + pixelsPerPt * paperX;
        double screenY = renderY + pixelsPerPt * paperY;
        return new Point((int)Math.round(screenX), (int)Math.round(screenY));
    }

    private Rectangle getImageBounds(Rectangle area) {
        double aspect = (double)this.image.getWidth(null) / (double)this.image.getHeight(null);
        return (Rectangle)PreviewComponent.getImageBounds(area, aspect);
    }

    static Rectangle2D getImageBounds(Rectangle2D area, double aspect) {
        double areaW = area.getWidth();
        double areaH = area.getHeight();
        Rectangle2D bounds = (Rectangle2D)area.clone();
        if (areaW / areaH > aspect) {
            double imageH = areaH;
            double imageW = aspect * imageH;
            double centerX = area.getX() + area.getWidth() / 2.0;
            bounds.setRect(centerX - imageW / 2.0, bounds.getY(), imageW, bounds.getHeight());
        } else {
            double imageW = areaW;
            double imageH = (int)Math.round(imageW / aspect);
            double centerY = area.getY() + area.getHeight() / 2.0;
            bounds.setRect(bounds.getX(), centerY - imageH / 2.0, bounds.getWidth(), imageH);
        }
        return bounds;
    }

    public static void main(String[] args) {
        BufferedImage image = null;
        try {
            image = ImageIO.read(new File(args[0]));
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        PageFormat format = new PageFormat();
        JFrame frame = new JFrame("PreviewComponent Test");
        frame.setContentPane(new PreviewComponent(image, format));
        frame.setDefaultCloseOperation(3);
        frame.setBounds(100, 100, 400, 400);
        frame.setVisible(true);
    }
}

