/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.print;

import com.lightcrafts.ui.LightZoneSkin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

class ScaleTextField
extends JTextField
implements DocumentListener {
    private static final FocusListener FocusSelector = new FocusAdapter(){

        @Override
        public void focusGained(FocusEvent event) {
            ScaleTextField text = (ScaleTextField)event.getSource();
            text.selectAll();
        }
    };
    private static final NumberFormat PercentFormat = NumberFormat.getPercentInstance();
    private static final NumberFormat IntegerFormat = NumberFormat.getIntegerInstance();
    private Listener listener;

    ScaleTextField() {
        this.setInputVerifier(new NumberVerifier());
        Document doc = this.getDocument();
        doc.addDocumentListener(this);
        this.setFixedSize();
        this.setHorizontalAlignment(4);
        this.addFocusListener(FocusSelector);
        this.registerKeyboardActions();
    }

    void setListener(Listener listener) {
        this.listener = listener;
    }

    void setScale(double scale) {
        String text = PercentFormat.format(scale);
        this.setText(text);
    }

    double getScale() {
        InputVerifier verifier = this.getInputVerifier();
        boolean verified = verifier.verify(this);
        if (!verified) {
            throw new IllegalStateException("Invalid scale text");
        }
        String text = this.getText();
        double scale = 1.0;
        try {
            Number number = PercentFormat.parse(text);
            scale = number.doubleValue();
        }
        catch (ParseException e) {
            try {
                Number number = IntegerFormat.parse(text);
                scale = number.doubleValue() / 100.0;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return scale;
    }

    private void setFixedSize() {
        this.setText("1000%");
        Dimension size = this.getPreferredSize();
        this.setMinimumSize(size);
        this.setPreferredSize(size);
        this.setMaximumSize(size);
    }

    private void registerKeyboardActions() {
        ActionListener upAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                InputVerifier verifier = ScaleTextField.this.getInputVerifier();
                if (!verifier.verify(ScaleTextField.this)) {
                    return;
                }
                double scale = ScaleTextField.this.getScale();
                if (ScaleTextField.verify(scale += 0.01)) {
                    ScaleTextField.this.setScale(scale);
                }
            }
        };
        ActionListener downAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                InputVerifier verifier = ScaleTextField.this.getInputVerifier();
                if (!verifier.verify(ScaleTextField.this)) {
                    return;
                }
                double scale = ScaleTextField.this.getScale();
                if (ScaleTextField.verify(scale -= 0.01)) {
                    ScaleTextField.this.setScale(scale);
                } else if (scale < 0.0) {
                    ScaleTextField.this.setScale(0.0);
                }
            }
        };
        this.registerKeyboardAction(upAction, "Increment", KeyStroke.getKeyStroke(38, 0), 0);
        this.registerKeyboardAction(downAction, "Decrement", KeyStroke.getKeyStroke(40, 0), 0);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.handleDocumentChange();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.handleDocumentChange();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.handleDocumentChange();
    }

    private void handleDocumentChange() {
        InputVerifier verifier = this.getInputVerifier();
        boolean verified = verifier.verify(this);
        if (!verified) {
            this.setForeground(Color.red);
        } else {
            this.setForeground(LightZoneSkin.Colors.ToolPanesForeground);
            if (this.listener != null) {
                double x = this.getScale();
                this.listener.scaleChanged(x);
            }
        }
    }

    private static boolean verify(double x) {
        return x >= 0.0;
    }

    private class NumberVerifier
    extends InputVerifier {
        private NumberVerifier() {
        }

        @Override
        public boolean verify(JComponent input) {
            double x;
            String text = ScaleTextField.this.getText();
            try {
                Number number = PercentFormat.parse(text);
                x = number.doubleValue();
            }
            catch (ParseException e) {
                try {
                    Number number = IntegerFormat.parse(text);
                    x = number.doubleValue() / 100.0;
                }
                catch (ParseException f) {
                    return false;
                }
            }
            return ScaleTextField.verify(x);
        }
    }

    static interface Listener {
        public void scaleChanged(double var1);
    }
}

