/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.region;

import com.lightcrafts.ui.region.Curve;
import com.lightcrafts.ui.region.EditCurveMode;
import com.lightcrafts.ui.region.MinorRegionMode;
import com.lightcrafts.ui.region.RegionMode;
import java.awt.Point;
import java.awt.event.MouseEvent;

class ClonePointMode
extends MinorRegionMode {
    private Point startPoint;
    private Point currentPoint;
    private Curve curve;

    ClonePointMode(RegionMode oldMode, Curve curve, Point initPoint) {
        super(oldMode);
        this.curve = curve;
        this.currentPoint = this.startPoint = initPoint;
        this.comp.setCursor(MovingPointCursor);
        this.model.notifyChangeStart(curve);
        this.model.editStart();
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        Point p = event.getPoint();
        this.update(p, false);
        this.model.setMajorMode(new EditCurveMode(this, this.curve));
        if (!this.currentPoint.equals(this.startPoint)) {
            this.model.editEnd();
        } else {
            this.model.editCancel();
        }
        this.model.notifyChangeEnd(this.curve);
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        Point p = event.getPoint();
        this.update(p, true);
        this.autoscroll(event);
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        Point p = event.getPoint();
        this.update(p, true);
        this.autoscroll(event);
    }

    private void update(Point p, boolean isUpdating) {
        this.comp.setClonePoint(this.curve, this.currentPoint, p, isUpdating);
        this.currentPoint = p;
    }
}

