/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.region;

import com.lightcrafts.ui.region.Curve;
import com.lightcrafts.ui.region.curves.AbstractCurve;
import com.lightcrafts.ui.region.curves.CubicBasisSpline;
import com.lightcrafts.ui.region.curves.CubicBezierCurve;
import com.lightcrafts.ui.region.curves.CubicRationalSpline;
import com.lightcrafts.ui.region.curves.EllipticCurve;
import com.lightcrafts.ui.region.curves.PolygonCurve;
import com.lightcrafts.ui.region.curves.QuadraticBasisSpline;
import com.lightcrafts.ui.region.curves.QuadraticRationalSpline;
import com.lightcrafts.utils.xml.XMLException;
import com.lightcrafts.utils.xml.XmlNode;
import java.awt.geom.Point2D;
import java.util.prefs.Preferences;

public class CurveFactory {
    public static final int Polygon = 0;
    public static final int QuadraticBezier = 1;
    public static final int CubicBezier = 2;
    public static final int QuadraticBasis = 3;
    public static final int CubicBasis = 4;
    public static final int QuadraticRational = 5;
    public static final int CubicRational = 6;
    public static final int Elliptic = 7;
    private static final String CurveTypeTag = "CurveType";
    private static final Preferences Prefs = Preferences.userRoot().node("/com/lightcrafts/ui/region");
    private int type = Prefs.getInt("CurveType", 2);
    private static final String TypeTag = "Type";

    void setCurveType(int type) {
        this.type = type;
        Prefs.putInt(CurveTypeTag, type);
    }

    int getCurveType() {
        return this.type;
    }

    Curve createCurve() {
        switch (this.type) {
            case 0: {
                return new PolygonCurve();
            }
            case 1: {
                return null;
            }
            case 2: {
                return new CubicBezierCurve();
            }
            case 3: {
                return new QuadraticBasisSpline();
            }
            case 4: {
                return new CubicBasisSpline();
            }
            case 5: {
                return new QuadraticRationalSpline();
            }
            case 6: {
                return new CubicRationalSpline();
            }
        }
        return null;
    }

    Curve createSpotCurve(Point2D center) {
        return new EllipticCurve(center);
    }

    private static String getTag(int type) {
        switch (type) {
            case 0: {
                return "Polygon";
            }
            case 1: {
                return null;
            }
            case 2: {
                return "CubicBezier";
            }
            case 3: {
                return "QuadraticBasis";
            }
            case 4: {
                return "CubicBasis";
            }
            case 5: {
                return "QuadraticRational";
            }
            case 7: {
                return "Elliptic";
            }
        }
        return null;
    }

    private static String getTag(Curve curve) {
        if (curve instanceof PolygonCurve) {
            return CurveFactory.getTag(0);
        }
        if (curve instanceof CubicBezierCurve) {
            return CurveFactory.getTag(2);
        }
        if (curve instanceof QuadraticBasisSpline) {
            return CurveFactory.getTag(3);
        }
        if (curve instanceof CubicBasisSpline) {
            return CurveFactory.getTag(4);
        }
        if (curve instanceof QuadraticRationalSpline) {
            return CurveFactory.getTag(5);
        }
        if (curve instanceof EllipticCurve) {
            return CurveFactory.getTag(7);
        }
        return null;
    }

    static void save(Curve curve, XmlNode node) {
        String tag = CurveFactory.getTag(curve);
        node.setAttribute(TypeTag, tag);
        curve.save(node);
    }

    static Curve restore(XmlNode node) throws XMLException {
        String tag = node.getAttribute(TypeTag);
        AbstractCurve curve = null;
        if (tag.equals(CurveFactory.getTag(0))) {
            curve = new PolygonCurve();
        }
        if (tag.equals(CurveFactory.getTag(2))) {
            curve = new CubicBezierCurve();
        }
        if (tag.equals(CurveFactory.getTag(3))) {
            curve = new QuadraticBasisSpline();
        }
        if (tag.equals(CurveFactory.getTag(4))) {
            curve = new CubicBasisSpline();
        }
        if (tag.equals(CurveFactory.getTag(5))) {
            curve = new QuadraticRationalSpline();
        }
        if (tag.equals(CurveFactory.getTag(7))) {
            curve = new EllipticCurve();
        }
        if (curve == null) {
            throw new XMLException("Unknown curve type: " + tag);
        }
        curve.restore(node);
        return curve;
    }
}

