/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.region;

import com.lightcrafts.ui.region.Curve;
import com.lightcrafts.ui.region.CurveIterator;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class CurveSelection {
    private Object cookie;
    private Map<Object, Collection<Curve>> selections = new HashMap<Object, Collection<Curve>>();
    private List<Listener> listeners = new LinkedList<Listener>();

    void setSelectedCurve(Curve curve) {
        if (this.cookie != null) {
            Collection<Curve> oldSelection = this.selections.get(this.cookie);
            if (this.isSelected(curve) && oldSelection.size() == 1) {
                return;
            }
            oldSelection = new LinkedList<Curve>(oldSelection);
            Collection<Curve> newSelection = this.selections.get(this.cookie);
            newSelection.clear();
            newSelection.add(curve);
            this.notifyListeners(oldSelection);
        }
    }

    void addCurve(Curve newCurve) {
        if (this.isSelected(newCurve)) {
            return;
        }
        Collection<Curve> curves = this.selections.get(this.cookie);
        LinkedList<Curve> oldSelection = new LinkedList<Curve>(curves);
        curves.add(newCurve);
        this.notifyListeners(oldSelection);
    }

    void removeCurve(Curve oldCurve) {
        if (!this.isSelected(oldCurve)) {
            return;
        }
        Collection<Curve> curves = this.selections.get(this.cookie);
        LinkedList<Curve> oldSelection = new LinkedList<Curve>(curves);
        curves.remove(oldCurve);
        this.notifyListeners(oldSelection);
    }

    void clear() {
        Collection<Curve> curves = this.selections.get(this.cookie);
        LinkedList<Curve> oldSelection = new LinkedList<Curve>(curves);
        curves.clear();
        this.notifyListeners(oldSelection);
    }

    CurveIterator iterator() {
        if (this.cookie != null) {
            Collection<Curve> curves = this.selections.get(this.cookie);
            return new CurveIterator(curves);
        }
        return new CurveIterator(Collections.EMPTY_SET);
    }

    boolean isSelected(Curve curve) {
        Collection<Curve> curves = this.selections.get(this.cookie);
        return curves.contains(curve);
    }

    void setCookie(Object cookie) {
        if (this.cookie != cookie) {
            Collection<Curve> oldSelection = this.selections.get(this.cookie);
            if (oldSelection == null) {
                oldSelection = Collections.emptySet();
            }
            this.cookie = cookie;
            this.selections.put(cookie, new LinkedList());
            this.notifyListeners(oldSelection);
        }
    }

    void addSelectionListener(Listener listener) {
        this.listeners.add(listener);
    }

    void removeSelectionListener(Listener listener) {
        this.listeners.remove(listener);
    }

    void notifyListeners(Collection<Curve> oldSelection) {
        for (Listener listener : this.listeners) {
            CurveIterator oldIter = new CurveIterator(oldSelection);
            CurveIterator newIter = this.iterator();
            listener.selectionChanged(oldIter, newIter);
        }
    }

    public static interface Listener {
        public void selectionChanged(CurveIterator var1, CurveIterator var2);
    }
}

