/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.region;

import com.lightcrafts.ui.region.ClonePointMode;
import com.lightcrafts.ui.region.Curve;
import com.lightcrafts.ui.region.CurveFactory;
import com.lightcrafts.ui.region.CurveIterator;
import com.lightcrafts.ui.region.CurveSelection;
import com.lightcrafts.ui.region.FollowMouseOnceMode;
import com.lightcrafts.ui.region.InnerCurveMode;
import com.lightcrafts.ui.region.MajorRegionMode;
import com.lightcrafts.ui.region.MoveEditingCurveMode;
import com.lightcrafts.ui.region.NewCurveMode;
import com.lightcrafts.ui.region.RegionMode;
import com.lightcrafts.utils.xml.XMLException;
import com.lightcrafts.utils.xml.XmlNode;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;

class EditCurveMode
extends MajorRegionMode {
    private static KeyStroke DeleteKey1 = KeyStroke.getKeyStroke(127, 0);
    private static KeyStroke DeleteKey2 = KeyStroke.getKeyStroke(8, 0);
    private static KeyStroke ExitKey1 = KeyStroke.getKeyStroke(27, 0);
    private static KeyStroke ExitKey2 = KeyStroke.getKeyStroke(10, 0);
    private Curve curve;

    EditCurveMode(RegionMode oldMode, Curve curve) {
        super(oldMode);
        this.curve = curve;
    }

    @Override
    void modeEntered() {
        AbstractAction deleteAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                EditCurveMode.this.model.editStart();
                CurveSelection selection = EditCurveMode.this.model.getSelection();
                CurveIterator curves = selection.iterator();
                while (curves.hasNext()) {
                    EditCurveMode.this.model.removeCurve(EditCurveMode.this.comp, curves.nextCurve());
                }
                EditCurveMode.this.model.setMajorMode(new NewCurveMode(EditCurveMode.this));
                EditCurveMode.this.model.editEnd();
            }
        };
        this.comp.registerKeyboardAction(deleteAction, DeleteKey1, 2);
        this.comp.registerKeyboardAction(deleteAction, DeleteKey2, 2);
        AbstractAction exitAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                EditCurveMode.this.finish();
            }
        };
        this.comp.registerKeyboardAction(exitAction, ExitKey1, 2);
        this.comp.registerKeyboardAction(exitAction, ExitKey2, 2);
    }

    @Override
    void modeExited() {
        this.comp.unregisterKeyboardAction(DeleteKey1);
        this.comp.unregisterKeyboardAction(DeleteKey1);
        this.comp.unregisterKeyboardAction(ExitKey1);
        this.comp.unregisterKeyboardAction(ExitKey2);
    }

    @Override
    void save(XmlNode node) {
        CurveFactory.save(this.curve, node);
    }

    @Override
    void restore(XmlNode node) throws XMLException {
        this.curve = CurveFactory.restore(node);
        this.curve = this.model.getRestoredCurve(this.curve);
    }

    @Override
    Curve getEditingCurve() {
        return this.curve;
    }

    @Override
    public void mousePressed(MouseEvent event) {
        if (event.isPopupTrigger() || event.getButton() != 1) {
            return;
        }
        Point p = event.getPoint();
        Curve c = this.comp.getCurveAt(p);
        if (this.comp.isClonePointAt(this.curve, p)) {
            this.model.setMinorMode(new ClonePointMode(this, this.curve, p));
        } else if (c == this.curve) {
            int index = this.comp.getPointAt(this.curve, p);
            if (index < 0) {
                if (this.comp.isInnerShapeAt(this.curve, p)) {
                    this.model.setMinorMode(new InnerCurveMode(this, this.curve));
                    return;
                }
                if (this.curve.allowsAddRemovePoints()) {
                    index = this.comp.getSegmentAt(this.curve, p) + 1;
                    this.comp.insertPoint(this.curve, index, p);
                } else {
                    return;
                }
            }
            this.model.setMinorMode(new FollowMouseOnceMode(this, this.curve, index));
        } else {
            c = this.comp.getCurveAround(p);
            if (c == this.curve) {
                if (this.comp.isInnerShapeAt(this.curve, p)) {
                    this.model.setMinorMode(new InnerCurveMode(this, this.curve));
                } else {
                    this.model.setMinorMode(new MoveEditingCurveMode(this, this.curve));
                }
            } else {
                this.finish();
            }
        }
    }

    private void finish() {
        this.model.editStart();
        this.model.setMajorMode(new NewCurveMode(this));
        this.model.editEnd();
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        this.updateCursor(event);
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        this.updateCursor(event);
    }

    private void updateCursor(MouseEvent event) {
        int index;
        Point p = event.getPoint();
        Cursor newCursor = this.comp.isClonePointAt(this.curve, p) ? MovePointCursor : (this.comp.isInnerShapeAt(this.curve, p) ? MovePointCursor : (this.comp.getCurveAt(p) == this.curve ? ((index = this.comp.getPointAt(this.curve, p)) >= 0 ? MovePointCursor : (this.curve.allowsAddRemovePoints() ? NewPointCursor : DefaultCursor)) : (this.comp.getCurveAround(p) == this.curve ? MoveCurveCursor : DefaultCursor)));
        if (newCursor != this.cursor) {
            this.comp.setCursor(newCursor);
            this.cursor = newCursor;
        }
    }
}

