/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.region;

import com.lightcrafts.ui.region.Curve;
import com.lightcrafts.ui.region.CurveFactory;
import com.lightcrafts.ui.region.EditCurveMode;
import com.lightcrafts.ui.region.MajorRegionMode;
import com.lightcrafts.ui.region.NewCurveMode;
import com.lightcrafts.ui.region.RegionMode;
import com.lightcrafts.utils.xml.XMLException;
import com.lightcrafts.utils.xml.XmlNode;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;

class FollowMouseMode
extends MajorRegionMode {
    private Curve curve;
    private int index;
    private MouseEvent recentClick;
    private static final int MaxDoubleClickDistance = 20;
    private static final int MaxDoubleClickTime = 500;
    private static final int NewPointDistance = 5;
    private static KeyStroke ExitKey1 = KeyStroke.getKeyStroke(10, 0);
    private static KeyStroke ExitKey2 = KeyStroke.getKeyStroke(27, 0);
    private Point lastMousePress;

    FollowMouseMode(RegionMode oldMode, Curve curve, int index) {
        super(oldMode);
        this.curve = curve;
        this.index = index;
    }

    @Override
    void modeEntered() {
        this.comp.setCursor(NewPointCursor);
        AbstractAction exitAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                FollowMouseMode.this.finish();
            }
        };
        this.comp.registerKeyboardAction(exitAction, ExitKey1, 2);
        this.comp.registerKeyboardAction(exitAction, ExitKey2, 2);
        this.model.editStart();
        this.model.notifyChangeStart(this.curve);
    }

    @Override
    void modeExited() {
        this.comp.unregisterKeyboardAction(ExitKey1);
        this.comp.unregisterKeyboardAction(ExitKey2);
        this.model.notifyChangeEnd(this.curve);
        this.model.editEnd();
    }

    @Override
    void save(XmlNode node) {
        CurveFactory.save(this.curve, node);
        node.setAttribute("index", Integer.toString(this.index));
    }

    @Override
    void restore(XmlNode node) throws XMLException {
        this.curve = CurveFactory.restore(node);
        this.curve = this.model.getRestoredCurve(this.curve);
        this.index = Integer.parseInt(node.getAttribute("index"));
        this.lastMousePress = null;
    }

    @Override
    Curve getEditingCurve() {
        return this.curve;
    }

    @Override
    public void mousePressed(MouseEvent event) {
        if (FollowMouseMode.isModified(event)) {
            this.finish();
        } else if (event.getClickCount() == 1) {
            this.lastMousePress = event.getPoint();
        }
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        if (this.isSloppyDoubleClick(event)) {
            this.finish();
        }
    }

    private boolean isSloppyDoubleClick(MouseEvent click) {
        if (click.getClickCount() == 0) {
            return false;
        }
        if (click.getClickCount() == 2) {
            return true;
        }
        if (this.recentClick == null) {
            this.recentClick = click;
            return false;
        }
        long t1 = click.getWhen();
        long t2 = this.recentClick.getWhen();
        Point p1 = click.getPoint();
        Point p2 = this.recentClick.getPoint();
        this.recentClick = click;
        double dt = Math.abs(t1 - t2);
        double dx = p1.distance(p2);
        return dt < 500.0 && dx < 20.0;
    }

    private void finish() {
        MajorRegionMode nextMode;
        if (this.curve.isValidShape()) {
            nextMode = new EditCurveMode(this, this.curve);
        } else {
            nextMode = new NewCurveMode(this);
            this.model.editCancel();
            this.model.editStart();
            this.comp.removeCurveWithoutModeChange(this.curve);
        }
        this.model.setMajorModeWithoutExitOrEnter(nextMode);
        this.modeExited();
        nextMode.modeEntered();
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        Point p = event.getPoint();
        this.maybeAddPoint(p);
        this.update(p);
        this.autoscroll(event);
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        Point p = event.getPoint();
        this.maybeAddPoint(p);
        this.update(p);
        this.autoscroll(event);
    }

    @Override
    public void mouseExited(MouseEvent event) {
        Point p = event.getPoint();
        this.update(p);
    }

    private void maybeAddPoint(Point p) {
        if (this.lastMousePress != null && this.lastMousePress.distance(p) >= 5.0) {
            this.index = this.comp.addPoint(this.curve, p);
            this.lastMousePress = null;
            this.model.editEnd();
            this.model.editStart();
        }
    }

    private void update(Point p) {
        float width;
        if (this.lastMousePress == null) {
            this.comp.movePoint(this.curve, this.index, p);
        }
        if (this.curve.isValidShape() && (width = this.curve.getWidth()) < 30.0f) {
            this.comp.setInnerShapeAt(this.curve, null);
        }
    }
}

