/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.region;

import com.lightcrafts.ui.region.Curve;
import com.lightcrafts.ui.region.EditCurveMode;
import com.lightcrafts.ui.region.MinorRegionMode;
import com.lightcrafts.ui.region.RegionMode;
import java.awt.Point;
import java.awt.event.MouseEvent;

class FollowMouseOnceMode
extends MinorRegionMode {
    private Curve curve;
    private int index;

    FollowMouseOnceMode(RegionMode oldMode, Curve curve, int index) {
        super(oldMode);
        this.curve = curve;
        this.index = index;
        this.comp.setCursor(MovePointCursor);
        this.model.notifyChangeStart(curve);
        this.model.editStart();
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        Point p = event.getPoint();
        this.update(p, false);
        this.model.setMajorMode(new EditCurveMode(this, this.curve));
        this.model.editEnd();
        this.model.notifyChangeEnd(this.curve);
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        Point p = event.getPoint();
        this.update(p, true);
        this.autoscroll(event);
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        Point p = event.getPoint();
        this.update(p, true);
        this.autoscroll(event);
    }

    @Override
    public void mouseExited(MouseEvent event) {
        Point p = event.getPoint();
        this.update(p, false);
    }

    private void update(Point p, boolean isUpdating) {
        this.comp.movePoint(this.curve, this.index, p, isUpdating);
    }
}

