/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.region;

import com.lightcrafts.ui.region.Curve;
import com.lightcrafts.ui.region.EditCurveMode;
import com.lightcrafts.ui.region.MinorRegionMode;
import com.lightcrafts.ui.region.RegionMode;
import java.awt.Point;
import java.awt.event.MouseEvent;

class InnerCurveMode
extends MinorRegionMode {
    private Curve curve;
    private float startWidth;

    InnerCurveMode(RegionMode oldMode, Curve curve) {
        super(oldMode);
        this.curve = curve;
        this.startWidth = curve.getWidth();
        this.comp.setCursor(MovingCurveCursor);
        this.model.notifyChangeStart(curve);
        this.model.editStart();
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        this.model.setMajorMode(new EditCurveMode(this, this.curve));
        if (this.curve.getWidth() != this.startWidth) {
            this.model.editEnd();
        } else {
            this.model.editCancel();
        }
        Point p = event.getPoint();
        this.update(p, false);
        this.model.notifyChangeEnd(this.curve);
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        Point p = event.getPoint();
        this.update(p, true);
        this.autoscroll(event);
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        Point p = event.getPoint();
        this.update(p, true);
        this.autoscroll(event);
    }

    private void update(Point p, boolean isUpdating) {
        this.comp.setInnerShapeAt(this.curve, p, isUpdating);
    }
}

