/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.region;

import com.lightcrafts.model.Contour;
import com.lightcrafts.ui.region.Curve;
import com.lightcrafts.ui.region.CurveComponent;
import com.lightcrafts.ui.region.CurveContour;
import com.lightcrafts.ui.region.CurveFactory;
import com.lightcrafts.ui.region.CurveSelection;
import com.lightcrafts.ui.region.Locale;
import com.lightcrafts.ui.region.MajorRegionMode;
import com.lightcrafts.ui.region.MinorRegionMode;
import com.lightcrafts.ui.region.RegionMode;
import com.lightcrafts.ui.region.RegionOverlay;
import com.lightcrafts.ui.region.TwoWayMultiMap;
import com.lightcrafts.utils.xml.XMLException;
import com.lightcrafts.utils.xml.XmlDocument;
import com.lightcrafts.utils.xml.XmlNode;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEditSupport;

class RegionModel {
    private static final boolean Debug = System.getProperty("lightcrafts.debug.regions") != null;
    private LinkedList listeners;
    private TwoWayMultiMap map;
    private RegionOverlay overlay;
    private Map contours;
    private CurveFactory factory;
    private CurveSelection selection;
    private Curve editingCurve;
    private MajorRegionMode majorMode;
    private MinorRegionMode minorMode;
    private UndoableEditSupport undoSupport;
    private RegionEdit currentEdit;
    private int batchEdit;
    private boolean isUndoing;
    private boolean isRestoring;
    private int batchNotify;
    private static final String ComponentTag = "Region";
    private static final String CurveTag = "Contour";
    private static final String ReferenceTag = "Reference";
    private static final String IndexTag = "Index";

    RegionModel(RegionOverlay overlay) {
        this.overlay = overlay;
        this.map = new TwoWayMultiMap();
        this.contours = new HashMap();
        this.factory = new CurveFactory();
        this.selection = new CurveSelection();
        this.undoSupport = new UndoableEditSupport();
        this.listeners = new LinkedList();
    }

    CurveSelection getSelection() {
        return this.selection;
    }

    void setEditingCurve(Curve curve) {
        if (this.editingCurve == curve) {
            return;
        }
        Curve oldCurve = this.editingCurve;
        Curve newCurve = curve;
        if (curve != null) {
            if (this.editingCurve != null) {
                this.setEditingCurve(null);
            }
            this.editingCurve = curve;
            this.selection.addCurve(this.editingCurve);
            this.notifyChangeStart(curve);
        } else {
            this.selection.removeCurve(this.editingCurve);
            this.notifyChangeEnd(this.editingCurve);
            this.editingCurve = null;
        }
        this.notifyListenersEditCurveChanged(oldCurve, newCurve);
    }

    boolean isEditingCurve(Curve curve) {
        return curve == this.editingCurve;
    }

    private RegionMode getMode() {
        return this.minorMode != null ? this.minorMode : this.majorMode;
    }

    void setMinorMode(MinorRegionMode newMode) {
        if (newMode == this.minorMode) {
            return;
        }
        RegionMode oldMode = this.getMode();
        if (oldMode == this.majorMode) {
            this.majorMode.modeExited();
        }
        this.minorMode = newMode;
        this.notifyModeChanged(oldMode, newMode);
    }

    void setMajorMode(MajorRegionMode newMode) {
        if (newMode == this.majorMode) {
            return;
        }
        RegionMode oldMode = this.getMode();
        if (oldMode == this.majorMode && this.majorMode != null) {
            this.majorMode.modeExited();
        }
        this.majorMode = newMode;
        this.minorMode = null;
        if (oldMode == null) {
            this.currentEdit = new RegionEdit();
        }
        newMode.modeEntered();
        this.setEditingCurve(newMode.getEditingCurve());
        this.notifyModeChanged(oldMode, newMode);
    }

    void setMajorModeWithoutExitOrEnter(MajorRegionMode newMode) {
        if (newMode == this.majorMode) {
            return;
        }
        RegionMode oldMode = this.getMode();
        this.majorMode = newMode;
        this.minorMode = null;
        this.setEditingCurve(newMode.getEditingCurve());
        this.notifyModeChanged(oldMode, newMode);
    }

    Set getComponents(Curve curve) {
        return this.map.getRight(curve);
    }

    Set getCurves(CurveComponent comp) {
        return this.map.getLeft(comp);
    }

    Set getAllComponents() {
        return this.map.getAllRight();
    }

    Set getAllCurves() {
        return this.map.getAllLeft();
    }

    void editStart() {
        ++this.batchEdit;
        this.dumpEdit("edit start");
    }

    void editEnd() {
        this.dumpEdit("edit end");
        if (--this.batchEdit == 0) {
            this.postEdit();
        }
    }

    void editCancel() {
        this.dumpEdit("edit cancel");
        --this.batchEdit;
    }

    private void dumpEdit(String s) {
        if (!Debug) {
            return;
        }
        System.out.print("|");
        for (int n = 0; n < this.batchEdit; ++n) {
            System.out.print("  ");
        }
        System.out.print(this.batchEdit);
        System.out.print(" ");
        System.out.println(s);
    }

    private void dumpNotify(String s) {
        if (!Debug) {
            return;
        }
        System.out.print("|");
        for (int n = 0; n < this.batchNotify; ++n) {
            System.out.print("  ");
        }
        System.out.print(this.batchNotify);
        System.out.print(" ");
        System.out.println(s);
    }

    private void dumpModeChange(RegionMode oldMode, RegionMode newMode) {
        if (Debug) {
            System.out.println("mode change: " + RegionModel.getNameOfMode(oldMode) + " -> " + RegionModel.getNameOfMode(newMode));
        }
    }

    private static String getNameOfMode(RegionMode mode) {
        if (mode != null) {
            return mode.getClass().getName().replaceAll(".*\\.", "");
        }
        return "null";
    }

    void notifyChangeStart(Curve curve) {
        Set comps = this.map.getRight(curve);
        this.overlay.regionBatchStart(comps);
        ++this.batchNotify;
        this.dumpNotify("change start");
    }

    void notifyChanged(Curve curve) {
        this.changeContour(curve);
        Set comps = this.map.getRight(curve);
        this.overlay.regionChanged(comps, curve);
        if (this.batchEdit == 0) {
            this.postEdit();
        }
    }

    void notifyTranslated(Curve curve, double dx, double dy) {
        this.translateContour(curve, dx, dy);
        Set comps = this.map.getRight(curve);
        this.overlay.regionChanged(comps, curve);
        if (this.batchEdit == 0) {
            this.postEdit();
        }
    }

    void notifyChangeEnd(Curve curve) {
        Set comps = this.map.getRight(curve);
        this.overlay.regionsBatchEnd(comps);
        this.dumpNotify("change end");
        --this.batchNotify;
    }

    void setNewCurveType(int type) {
        this.factory.setCurveType(type);
    }

    int getNewCurveType() {
        return this.factory.getCurveType();
    }

    Curve createCurve(CurveComponent comp) {
        Curve curve = this.factory.createCurve();
        this.addCurve(comp, curve);
        return curve;
    }

    Curve createCurve(CurveComponent comp, Point2D p) {
        Curve curve = this.factory.createCurve();
        Point2D.Double q = new Point2D.Double(p.getX() - 20.0, p.getY() - 20.0);
        curve.setClonePoint(q);
        this.addCurve(comp, curve);
        return curve;
    }

    Curve createSpotCurve(CurveComponent comp, Point2D p) {
        Curve curve = this.factory.createSpotCurve(p);
        this.addCurve(comp, curve);
        return curve;
    }

    void addCurve(CurveComponent comp, Curve curve) {
        this.map.put(curve, comp);
        this.addContour(curve);
        if (comp.showsClonePoints() && curve.getClonePoint() == null) {
            Rectangle2D bounds = curve.getBounds2D();
            Point2D.Double center = new Point2D.Double(bounds.getCenterX(), bounds.getCenterY());
            curve.setClonePoint(center);
            this.changeContour(curve);
        }
        Set<CurveComponent> comps = Collections.singleton(comp);
        this.overlay.regionChanged(comps, curve);
        if (this.batchEdit == 0) {
            this.postEdit();
        }
    }

    void removeCurve(CurveComponent comp, Curve curve) {
        if (this.selection.isSelected(curve)) {
            this.selection.removeCurve(curve);
        }
        if (this.isEditingCurve(curve)) {
            this.setEditingCurve(null);
        }
        this.map.remove(curve, comp);
        Set<CurveComponent> comps = Collections.singleton(comp);
        this.overlay.regionChanged(comps, curve);
        if (this.batchEdit == 0) {
            this.postEdit();
        }
    }

    void removeCurve(Curve curve) {
        Set comps = this.getComponents(curve);
        ++this.batchEdit;
        for (CurveComponent comp : comps) {
            this.removeCurve(comp, curve);
        }
        this.map.removeLeft(curve);
        this.removeContour(curve);
        --this.batchEdit;
        if (this.batchEdit == 0) {
            this.postEdit();
        }
    }

    void removeCurves() {
        Set curves = this.getAllCurves();
        ++this.batchEdit;
        for (Curve curve : curves) {
            this.removeCurve(curve);
        }
        --this.batchEdit;
        if (this.batchEdit == 0) {
            this.postEdit();
        }
    }

    void addComponent(CurveComponent comp) {
        this.map.addRight(comp);
    }

    void removeComponent(CurveComponent comp) {
        this.map.removeRight(comp);
    }

    Contour getContour(Curve curve) {
        return (Contour)this.contours.get(curve);
    }

    void setClonePoint(Curve curve, Point2D p) {
        curve.setClonePoint(p);
    }

    Point2D getClonePoint(Curve curve) {
        return curve.getClonePoint();
    }

    boolean hasClonePoint(Curve curve) {
        return this.getClonePoint(curve) != null;
    }

    private void addContour(Curve curve) {
        if (!this.contours.containsKey(curve)) {
            CurveContour contour = new CurveContour(curve);
            this.contours.put(curve, contour);
        }
    }

    private void changeContour(Curve curve) {
        CurveContour contour = new CurveContour(curve);
        this.contours.put(curve, contour);
    }

    private void translateContour(Curve curve, double dx, double dy) {
        CurveContour contour = (CurveContour)this.contours.get(curve);
        contour.addTranslation(new Point2D.Double(dx, dy));
    }

    private void removeContour(Curve curve) {
        this.contours.remove(curve);
    }

    void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    void notifyListenersEditCurveChanged(Curve oldCurve, Curve newCurve) {
        for (Listener listener : this.listeners) {
            listener.editingCurveChanged(oldCurve, newCurve);
        }
    }

    void notifyModeChanged(RegionMode oldMode, RegionMode newMode) {
        this.dumpModeChange(oldMode, newMode);
        for (Listener listener : this.listeners) {
            listener.modeChanged(oldMode, newMode);
        }
    }

    void addUndoableEditListener(UndoableEditListener listener) {
        this.undoSupport.addUndoableEditListener(listener);
    }

    void removeUndoableEditListener(UndoableEditListener listener) {
        this.undoSupport.removeUndoableEditListener(listener);
    }

    private void postEdit() {
        if (this.isRestoring || this.isUndoing) {
            return;
        }
        if (Debug) {
            System.out.println("post edit");
        }
        this.currentEdit.end();
        this.undoSupport.postEdit(this.currentEdit);
        this.currentEdit = new RegionEdit();
    }

    Curve getRestoredCurve(Curve old) {
        Set curves = this.getAllCurves();
        for (Curve curve : curves) {
            if (!curve.matches(old)) continue;
            return curve;
        }
        return null;
    }

    void save(List comps, XmlNode node) {
        Set curves = this.getAllCurves();
        HashMap<Curve, Integer> curveNumbers = new HashMap<Curve, Integer>();
        int count = 0;
        for (Curve curve : curves) {
            XmlNode curveNode = node.addChild(CurveTag);
            CurveFactory.save(curve, curveNode);
            curveNumbers.put(curve, count++);
        }
        for (CurveComponent comp : comps) {
            XmlNode compNode = node.addChild(ComponentTag);
            Set compCurves = this.getCurves(comp);
            for (Curve compCurve : compCurves) {
                Integer index = (Integer)curveNumbers.get(compCurve);
                XmlNode refNode = compNode.addChild(ReferenceTag);
                refNode.setAttribute(IndexTag, index.toString());
            }
        }
    }

    void restore(List comps, XmlNode node) throws XMLException {
        XmlNode[] curveNodes;
        this.isRestoring = true;
        HashMap<Integer, Curve> curveNumbers = new HashMap<Integer, Curve>();
        int count = 0;
        for (XmlNode curveNode : curveNodes = node.getChildren(CurveTag)) {
            Curve curve = CurveFactory.restore(curveNode);
            curve.restore(curveNode);
            curveNumbers.put(count++, curve);
        }
        XmlNode[] compNodes = node.getChildren(ComponentTag);
        if (compNodes.length != comps.size()) {
            throw new XMLException("The number of regions doesn't match the number of tools");
        }
        this.removeCurves();
        Iterator compIter = comps.iterator();
        for (XmlNode compNode : compNodes) {
            XmlNode[] refNodes;
            CurveComponent comp = (CurveComponent)compIter.next();
            for (XmlNode refNode : refNodes = compNode.getChildren(ReferenceTag)) {
                Integer index;
                String attr = refNode.getAttribute(IndexTag);
                try {
                    index = Integer.valueOf(attr);
                }
                catch (NumberFormatException e) {
                    throw new XMLException("Not a number: " + attr, e);
                }
                Curve curve = (Curve)curveNumbers.get(index);
                if (curve == null) {
                    throw new XMLException("Curve index out of bounds: " + attr);
                }
                this.addCurve(comp, curve);
            }
        }
        this.isRestoring = false;
    }

    void addSaved(List comps, XmlNode node) throws XMLException {
        XmlNode[] curveNodes;
        this.isRestoring = true;
        HashMap<Integer, Curve> curveNumbers = new HashMap<Integer, Curve>();
        int count = 0;
        for (XmlNode curveNode : curveNodes = node.getChildren(CurveTag)) {
            Curve curve = CurveFactory.restore(curveNode);
            curve.restore(curveNode);
            curveNumbers.put(count++, curve);
        }
        XmlNode[] compNodes = node.getChildren(ComponentTag);
        if (compNodes.length != comps.size()) {
            throw new XMLException("The number of regions doesn't match the number of tools");
        }
        Iterator compIter = comps.iterator();
        for (XmlNode compNode : compNodes) {
            XmlNode[] refNodes;
            CurveComponent comp = (CurveComponent)compIter.next();
            for (XmlNode refNode : refNodes = compNode.getChildren(ReferenceTag)) {
                Integer index;
                String attr = refNode.getAttribute(IndexTag);
                try {
                    index = Integer.valueOf(attr);
                }
                catch (NumberFormatException e) {
                    throw new XMLException("Expected a number: " + attr, e);
                }
                Curve curve = (Curve)curveNumbers.get(index);
                if (curve == null) {
                    throw new XMLException("Not a valid curve index: " + attr);
                }
                this.addCurve(comp, curve);
            }
        }
        this.isRestoring = false;
    }

    private class RegionEdit
    extends AbstractUndoableEdit {
        private static final String ModeTag = "mode";
        private XmlDocument beforeDoc = new XmlDocument("before");
        private XmlDocument afterDoc = new XmlDocument("after");
        private List beforeComps = new LinkedList();
        private List afterComps = new LinkedList();
        private MajorRegionMode beforeMode;
        private MajorRegionMode afterMode;

        private RegionEdit() {
            this.beforeComps = this.getCompsList();
            this.beforeMode = RegionModel.this.majorMode;
            XmlNode root = this.beforeDoc.getRoot();
            RegionModel.this.save(this.beforeComps, root);
            XmlNode modeNode = root.addChild(ModeTag);
            this.beforeMode.save(modeNode);
        }

        public void end() {
            this.afterComps = this.getCompsList();
            this.afterMode = RegionModel.this.majorMode;
            XmlNode root = this.afterDoc.getRoot();
            RegionModel.this.save(this.afterComps, root);
            XmlNode modeNode = root.addChild(ModeTag);
            this.afterMode.save(modeNode);
        }

        @Override
        public String getPresentationName() {
            return Locale.LOCALE.get("RegionChangeEditName");
        }

        @Override
        public void undo() {
            super.undo();
            if (RegionModel.this.minorMode != null) {
                throw new CannotUndoException();
            }
            try {
                this.restoreWithMode(this.beforeDoc, this.beforeComps, this.beforeMode);
                RegionModel.this.currentEdit = new RegionEdit();
            }
            catch (XMLException e) {
                CannotUndoException cue = new CannotUndoException();
                cue.initCause(e);
                throw cue;
            }
        }

        @Override
        public void redo() {
            super.redo();
            if (RegionModel.this.minorMode != null) {
                throw new CannotRedoException();
            }
            try {
                this.restoreWithMode(this.afterDoc, this.afterComps, this.afterMode);
                RegionModel.this.currentEdit = new RegionEdit();
            }
            catch (XMLException e) {
                CannotRedoException cre = new CannotRedoException();
                cre.initCause(e);
                throw cre;
            }
        }

        private List getCompsList() {
            Set comps = RegionModel.this.getAllComponents();
            LinkedList list = new LinkedList();
            Iterator i = comps.iterator();
            while (i.hasNext()) {
                list.add(i.next());
            }
            return list;
        }

        private void restoreWithMode(XmlDocument doc, List comps, MajorRegionMode newMode) throws XMLException {
            RegionModel.this.isUndoing = true;
            XmlNode root = doc.getRoot();
            MajorRegionMode oldMode = RegionModel.this.majorMode;
            oldMode.modeExited();
            RegionModel.this.restore(comps, root);
            XmlNode modeNode = root.getChild(ModeTag);
            newMode.restore(modeNode);
            RegionModel.this.majorMode = newMode;
            RegionModel.this.setEditingCurve(newMode.getEditingCurve());
            newMode.modeEntered();
            RegionModel.this.isUndoing = false;
            RegionModel.this.notifyModeChanged(oldMode, newMode);
        }
    }

    static interface Listener {
        public void editingCurveChanged(Curve var1, Curve var2);

        public void modeChanged(RegionMode var1, RegionMode var2);
    }
}

