/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.region;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class TwoWayMultiMap {
    private Map leftToRight = new HashMap();
    private Map rightToLeft = new HashMap();

    TwoWayMultiMap() {
    }

    void clear() {
        this.leftToRight.clear();
        this.rightToLeft.clear();
    }

    Set getLeft(Object right) {
        Set lefts = (Set)this.rightToLeft.get(right);
        if (lefts != null) {
            return new HashSet(lefts);
        }
        return null;
    }

    Set getRight(Object left) {
        Set rights = (Set)this.leftToRight.get(left);
        if (rights != null) {
            return new HashSet(rights);
        }
        return null;
    }

    Set getAllLeft() {
        return new HashSet(this.leftToRight.keySet());
    }

    Set getAllRight() {
        return new HashSet(this.rightToLeft.keySet());
    }

    void addLeft(Object left) {
        if (!this.leftToRight.containsKey(left)) {
            this.leftToRight.put(left, new HashSet());
        }
    }

    void addRight(Object right) {
        if (!this.rightToLeft.containsKey(right)) {
            this.rightToLeft.put(right, new HashSet());
        }
    }

    void put(Object left, Object right) {
        HashSet<Object> rights = (HashSet<Object>)this.leftToRight.get(left);
        if (rights == null) {
            rights = new HashSet<Object>();
            this.leftToRight.put(left, rights);
        }
        rights.add(right);
        HashSet<Object> lefts = (HashSet<Object>)this.rightToLeft.get(right);
        if (lefts == null) {
            lefts = new HashSet<Object>();
            this.rightToLeft.put(right, lefts);
        }
        lefts.add(left);
    }

    void remove(Object left, Object right) {
        Set lefts;
        Set rights = (Set)this.leftToRight.get(left);
        if (rights != null) {
            rights.remove(right);
        }
        if ((lefts = (Set)this.rightToLeft.get(right)) != null) {
            lefts.remove(left);
        }
    }

    void removeLeft(Object left) {
        Set rights = this.getRight(left);
        if (rights == null) {
            return;
        }
        for (Object right : rights) {
            this.remove(left, right);
        }
        this.leftToRight.remove(left);
    }

    void removeRight(Object right) {
        Set lefts = this.getLeft(right);
        if (lefts == null) {
            return;
        }
        for (Object left : lefts) {
            this.remove(left, right);
        }
        this.rightToLeft.remove(right);
    }
}

