/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.region.curves;

import com.lightcrafts.ui.region.curves.AbstractCurve;
import com.lightcrafts.utils.xml.XMLException;
import com.lightcrafts.utils.xml.XmlNode;
import java.awt.Rectangle;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.prefs.Preferences;

public class EllipticCurve
extends AbstractCurve {
    private static final Preferences Prefs = Preferences.userRoot().node("/com/lightcrafts/ui/region/curves");
    private static final String EllipticXTag = "SpotX";
    private static final String EllipticYTag = "SpotY";
    private static final String EllipticCloneXTag = "SpotCloneX";
    private static final String EllipticCloneYTag = "SpotCloneY";
    private static final double MIN_RADIUS = 0.5;
    private static double EllipticX = Math.max(Prefs.getDouble("SpotX", 30.0), 0.5);
    private static double EllipticY = Math.max(Prefs.getDouble("SpotY", 30.0), 0.5);
    private static double EllipticCloneX = Prefs.getDouble("SpotCloneX", EllipticX);
    private static double EllipticCloneY = Prefs.getDouble("SpotCloneY", 0.0);
    private boolean isManualWidthSet;

    public EllipticCurve() {
    }

    public EllipticCurve(Point2D upperLeft, Point2D lowerRight, Point2D clone) {
        this.addPoint(upperLeft);
        this.addPoint(lowerRight);
        this.setClonePoint(clone);
    }

    public EllipticCurve(Point2D center) {
        Point2D.Double upperLeft = new Point2D.Double(center.getX() - EllipticX, center.getY() - EllipticY);
        Point2D.Double lowerRight = new Point2D.Double(center.getX() + EllipticX, center.getY() + EllipticY);
        this.addPoint(upperLeft);
        this.addPoint(lowerRight);
        double scale = Math.min(2.0 * Math.abs(EllipticX), 2.0 * Math.abs(EllipticY));
        this.setWidth((float)scale / 6.0f);
        Point2D.Double clonePt = new Point2D.Double(center.getX() + EllipticCloneX, center.getY() + EllipticCloneY);
        this.setClonePoint(clonePt);
    }

    @Override
    public void movePoint(int n, Point2D p) {
        Point2D p1 = (Point2D)this.points.get(0);
        Point2D p2 = (Point2D)this.points.get(1);
        double centerX = (p1.getX() + p2.getX()) / 2.0;
        double centerY = (p1.getY() + p2.getY()) / 2.0;
        double dx = Math.max(p.getX() - centerX, 0.5);
        double dy = Math.max(p.getY() - centerY, 0.5);
        Point2D.Double q1 = new Point2D.Double(centerX + dx, centerY + dy);
        super.movePoint(n, q1);
        Point2D.Double q2 = new Point2D.Double(centerX - dx, centerY - dy);
        super.movePoint(1 - n, q2);
        p1 = (Point2D)this.points.get(0);
        p2 = (Point2D)this.points.get(1);
        EllipticX = (p1.getX() - p2.getX()) / 2.0;
        EllipticY = (p1.getY() - p2.getY()) / 2.0;
        if (!this.isManualWidthSet) {
            Rectangle bounds = this.shape.getBounds();
            double width = ((RectangularShape)bounds).getWidth();
            double height = ((RectangularShape)bounds).getHeight();
            double scale = Math.min(width, height);
            this.setWidth((float)scale / 6.0f);
            this.isManualWidthSet = false;
        }
        EllipticCurve.savePrefs();
    }

    @Override
    public void setClonePoint(Point2D p) {
        super.setClonePoint(p);
        Point2D p1 = (Point2D)this.points.get(0);
        Point2D p2 = (Point2D)this.points.get(1);
        EllipticCloneX = p.getX() - (p1.getX() + p2.getX()) / 2.0;
        EllipticCloneY = p.getY() - (p1.getY() + p2.getY()) / 2.0;
        EllipticCurve.savePrefs();
    }

    @Override
    public void setInnerShape(Point2D p) {
        super.setInnerShape(p);
        this.isManualWidthSet = true;
    }

    @Override
    public boolean allowsAddRemovePoints() {
        return false;
    }

    @Override
    public boolean isValidShape() {
        return this.points.size() == 2;
    }

    @Override
    public void restore(XmlNode node) throws XMLException {
        super.restore(node);
        this.isManualWidthSet = true;
    }

    @Override
    void updateShape() {
        if (this.points.size() != 2) {
            this.shape = new GeneralPath();
            return;
        }
        Point2D p1 = (Point2D)this.points.get(0);
        Point2D p2 = (Point2D)this.points.get(1);
        double minX = Math.min(p1.getX(), p2.getX());
        double minY = Math.min(p1.getY(), p2.getY());
        double maxX = Math.max(p1.getX(), p2.getX());
        double maxY = Math.max(p1.getY(), p2.getY());
        double x = minX;
        double y = minY;
        double w = maxX - minX;
        double h = maxY - minY;
        Rectangle2D.Double bounds = new Rectangle2D.Double(x, y, w, h);
        Arc2D.Double ne = new Arc2D.Double(bounds, -45.0, 180.0, 0);
        Arc2D.Double sw = new Arc2D.Double(bounds, 135.0, 180.0, 0);
        this.segments.clear();
        this.segments.add(ne);
        this.segments.add(sw);
        float[] start = new float[6];
        ne.getPathIterator(null).currentSegment(start);
        GeneralPath path = new GeneralPath();
        path.moveTo(start[0], start[1]);
        path.append(ne, true);
        path.append(sw, true);
        path.closePath();
        this.shape = path;
    }

    private static void savePrefs() {
        Prefs.putDouble(EllipticXTag, EllipticX);
        Prefs.putDouble(EllipticYTag, EllipticY);
        Prefs.putDouble(EllipticCloneXTag, EllipticCloneX);
        Prefs.putDouble(EllipticCloneYTag, EllipticCloneY);
    }
}

