/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.region.curves;

import com.lightcrafts.ui.region.curves.Polynomial;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;

class Quadratic
extends Polynomial {
    private double a;
    private double b;
    private double c;

    static Quadratic createFactored(double z0, double z1) {
        return new Quadratic(z0 * z1, -z0 - z1, 1.0);
    }

    Quadratic(double a, double b, double c) {
        super(a, b, c);
        this.a = a;
        this.b = b;
        this.c = c;
    }

    @Override
    Polynomial translate(double x) {
        return new Quadratic(this.a + this.b * x + this.c * x * x, this.b + 2.0 * this.c * x, this.c);
    }

    static Shape createShape(Polynomial x, Polynomial y) {
        if (x.getDegree() != 2 || y.getDegree() != 2) {
            throw new IllegalArgumentException("Expected degree 2");
        }
        double xa = x.getCoeff(0);
        double xb = x.getCoeff(1);
        double xc = x.getCoeff(2);
        double ya = y.getCoeff(0);
        double yb = y.getCoeff(1);
        double yc = y.getCoeff(2);
        Point2D.Double c1 = new Point2D.Double(xa, ya);
        Point2D.Double cp = new Point2D.Double((xb + 2.0 * xa) / 2.0, (yb + 2.0 * ya) / 2.0);
        Point2D.Double c2 = new Point2D.Double(xa + xb + xc, ya + yb + yc);
        return new QuadCurve2D.Double(((Point2D)c1).getX(), ((Point2D)c1).getY(), ((Point2D)cp).getX(), ((Point2D)cp).getY(), ((Point2D)c2).getX(), ((Point2D)c2).getY());
    }
}

