/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.region.curves;

import com.lightcrafts.ui.region.curves.BasisFunction;
import com.lightcrafts.ui.region.curves.Polynomial;
import com.lightcrafts.ui.region.curves.Quadratic;

class QuadraticBasisFunction
extends BasisFunction {
    QuadraticBasisFunction(int i) {
        super(i, 2);
    }

    @Override
    Polynomial computeSegment(int j) {
        int i = this.getFirstIndex();
        double t0 = i + 0;
        double t1 = i + 1;
        double t2 = i + 2;
        double t3 = i + 3;
        if (j == i) {
            return Quadratic.createFactored(t0, t0).divide(2.0);
        }
        if (j == i + 1) {
            Quadratic q1 = Quadratic.createFactored(t0, t2);
            Quadratic q2 = Quadratic.createFactored(t1, t3);
            return q1.add(q2).divide(-2.0);
        }
        if (j == i + 2) {
            return Quadratic.createFactored(t3, t3).divide(2.0);
        }
        return new Polynomial(0.0);
    }
}

