/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.rotate;

import com.lightcrafts.ui.editor.Editor;
import com.lightcrafts.ui.mode.AbstractMode;
import com.lightcrafts.ui.rotate.GridComponent;
import com.lightcrafts.ui.rotate.RotorControl;
import com.lightcrafts.ui.rotate.RotorListener;
import java.awt.Image;
import java.awt.Toolkit;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.event.MouseInputListener;

public class RotorMode
extends AbstractMode {
    private GridComponent overlay;
    private RotorControl control = new RotorControl();

    public RotorMode() {
        this.control.addRotorListener(new RotorListener(){
            private double startAngle;

            @Override
            public void angleChanged(double angle, boolean isChanging, boolean isNinetyDegrees) {
                if (!isChanging) {
                    this.startAngle = angle;
                }
                RotorMode.this.overlay.setAngle(this.startAngle - angle);
                RotorMode.this.overlay.setShowGrid(isChanging);
            }

            @Override
            public void angleReset() {
                this.angleChanged(0.0, false, false);
            }
        });
        this.overlay = new GridComponent(this.control);
        this.overlay.setAngle(0.0);
        this.overlay.setSpacing(40.0);
        this.overlay.setShowGrid(false);
    }

    public void addRotorListener(RotorListener listener) {
        this.control.addRotorListener(listener);
    }

    public void removeRotorListener(RotorListener listener) {
        this.control.removeRotorListener(listener);
    }

    public RotorControl getControl() {
        return this.control;
    }

    public double getAngle() {
        return this.control.getAngle();
    }

    public void setAngle(double angle) {
        this.control.setAngleInternal(angle);
        this.overlay.setAngle(angle);
    }

    @Override
    public JComponent getOverlay() {
        return this.overlay;
    }

    @Override
    public void addMouseInputListener(MouseInputListener listener) {
        this.overlay.addMouseListener(listener);
        this.overlay.addMouseMotionListener(listener);
    }

    @Override
    public void removeMouseInputListener(MouseInputListener listener) {
        this.overlay.removeMouseListener(listener);
        this.overlay.removeMouseMotionListener(listener);
    }

    @Override
    public boolean wantsAutocroll() {
        return true;
    }

    static Icon getIcon(String name) {
        String path = "resources/" + name + ".png";
        URL url = RotorMode.class.getResource(path);
        Image image = Toolkit.getDefaultToolkit().createImage(url);
        return new ImageIcon(image);
    }

    public void setEditor(Editor editor) {
        this.control.setEditor(editor);
    }
}

