/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.rotate;

import com.lightcrafts.ui.LightZoneSkin;
import com.lightcrafts.ui.rotate.Locale;
import com.lightcrafts.ui.rotate.RotorControl;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

class RotorTextField
extends JTextField
implements DocumentListener,
MouseWheelListener {
    private static final NumberFormat Format = new DecimalFormat("+0.00;-0.00");
    private static final String TooltipText = Locale.LOCALE.get("RotorTextToolTip");
    private RotorControl control;
    private boolean isUpdating;

    RotorTextField(RotorControl control) {
        this.control = control;
        this.setHorizontalAlignment(4);
        this.setToolTipText(TooltipText);
        this.setText("+100.00");
        Dimension size = this.getPreferredSize();
        this.setMinimumSize(size);
        this.setPreferredSize(size);
        this.setMaximumSize(size);
        this.update();
        this.setInputVerifier(new AngleVerifier());
        Document doc = this.getDocument();
        doc.addDocumentListener(this);
        this.addMouseWheelListener(this);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent event) {
                RotorTextField.this.selectAll();
            }
        });
    }

    void update() {
        double angle = this.control.getDegrees();
        String text = Format.format(angle);
        this.isUpdating = true;
        this.setText(text);
        this.isUpdating = false;
    }

    @Override
    public void changedUpdate(DocumentEvent event) {
        this.handleDocumentChange();
    }

    @Override
    public void insertUpdate(DocumentEvent event) {
        this.handleDocumentChange();
    }

    @Override
    public void removeUpdate(DocumentEvent event) {
        this.handleDocumentChange();
    }

    private void handleDocumentChange() {
        if (this.isUpdating) {
            return;
        }
        InputVerifier verifier = this.getInputVerifier();
        boolean verified = verifier.verify(this);
        if (!verified) {
            this.setForeground(Color.red);
        } else {
            String text = this.getText();
            try {
                this.setForeground(LightZoneSkin.Colors.ToolPanesForeground);
                double value = Format.parse(text).doubleValue();
                this.control.setDegrees(value);
            }
            catch (ParseException e) {
                System.err.println("Unparsable verified text: " + text);
                this.setForeground(Color.red);
            }
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        InputVerifier verifier = this.getInputVerifier();
        boolean verified = verifier.verify(this);
        if (verified) {
            int count = e.getWheelRotation();
            String text = this.getText();
            try {
                double value = Format.parse(text).doubleValue();
                value -= 0.1 * (double)count;
                value = (double)Math.round(10.0 * value) / 10.0;
                this.control.setDegrees(value);
                this.update();
                this.selectAll();
            }
            catch (ParseException e1) {
                System.err.println("Unparsable verified text: " + text);
            }
        }
    }

    private class AngleVerifier
    extends InputVerifier {
        private AngleVerifier() {
        }

        @Override
        public boolean verify(JComponent input) {
            String text = RotorTextField.this.getText();
            try {
                Format.parse(text);
                return true;
            }
            catch (ParseException e) {
                return false;
            }
        }
    }
}

