/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.scroll;

import com.lightcrafts.ui.scroll.ScrollMode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.JViewport;

public class Panner
extends JComponent
implements MouseListener,
MouseMotionListener {
    private static final int Size = 100;
    private JScrollPane scroll;
    private Point2D startPt;
    private Rectangle2D startRect;
    private boolean isDragging;
    private boolean isMouseInside;

    public Panner(JScrollPane scroll) {
        this.scroll = scroll;
        AdjustmentListener repainter = new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                boolean wasEnabled = Panner.this.isEnabled();
                Panner.this.updateEnabled();
                if (Panner.this.isEnabled() || wasEnabled) {
                    Panner.this.repaint();
                }
            }
        };
        JScrollBar hBar = scroll.getHorizontalScrollBar();
        JScrollBar vBar = scroll.getVerticalScrollBar();
        hBar.addAdjustmentListener(repainter);
        vBar.addAdjustmentListener(repainter);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.startPt = e.getPoint();
        this.startRect = this.getViewportBounds();
        this.isDragging = true;
        this.setCursor(ScrollMode.ClosedHand);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        Point p = e.getPoint();
        if (this.startPt.equals(p)) {
            this.doBlockScroll(p);
        }
        this.setCursor(ScrollMode.OpenHand);
        this.isDragging = false;
        if (!this.isMouseInside) {
            this.repaint();
        }
    }

    private void doBlockScroll(Point p) {
        int dx = 0;
        int dy = 0;
        Rectangle2D rect = this.getViewportBounds();
        double angle = Math.atan2((double)p.y - rect.getCenterY(), (double)p.x - rect.getCenterX());
        double neAngle = Math.atan2(rect.getMinY() - rect.getCenterY(), rect.getMaxX() - rect.getCenterX());
        double seAngle = Math.atan2(rect.getMaxY() - rect.getCenterY(), rect.getMaxX() - rect.getCenterX());
        double swAngle = Math.atan2(rect.getMaxY() - rect.getCenterY(), rect.getMinX() - rect.getCenterX());
        double nwAngle = Math.atan2(rect.getMinY() - rect.getCenterY(), rect.getMinX() - rect.getCenterX());
        if (angle > swAngle || angle < nwAngle) {
            dx = -1;
        }
        if (angle > nwAngle && angle < neAngle) {
            dy = -1;
        }
        if (angle > neAngle && angle < seAngle) {
            dx = 1;
        }
        if (angle > seAngle && angle < swAngle) {
            dy = 1;
        }
        Rectangle2D.Double pannerRect = new Rectangle2D.Double(this.startRect.getX() + (double)dx * rect.getWidth(), this.startRect.getY() + (double)dy * rect.getHeight(), this.startRect.getWidth(), this.startRect.getHeight());
        this.repaint();
        try {
            AffineTransform xform = this.getTransform();
            xform = xform.createInverse();
            Rectangle2D viewportRect = xform.createTransformedShape(pannerRect).getBounds2D();
            Rectangle intRect = new Rectangle((int)Math.round(viewportRect.getX()), (int)Math.round(viewportRect.getY()), (int)Math.round(viewportRect.getWidth()), (int)Math.round(viewportRect.getHeight()));
            JComponent view = (JComponent)this.scroll.getViewport().getView();
            view.scrollRectToVisible(intRect);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.isMouseInside = true;
        this.repaint();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.isMouseInside = false;
        if (!this.isDragging) {
            this.repaint();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        Point p = e.getPoint();
        Point2D.Double dp = new Point2D.Double(((Point2D)p).getX() - this.startPt.getX(), ((Point2D)p).getY() - this.startPt.getY());
        Rectangle2D.Double pannerRect = new Rectangle2D.Double(this.startRect.getX() + ((Point2D)dp).getX(), this.startRect.getY() + ((Point2D)dp).getY(), this.startRect.getWidth(), this.startRect.getHeight());
        this.repaint();
        try {
            AffineTransform xform = this.getTransform();
            xform = xform.createInverse();
            Rectangle2D viewportRect = xform.createTransformedShape(pannerRect).getBounds2D();
            Rectangle intRect = new Rectangle((int)Math.round(viewportRect.getX()), (int)Math.round(viewportRect.getY()), (int)Math.round(viewportRect.getWidth()), (int)Math.round(viewportRect.getHeight()));
            JComponent view = (JComponent)this.scroll.getViewport().getView();
            view.scrollRectToVisible(intRect);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(100, 100);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (this.isEnabled()) {
            Graphics2D g = (Graphics2D)graphics;
            Stroke oldStroke = g.getStroke();
            Color oldColor = g.getColor();
            Rectangle2D outer = this.getViewBounds();
            outer.setRect(outer.getX() - 1.0, outer.getY() - 1.0, outer.getWidth() + 2.0, outer.getHeight() + 2.0);
            g.setColor(new Color(128, 128, 128, 128));
            g.fill(outer);
            if (this.isDragging || this.isMouseInside) {
                g.setColor(Color.white);
            } else {
                g.setColor(Color.lightGray);
            }
            g.draw(outer);
            Rectangle2D inner = this.getViewportBounds();
            g.setColor(new Color(255, 0, 0, 128));
            g.fill(inner);
            g.setColor(Color.red);
            g.draw(inner);
            g.setColor(oldColor);
            g.setStroke(oldStroke);
        }
    }

    private Rectangle2D getViewBounds() {
        Dimension viewSize = this.scroll.getViewport().getView().getSize();
        Rectangle viewRect = new Rectangle(0, 0, viewSize.width, viewSize.height);
        AffineTransform xform = this.getTransform();
        Shape pannerRect = xform.createTransformedShape(viewRect);
        return pannerRect.getBounds2D();
    }

    private Rectangle2D getViewportBounds() {
        JViewport viewport = this.scroll.getViewport();
        Rectangle viewportRect = viewport.getViewRect();
        AffineTransform xform = this.getTransform();
        Shape pannerRect = xform.createTransformedShape(viewportRect);
        return pannerRect.getBounds2D();
    }

    private AffineTransform getTransform() {
        double y;
        double x;
        double h;
        double w;
        Dimension size = this.getSize();
        Insets insets = this.getInsets();
        size.width -= insets.left + insets.right + 1;
        size.height -= insets.top + insets.bottom + 1;
        JViewport viewport = this.scroll.getViewport();
        Component view = viewport.getView();
        Dimension viewSize = view.getSize();
        double ratio = (double)viewSize.width / (double)viewSize.height;
        if (ratio < 1.0) {
            w = (double)size.height * ratio;
            h = size.height;
            x = ((double)size.width - w) / 2.0;
            y = 0.0;
        } else {
            w = size.width;
            h = (double)size.width / ratio;
            x = 0.0;
            y = ((double)size.height - h) / 2.0;
        }
        AffineTransform scale = AffineTransform.getScaleInstance(w / (double)viewSize.width, h / (double)viewSize.height);
        AffineTransform trans = AffineTransform.getTranslateInstance(x + (double)insets.left, y + (double)insets.top);
        trans.concatenate(scale);
        return trans;
    }

    private void updateEnabled() {
        JScrollBar hBar = this.scroll.getHorizontalScrollBar();
        JScrollBar vBar = this.scroll.getVerticalScrollBar();
        this.setEnabled(Panner.isActive(hBar) || Panner.isActive(vBar));
    }

    private static boolean isActive(JScrollBar bar) {
        int extent;
        BoundedRangeModel model = bar.getModel();
        int range = model.getMaximum() - model.getMinimum();
        return range > (extent = model.getExtent()) + 1;
    }

    public static void main(String[] args) {
        JTree comp = new JTree();
        JScrollPane scroll = new JScrollPane(comp);
        Panner panner = new Panner(scroll);
        JFrame scrollFrame = new JFrame("Scroll");
        scrollFrame.setContentPane(scroll);
        scrollFrame.setSize(new Dimension(100, 100));
        scrollFrame.setLocationRelativeTo(null);
        scrollFrame.setVisible(true);
        JFrame panFrame = new JFrame("Pane");
        panFrame.getContentPane().setLayout(new FlowLayout());
        panFrame.getContentPane().add(panner);
        panFrame.pack();
        panFrame.setVisible(true);
    }
}

